/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.IPlatform;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.CubicCurve2D;
import java.util.Observable;
import java.util.Observer;

public class ML2PortGraphic
extends Polygon
implements Observer {
    private static final int PORT_BORDER = 2;
    private CardGraphic parent;
    private PortModel portModel;
    private InterfaceModel ifModel;
    private Color currentColor = ElementDefaults.OOS_DSBLD_COLOR;
    private String statusString = "";
    private String alarmProfileString = "";
    private EntityCellRenderer myPortRenderer = new EntityCellRenderer();
    private int currentAdminState = -1;
    private int currentServiceStateType = -1;
    private int currentSeverity = 0;
    private int loopbackType = 0;
    private Rectangle connector1;
    private Rectangle connector2;
    private Polygon inner;
    private int slotNo;
    private int portNo;
    private int x1Offset;
    private int x2Offset;
    private int y1Offset;
    private int y2Offset;
    private IPlatform pci;
    private TDMTerminology terms;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "ML2PortGraphic");

    public ML2PortGraphic(CardGraphic cardGraphic, int n, int n2, int n3, int n4, PortModel portModel) {
        this.parent = cardGraphic;
        this.portModel = portModel;
        this.ifModel = (InterfaceModel)portModel.getInterfaceModel();
        this.slotNo = portModel.getSlot();
        this.portNo = portModel.getPort();
        this.pci = this.ifModel.getNodeModelDelegate().getPlatform();
        this.terms = portModel.getNodeModel().getTDMTerminology();
        this.getLoopbackType();
        if (this.pci.positionPortsVertically()) {
            if (portModel.getModuleModel().getEqType() == 283 || portModel.getModuleModel().getEqType() == 285) {
                this.createSmallMiniPorts(n, n2, n3, n4);
            } else if (portModel.getEqType() == 230) {
                this.createStandardPorts(n, n2, n3, n4);
            } else {
                this.createMiniPorts(n, n2, n3, n4);
            }
        } else {
            this.createEtherPorts(n, n2, n3, n4);
        }
        Thread thread = new Thread("ML2PortGraphic Init:" + this.slotNo + ":" + this.portNo){

            @Override
            public void run() {
                ML2PortGraphic.this.registerWithModel();
                ML2PortGraphic.this.updateCurrentState();
            }
        };
        thread.start();
    }

    private void createStandardPorts(int n, int n2, int n3, int n4) {
        this.addPoint(n, n2);
        this.addPoint(n + n3, n2);
        this.addPoint(n + n3, n2 + n4);
        this.addPoint(n, n2 + n4);
        ICardPainter iCardPainter = this.parent.getCardPainter();
        this.x1Offset = n + iCardPainter.getPortConn1X();
        this.y1Offset = n2 + iCardPainter.getPortConn1Y();
        this.x2Offset = n + iCardPainter.getPortConn2X();
        this.y2Offset = n2 + iCardPainter.getPortConn2Y();
        this.connector1 = new Rectangle(this.x1Offset, this.y1Offset, 2, 2);
        this.connector2 = new Rectangle(this.x2Offset, this.y2Offset, 2, 2);
    }

    private void createMiniPorts(int n, int n2, int n3, int n4) {
        this.addPoint(n, n2);
        this.addPoint(n + n3, n2);
        this.addPoint(n + n3, n2 + n4);
        this.addPoint(n, n2 + n4);
        ICardPainter iCardPainter = this.parent.getCardPainter();
        this.x1Offset = n + iCardPainter.getPortConn1X();
        this.y1Offset = n2 + iCardPainter.getSmallPortConn1Y();
        this.x2Offset = n + iCardPainter.getPortConn2X();
        this.y2Offset = n2 + iCardPainter.getSmallPortConn2Y();
        this.connector1 = new Rectangle(this.x1Offset, this.y1Offset, 2, 2);
        this.connector2 = new Rectangle(this.x2Offset, this.y2Offset, 2, 2);
    }

    private void createSmallMiniPorts(int n, int n2, int n3, int n4) {
        this.addPoint(n, n2);
        this.addPoint(n + n3, n2);
        this.addPoint(n + n3, n2 + n4);
        this.addPoint(n, n2 + n4);
        ICardPainter iCardPainter = this.parent.getCardPainter();
        this.x1Offset = n + iCardPainter.getPortConn1X();
        this.y1Offset = n2 + iCardPainter.getSmallerPortConn1Y();
        this.x2Offset = n + iCardPainter.getPortConn2X();
        this.y2Offset = n2 + iCardPainter.getSmallerPortConn2Y();
        this.connector1 = new Rectangle(this.x1Offset, this.y1Offset, 2, 2);
        this.connector2 = new Rectangle(this.x2Offset, this.y2Offset, 2, 2);
    }

    private void createEtherPorts(int n, int n2, int n3, int n4) {
        int n5 = n3 / 5;
        int n6 = n4 / 5;
        this.addPoint(n, n2 + n6);
        this.addPoint(n + n5, n2 + n6);
        this.addPoint(n + n5, n2);
        this.addPoint(n + n3 - n5, n2);
        this.addPoint(n + n3 - n5, n2 + n6);
        this.addPoint(n + n3, n2 + n6);
        this.addPoint(n + n3, n2 + n4);
        this.addPoint(n, n2 + n4);
        this.inner = new Polygon();
        this.inner.addPoint(n + 2, n2 + n6 + 2);
        this.inner.addPoint(n + n5 + 2, n2 + n6 + 2);
        this.inner.addPoint(n + n5 + 2, n2 + 2);
        this.inner.addPoint(n + n3 - n5 - 2, n2 + 2);
        this.inner.addPoint(n + n3 - n5 - 2, n2 + n6 + 2);
        this.inner.addPoint(n + n3 - 2, n2 + n6 + 2);
        this.inner.addPoint(n + n3 - 2, n2 + n4 - 2);
        this.inner.addPoint(n + 2, n2 + n4 - 2);
        n5 = (int)(this.inner.getBounds().getWidth() / 2.0 / 2.0);
        this.x1Offset = n + 2 + n5;
        this.x2Offset = n + 2 + n5 * 3;
        n6 = (int)((this.inner.getBounds().getHeight() + (double)n6) / 2.0);
        this.y2Offset = this.y1Offset = n2 + n6;
        this.connector1 = new Rectangle(this.x1Offset, this.y1Offset, 2, 2);
        this.connector2 = new Rectangle(this.x2Offset, this.y2Offset, 2, 2);
    }

    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle;
        double d = this.x1Offset;
        double d2 = this.y1Offset;
        double d3 = this.x2Offset;
        double d4 = this.y2Offset;
        double d5 = Math.min(d2, d4);
        double d6 = Math.max(d2, d4);
        double d7 = Math.min(d, d3);
        double d8 = Math.max(d, d3);
        CubicCurve2D.Double double_ = null;
        if (this.pci.positionPortsVertically()) {
            rectangle = this.getBounds();
            graphics2D.setColor(this.getCurrentColor());
            graphics2D.fill(this);
            graphics2D.setColor(Color.black);
            graphics2D.draw(this);
        } else {
            rectangle = this.inner.getBounds();
            graphics2D.setColor(Color.gray);
            graphics2D.fill(this);
            graphics2D.setColor(this.getCurrentColor());
            graphics2D.fill(this.inner);
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.inner);
            graphics2D.draw(this);
        }
        graphics2D.fill(this.connector1);
        graphics2D.fill(this.connector2);
        if (this.loopbackType == 2) {
            double_ = this.pci.positionPortsVertically() ? new CubicCurve2D.Double(d, d2, d - rectangle.getWidth() / 2.25, Math.abs(d2 - d4) / 100.0 + d5, d3 - rectangle.getWidth() / 2.25, d6 - Math.abs(d2 - d4) / 100.0, d3, d4) : new CubicCurve2D.Double(d, d2, d7 + (d8 - d7) / 5.0, d2 + rectangle.getHeight() / 1.7, d8 - (d8 - d7) / 100.0, d4 + rectangle.getHeight() / 1.7, d3, d4);
            G1000CardView.drawArrow(graphics2D, this.getBounds(), true, true, this.pci.is310cl(), Color.gray);
        } else if (this.loopbackType == 1) {
            double_ = this.pci.positionPortsVertically() ? new CubicCurve2D.Double(d, d2, d + rectangle.getWidth() / 2.25, Math.abs(d2 - d4) / 100.0 + d5, d3 + rectangle.getWidth() / 2.25, d6 - Math.abs(d2 - d4) / 100.0, d3, d4) : new CubicCurve2D.Double(d, d2, (d8 - d7) / 5.0 + d7, d2 - rectangle.getHeight() / 2.5, d8 - (d8 - d7) / 100.0, d4 - rectangle.getHeight() / 2.5, d3, d4);
        }
        if (double_ != null) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.gray);
            graphics2D.draw(double_);
            graphics2D.setColor(color);
        }
    }

    private void getLoopbackType() {
        block3: {
            ML2EtherLineModel mL2EtherLineModel;
            if (this.ifModel instanceof ML2EtherLineModel && (mL2EtherLineModel = (ML2EtherLineModel)this.ifModel).isInMapperMode()) {
                try {
                    this.loopbackType = mL2EtherLineModel.getLoopbackAsInt();
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got state changed message ");
            }
            this.getLoopbackType();
            this.updateCurrentState();
        }
    }

    public String getTooltipText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPortDescription());
        try {
            stringBuffer.append(this.statusString);
            stringBuffer.append(", Alarm Profile: ");
            stringBuffer.append(this.alarmProfileString);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Failed trying to generate tooltip string: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
            stringBuffer = new StringBuffer("");
        }
        return stringBuffer.toString();
    }

    protected String getPortDescription() {
        StringBuffer stringBuffer = new StringBuffer("Port ");
        stringBuffer.append(this.myPortRenderer.getPortString(this.portModel, false));
        stringBuffer.append(", ");
        return stringBuffer.toString();
    }

    protected void setAlarmState(int n) {
        if (db.on()) {
            db.println("set alrm st=" + n);
        }
        if (this.currentSeverity != n) {
            this.currentSeverity = n;
            if (this.currentAdminState == 0) {
                this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, n);
                this.parent.repaint();
            }
        }
    }

    private void updateCurrentState() {
        int n;
        int n2;
        block7: {
            try {
                this.alarmProfileString = this.portModel.getAlarmProfileName();
            }
            catch (Exception exception) {
                this.alarmProfileString = "(Error Retrieving)";
            }
            n2 = -1;
            n = -1;
            try {
                if (this.ifModel != null) {
                    n2 = this.ifModel.getAdminState();
                    n = this.ifModel.getServiceSt().getType();
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block7;
                db.println("Caught exception in updateCurrentState");
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if (this.currentServiceStateType != n) {
            this.currentServiceStateType = n;
            this.statusString = this.terms.getTermForServiceState(this.currentServiceStateType);
        }
        if (n2 != this.currentAdminState) {
            this.currentAdminState = n2;
            this.currentColor = AbstractPortGraphic.getPortColorByAdminStateAndSeverity(this.currentAdminState, this.currentSeverity);
        }
        this.parent.repaint();
    }

    protected Color getCurrentColor() {
        return this.currentColor;
    }

    private void registerWithModel() {
        if (this.ifModel != null) {
            if (db.on()) {
                db.println("registering with " + this.ifModel);
            }
            this.ifModel.addObserver(this);
        }
    }

    public void dispose() {
        if (this.ifModel != null) {
            if (db.on()) {
                db.println("Deleting observer " + this.ifModel + " Slot " + this.slotNo);
            }
            this.ifModel.deleteObserver(this);
        }
    }
}

