/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.AdminState;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.ML2PosPortProvTableModel;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ML2PosPortProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    private ML2PosPortProvTableModel dataModel = null;
    private ML2ModuleModel eqpmtModel = null;
    private ML2PosPortModel[] portModels = null;
    private ML2PosLineModel[] lineModels = null;
    private JComboBox frmTypeCombo;
    private static final SDebug db = new SDebug("ML2PosPortProvPane");

    public ML2PosPortProvPane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = mL2ModuleModel;
        this.portModels = mL2ModuleModel.getPosPortModels();
        this.lineModels = mL2ModuleModel.getPosLineModels();
        if (mL2ModuleModel == null || this.portModels == null || this.lineModels == null || this.portModels.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + mL2ModuleModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new ML2PosPortProvTableModel(mL2ModuleModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.setTableHeader(new UTableHeader(this.table.getColumnModel()));
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    private void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(50);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getAdminStateAttrs())));
        tableColumn.setPreferredWidth(75);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        tableColumn.setPreferredWidth(75);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        tableColumn.setPreferredWidth(50);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(ML2PosPortProvTableModel.columnNames[5]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        if (this.eqpmtModel.isInMapperMode()) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
            this.frmTypeCombo = this.getComboBoxFor(this.dataModel.getPosFramingTypeAttrs());
            tableColumn.setCellEditor(new DefaultCellEditor(this.frmTypeCombo));
            tableColumn.setPreferredWidth(100);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEncapCrcTypeAttrs())));
            tableColumn.setPreferredWidth(100);
            this.removeColumn(4);
        } else {
            this.removeColumn(3);
            this.removeColumn(7);
            this.removeColumn(8);
        }
        this.table.sizeColumnsToFit(-1);
    }

    private void removeColumn(int n) {
        String string;
        TableColumn tableColumn;
        if (n >= 0 && n < ML2PosPortProvTableModel.columnNames.length && (tableColumn = this.table.getColumn(string = ML2PosPortProvTableModel.columnNames[n])) != null) {
            this.table.removeColumn(tableColumn);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("enteringPage");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("leavingPage");
        }
        super.leavingPage();
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (!this.preApply()) {
            return;
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (this.dataModel.validateChanges(i)) {
                this.dataModel.applyToModel(i);
                continue;
            }
            vector.add(new Integer(this.portModels[i].getPort()));
        }
        if (vector.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (vector.size() > 1) {
                stringBuffer.append("s ");
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append((Integer)vector.get(i));
                    if (i < vector.size() - 1) {
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(" " + (Integer)vector.get(0));
            }
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_ML2_PORT_CHANGE_DISALLOWED_PARAM_2, stringBuffer, this.terms.getTermForAdminState(0));
        } else {
            this.resetDirty();
        }
    }

    private boolean preApply() throws Exception {
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, false, true);
            stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            return CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return true;
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public CSHelpID getHelpID() {
        if (this.eqpmtModel == null) {
            return CSHelpConst.ML2PosPortProvPane;
        }
        if (this.eqpmtModel.isInMapperMode()) {
            return CSHelpConst.ML2PosPortProvPane;
        }
        return CSHelpConst.ML2LxPosPortProvPane;
    }

    class UTableHeader
    extends JTableHeader {
        TableColumnModel columnModel;

        public UTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.columnModel = tableColumnModel;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnModel.getColumnIndexAtX(point.x);
            int n2 = this.columnModel.getColumn(n).getModelIndex();
            ML2PosPortProvPane.this.dataModel;
            return ML2PosPortProvTableModel.columnToolTips[n2];
        }
    }
}

