/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Epos.eCppFailAction;
import cerent.cms.idl.Epos.eCppProtState;
import cerent.cms.idl.Epos.sCppGrpAttributes;
import cerent.cms.idl.Epos.sCppPortAttributes;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class ML2ProtectionPortTableModel
extends AbstractTableModel {
    public static final int PORT_NUMBER_INDEX = 0;
    public static final int PROTECTION_STATE_INDEX = 1;
    public static final int PORT_CHANNEL_GRP_NUM = 2;
    public static final int PROT_GRP_NUM = 3;
    private String[] columnNames = new String[]{"Port", "Protection State", "Port Channel Number", "Protection Group Number"};
    private ML2ModuleModel moduleModel = null;
    private sCppPortAttributes[] cppAttributes;
    private sCppPortAttributes[] cppAttributesLen;
    private sCppGrpAttributes[] cppGrpAttrs;
    private boolean[] grpMatchForPort;
    private int numLines;
    private static final SDebug db = new SDebug("ML2ProtectionPortTableModel");

    public ML2ProtectionPortTableModel(ML2ModuleModel mL2ModuleModel) {
        this.moduleModel = mL2ModuleModel;
        try {
            int n = 0;
            this.cppAttributesLen = this.moduleModel.getCPPPortAttributesList();
            for (int i = 0; i < this.cppAttributesLen.length; ++i) {
                if (this.cppAttributesLen[i].isCPPValid) {
                    // empty if block
                }
                this.numLines = ++n;
            }
            this.grpMatchForPort = new boolean[this.numLines];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = "";
        String string2 = null;
        switch (n2) {
            case 0: {
                int n3 = -1;
                IEntityModel iEntityModel = null;
                if (this.cppAttributes[n] != null) {
                    iEntityModel = this.getPort(this.cppAttributes[n].portIndex);
                    if (this.cppAttributes[n].portIndex > 0 && this.cppAttributes[n].portIndex < 11) {
                        string2 = "Port-channel" + this.cppAttributes[n].portIndex;
                        return string2;
                    }
                    if (iEntityModel.getEqType() == 165) {
                        n3 = iEntityModel.getPort();
                        string2 = "POS" + n3;
                        return string2;
                    }
                    if (iEntityModel.getEqType() == 166) {
                        n3 = iEntityModel.getPort();
                        string2 = "Gigabit Ethernet" + n3;
                        return string2;
                    }
                }
            }
            case 1: {
                IEntityModel iEntityModel = null;
                String string3 = null;
                if (this.cppAttributes[n] != null) {
                    iEntityModel = this.getPort(this.cppAttributes[n].portIndex);
                    if (iEntityModel != null && iEntityModel.getEqType() == 166 && this.cppAttributes[n].portChanGrpNum > 0) {
                        return "NA";
                    }
                    if (iEntityModel != null && iEntityModel.getEqType() == 165 && this.grpMatchForPort[n]) {
                        return "NA";
                    }
                    string3 = this.getProtState(this.cppAttributes[n].portProtState);
                }
                return string3;
            }
            case 2: {
                if (this.cppAttributes[n] != null) {
                    if (this.cppAttributes[n].portIndex > 0 && this.cppAttributes[n].portIndex < 11) {
                        return "NA";
                    }
                    short s = this.cppAttributes[n].portChanGrpNum;
                    if (s > 0) {
                        return (int)s;
                    }
                    return "NA";
                }
            }
            case 3: {
                if (this.cppAttributes[n] == null) break;
                short s = this.cppAttributes[n].groupNum;
                if (s > 0) {
                    return (int)s;
                }
                return "NA";
            }
        }
        return string;
    }

    public void refreshFromModel() throws ProvisionError {
        int n;
        int n2;
        this.cppAttributesLen = this.moduleModel.getCPPPortAttributesList();
        this.cppGrpAttrs = this.moduleModel.getCPPGrpAttributesList();
        try {
            n2 = 0;
            this.cppAttributesLen = this.moduleModel.getCPPPortAttributesList();
            for (n = 0; n < this.cppAttributesLen.length; ++n) {
                if (this.cppAttributesLen[n].isCPPValid) {
                    // empty if block
                }
                this.numLines = ++n2;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.grpMatchForPort = new boolean[this.numLines];
        this.cppAttributes = new sCppPortAttributes[this.numLines];
        try {
            n2 = 0;
            for (n = 0; n < this.cppAttributesLen.length; ++n) {
                if (!this.cppAttributesLen[n].isCPPValid) continue;
                this.cppAttributes[n2] = this.cppAttributesLen[n];
                if (n > 9 && n < 20) {
                    int n3;
                    this.cppAttributes[n2].portIndex = n3 = n - 9;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        for (int i = 0; i < this.cppAttributes.length; ++i) {
            for (n = 0; n < this.cppGrpAttrs.length; ++n) {
                if (this.cppAttributes[i].groupNum != this.cppGrpAttrs[n].groupNum || this.cppGrpAttrs[n].failAction != eCppFailAction.GROUP_SWITCH) continue;
                this.grpMatchForPort[i] = true;
            }
        }
        this.fireTableDataChanged();
    }

    private IEntityModel getPort(int n) {
        try {
            IEntityModel iEntityModel = this.moduleModel.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
            return iEntityModel;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return null;
        }
    }

    public String getProtState(eCppProtState eCppProtState2) {
        return EtherEnumStrings.getString(eCppProtState.class, eCppProtState2.value());
    }
}

