/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.Circuits.eCircuitType;
import cerent.cms.idl.EtherMedia.sSonetPathsPosChipInfo;
import cerent.cms.model.ML2ModuleModel;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class ML2SonetPoolUsageTableModel
extends AbstractTableModel {
    public static final int POOL_INDEX = 0;
    public static final int TYPE_INDEX = 1;
    public static final int CIRCUIT_USAGE_INDEX = 2;
    public static final int POOL_USAGE_INDEX = 3;
    public static final int POOL_AVAILABLE_INDEX = 4;
    private String[] columnNames = new String[]{"Pool", "Type", "Circuit Usage", "Pool Usage", "Pool Available"};
    private ML2ModuleModel eqpmtModel = null;
    private sSonetPathsPosChipInfo[] infoList = null;
    private TDMTerminology terms;
    private static final SDebug db = new SDebug("ML2SonetPoolUsageTableModel");

    public ML2SonetPoolUsageTableModel(ML2ModuleModel mL2ModuleModel) {
        this.eqpmtModel = mL2ModuleModel;
        this.terms = mL2ModuleModel.getNodeModel().getTDMTerminology();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.infoList == null ? 0 : this.infoList.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block12: {
            try {
                switch (n2) {
                    case 0: {
                        return String.valueOf(this.infoList[n].sonetPool);
                    }
                    case 1: {
                        if (this.infoList[n].cirType == eCircuitType.ETHERNET) {
                            return "";
                        }
                        if (this.isHoCircuit(this.infoList[n].cirType)) {
                            return this.terms.getGeneralTerms(0);
                        }
                        return this.terms.getGeneralTerms(1);
                    }
                    case 2: {
                        return this.infoList[n].numOfChansInUse + " of " + this.infoList[n].maxChannels;
                    }
                    case 3: {
                        if (this.infoList[n].cirType == eCircuitType.ETHERNET) {
                            return "";
                        }
                        return String.valueOf(this.infoList[n].numOfPathsInUse) + " of " + String.valueOf(this.infoList[n].maxPaths);
                    }
                    case 4: {
                        return this.infoList[n].chipAvailable ? "Yes" : "No";
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block12;
                db.println("Error in getValueAt " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private boolean isHoCircuit(eCircuitType eCircuitType2) {
        return eCircuitType2 == eCircuitType.STS_CIRCUIT || eCircuitType2 == eCircuitType.STS_VCAT_CIRCUIT || eCircuitType2 == eCircuitType.VC_HO_PATH_CIRCUIT || eCircuitType2 == eCircuitType.VC_HO_PATH_VCAT_CIRCUIT;
    }

    public void refreshFromModel() throws Exception {
        this.infoList = this.eqpmtModel.getSonetPathsPosChipInfoList();
        this.fireTableDataChanged();
    }
}

