/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class AnpManager
extends WzTask
implements Observer {
    private final short shelfId;
    private final short rackNum;
    private final short rackPos;
    private final boolean isRelative;
    private final String shType;
    private int pos;
    private IChassisModel[] ent = null;
    private EntityModel entS = null;
    private List slots = null;
    private int cardCounter;
    private boolean searching = false;
    private Vector<EntityModel> modelHandles = new Vector();
    private static final SDebug db = new SDebug("AnpManager");
    private boolean chassisCheck = true;

    public boolean getChassisCheck() {
        return this.chassisCheck;
    }

    public AnpManager(NsdWizardInfo nsdWizardInfo, int n, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
        NsdWizardInfo.NodeStructure nodeStructure = nsdWizardInfo.getAnp().elementAt(n);
        this.shelfId = Short.parseShort(nodeStructure.shelf);
        this.rackNum = Short.parseShort(nodeStructure.rackNum);
        this.rackPos = nodeStructure.RUPos != null ? Short.parseShort(nodeStructure.RUPos) : Short.parseShort(nodeStructure.rackPos);
        this.isRelative = nodeStructure.RUPos == null;
        this.shType = nodeStructure.shType;
        this.pos = n;
        this.cardCounter = nodeStructure.slot.size();
    }

    @Override
    public synchronized void doTask() {
        this.setWorking();
        if (this.pos == 0) {
            this.wzInfo.logInfo(">> Starting Automatic Node Provisioning...\n");
            this.wzInfo.logInfo(">> Provisioning Shelf #" + this.shelfId + "..." + "\n");
        }
        if (this.prepare()) {
            if (this.pos != 0) {
                this.wzInfo.logInfo("\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
            }
            this.provisionShelf();
            this.wzInfo.logInfo("------------------------------------------------");
        }
    }

    private boolean prepare() {
        List list = null;
        EntityModel entityModel = null;
        this.ent = (IChassisModel[])this.node.getChassisModels();
        eEqType eEqType2 = EntityModel.name2EqType(this.node, this.shType);
        if (this.node.isMultishelf()) {
            boolean bl = false;
            for (int i = 0; i < this.ent.length && !bl; ++i) {
                if (this.ent[i].getShelfId() != this.shelfId) continue;
                if (((ChassisModel)this.ent[i]).getState() == eEqState.DELETED) {
                    this.wzInfo.logInfo("\n>> Shelf #" + this.shelfId + " was deleted. Need to restore" + "...");
                    break;
                }
                int n = this.ent[i].getEqType();
                if (eEqType2.value() != n) {
                    this.wzInfo.logError("\n>> Mismatch of shelf type (old=" + EntityModel.eqType2Name(this.node, n) + ",new=" + this.shType + ") for Shelf #" + this.shelfId + "..." + "\n");
                    this.setCompleted();
                    this.chassisCheck = false;
                    return false;
                }
                list = ((EntityModel)((Object)this.ent[i])).getChildrenOfType(eClass.BACKPLANE);
                bl = true;
            }
            if (!bl) {
                if (!this.searching) {
                    this.cms.addObserver(this);
                    try {
                        this.wzInfo.logInfo("\n>> Provisioning Shelf #" + this.shelfId + " of type " + this.shType + "...");
                        eEqType eEqType3 = EntityModel.name2EqType(this.node, this.shType);
                        this.cms.provisionShelf(this.shelfId, this.rackNum, this.rackPos, eEqType3, this.isRelative);
                        this.wzInfo.logSuccess(">> Done...\n");
                        this.searching = true;
                    }
                    catch (Exception exception) {
                        this.cms.deleteObserver(this);
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        String string = "";
                        if (exception instanceof InvalidData) {
                            string = "InvalidData Exception";
                        } else if (exception instanceof NotSupportedOnEquipment) {
                            string = "NotSupportedOnEquipment Exception";
                        } else if (exception instanceof ProvisionError) {
                            string = ((ProvisionError)((Object)exception)).getEIDMsg();
                        }
                        this.wzInfo.logError("\n>> Error Provisioning Shelf #" + this.shelfId + ": " + string + "..." + "\n");
                        this.setCompleted();
                    }
                    return false;
                }
                return false;
            }
        } else {
            int n = this.ent[0].getEqType();
            if (eEqType2.value() != n) {
                this.wzInfo.logError("\n>> Mismatch of shelf type (old=" + EntityModel.eqType2Name(this.node, n) + ",new=" + this.shType + ") for Shelf #" + this.shelfId + "..." + "\n");
                this.setCompleted();
                this.chassisCheck = false;
                return false;
            }
            this.entS = (EntityModel)((Object)this.node.getNcChassis());
            if (this.entS == null && db.on()) {
                db.println("no chassis found");
            }
            list = this.entS.getChildrenOfType(eClass.BACKPLANE);
        }
        if (list == null) {
            db.println("no backplanes found");
        }
        if (list != null && list.size() > 0) {
            entityModel = (EntityModel)list.get(0);
        }
        if (entityModel == null && db.on()) {
            db.println("no backplane found");
        }
        this.slots = null;
        if (entityModel != null) {
            this.slots = entityModel.getChildren();
        }
        if (this.slots == null && db.on()) {
            db.println("no slots found");
        }
        return true;
    }

    private void provisionShelf() {
        int n;
        NsdWizardInfo.NodeStructure nodeStructure = this.wzInfo.getAnp().elementAt(this.pos);
        int n2 = 0;
        String string = null;
        for (n = 0; n < nodeStructure.slot.size(); ++n) {
            n2 = Integer.parseInt(nodeStructure.slot.elementAt(n));
            string = nodeStructure.eqType.elementAt(n);
            this.provisionSlot(n2, string);
        }
        if (this.cardCounter == 0) {
            for (n = 0; n < this.modelHandles.size(); ++n) {
                EntityModel entityModel = this.modelHandles.elementAt(n);
                entityModel.deleteObserver(this);
            }
            this.setCompleted();
        }
    }

    private void provisionSlot(int n, String string) {
        this.wzInfo.logInfo(">> Provisioning Slot #" + n + " with " + string + " card" + "..." + "\n");
        EntityModel entityModel = (EntityModel)this.slots.get(n - 1);
        eEqType eEqType2 = eEqType.UNKNOWN;
        try {
            int n2 = entityModel.getEntityIndex();
            eEqType2 = EntityModel.name2EqType(this.node, string);
            entityModel.addObserver(this);
            this.modelHandles.add(entityModel);
            if (eEqType2 != null) {
                this.entm.provisionModule(n2, eEqType2);
                this.wzInfo.logSuccess(">> Done...\n");
            }
        }
        catch (ResourceInUse resourceInUse) {
            EntityModel entityModel2;
            boolean bl = false;
            List list = entityModel.getChildrenOfType(eClass.E_MODULE);
            if (list != null && list.size() > 0 && (entityModel2 = (EntityModel)list.get(0)).getEqTypeEnum().equals(eEqType2)) {
                this.wzInfo.logWarning(">> Slot already provisioned with same equipment...\n");
                bl = true;
            }
            if (!bl) {
                resourceInUse.printStackTrace();
                this.wzInfo.logError(">> Slot not empty...\n");
            }
            --this.cardCounter;
        }
        catch (EMCProvisionError eMCProvisionError) {
            eMCProvisionError.printStackTrace();
            this.wzInfo.logError(">> Setting refused...\n");
            --this.cardCounter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.wzInfo.logError(">> Generic error....\n");
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        block14: {
            int n;
            block13: {
                n = -1;
                if (!(observable instanceof ChassisModels)) break block13;
                n = object instanceof ChassisModelUpdate ? 2 : (Integer)object;
                switch (n) {
                    case 2: {
                        if (this.prepare()) {
                            if (this.pos != 0) {
                                this.wzInfo.logInfo("\n>> Provisioning Shelf #" + this.shelfId + "..." + "\n");
                            }
                            this.provisionShelf();
                            this.wzInfo.logInfo("------------------------------------------------");
                            this.cms.deleteObserver(this);
                        }
                        if (db.on()) {
                            db.println("updateObjectChanged(" + observable + ", " + object + ")");
                            break;
                        }
                        break block14;
                    }
                    default: {
                        if (db.on()) {
                            db.severe("Unknown update type " + n);
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            if (observable instanceof SlotModel) {
                n = (Integer)object;
                switch (n) {
                    case 2: {
                        --this.cardCounter;
                        if (this.cardCounter == 0) {
                            for (int i = 0; i < this.modelHandles.size(); ++i) {
                                EntityModel entityModel = this.modelHandles.elementAt(i);
                                entityModel.deleteObserver(this);
                            }
                            this.setCompleted();
                        }
                        if (!db.on()) break;
                        db.println("updateObjectChanged(" + observable + ", " + object + ")");
                        break;
                    }
                    default: {
                        if (!db.on()) break;
                        db.severe("Unknown update type " + n);
                    }
                }
            }
        }
    }
}

