/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ShelfInfo;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import java.util.Vector;

public class LayoutManager
extends WzTask {
    private static final String LM_START = ">> Position all the chassis in node...\n";
    private static final String LM_ERROR = ">> Error changing chassis positions: ";
    private static final SDebug db = new SDebug("LayoutManager");

    public LayoutManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    @Override
    public synchronized void doTask() {
        int n;
        this.setWorking();
        this.wzInfo.logInfo(LM_START);
        boolean bl = false;
        ShelfInfo[] shelfInfoArray = this.cms.getShelfInfos();
        Vector<NsdWizardInfo.NodeStructure> vector = this.wzInfo.getAnp();
        Vector<NsdWizardInfo.PUnitStructure> vector2 = this.wzInfo.getPassiveUnits();
        block2: for (NsdWizardInfo.NodeStructure object : vector) {
            n = Short.parseShort(object.shelf);
            for (ShelfInfo shelfInfo : shelfInfoArray) {
                if (n != shelfInfo.getShelfId()) continue;
                int n2 = Short.parseShort(object.rackNum);
                short s = Short.parseShort(object.RUPos != null ? object.RUPos : object.rackPos);
                if (shelfInfo.getRackNum() == n2 && shelfInfo.getRackPos() == s) continue block2;
                bl = true;
                shelfInfo.setRackNum((short)n2);
                shelfInfo.setRackPos(s);
                continue block2;
            }
        }
        block4: for (NsdWizardInfo.PUnitStructure pUnitStructure : vector2) {
            n = Integer.parseInt(pUnitStructure.unitNumber);
            PassiveModuleModel passiveModuleModel = PassiveModuleModel.getPassiveUnitById(this.node, n);
            if (passiveModuleModel == null) {
                this.wzInfo.logInfo(">> Passive unit <" + n + "> not found" + "..." + "\n");
                continue;
            }
            if (passiveModuleModel.getContainer() == null) continue;
            int n3 = (short)passiveModuleModel.getContainer().getShelfId();
            for (ShelfInfo shelfInfo : shelfInfoArray) {
                if (n3 != shelfInfo.getShelfId()) continue;
                short s = Short.parseShort(pUnitStructure.rackNum);
                short s2 = Short.parseShort(pUnitStructure.RUPos != null ? pUnitStructure.RUPos : pUnitStructure.rackPos);
                if (shelfInfo.getRackNum() == s && shelfInfo.getRackPos() == s2) continue block4;
                bl = true;
                shelfInfo.setRackNum(s);
                shelfInfo.setRackPos(s2);
                continue block4;
            }
        }
        if (bl) {
            try {
                this.cms.setShelfInfos(shelfInfoArray);
                this.wzInfo.logSuccess(">> Done...\n");
            }
            catch (Exception exception) {
                this.wzInfo.logError(LM_ERROR + exception.getMessage() + "..." + "\n");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        } else {
            this.wzInfo.logInfo(">> No changes...\n");
            this.wzInfo.logSuccess(">> Done...\n");
        }
        this.setCompleted();
    }
}

