/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NodeSetupFtpDialog;
import cerent.cms.ui.nodesetup.NodeSetupParser;
import cerent.cms.ui.nodesetup.NodeSetupSelection;
import cerent.cms.ui.nodesetup.NodeSetupWizard;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.FileUtils;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.version.EleInterfaceVersion;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.StringReader;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodeSetupController {
    private final AbstractPane pane;
    private final NodeModelDelegate nmd;
    private final SDebug dbg;
    private final File mpFile;
    private final String importXml;
    private NsdWizardInfo wizInfo = null;
    private NodeSetupParser nsp;

    public NodeSetupController(AbstractPane abstractPane, NodeModelDelegate nodeModelDelegate, String string, File file, SDebug sDebug) {
        this(abstractPane, nodeModelDelegate, string, null, file, sDebug, false);
    }

    public NodeSetupController(AbstractPane abstractPane, NodeModelDelegate nodeModelDelegate, File file, File file2, SDebug sDebug) {
        this(abstractPane, nodeModelDelegate, null, file, file2, sDebug, false);
    }

    public NodeSetupController(AbstractPane abstractPane, NodeModelDelegate nodeModelDelegate, File file, SDebug sDebug) {
        this(abstractPane, nodeModelDelegate, null, null, file, sDebug, false);
    }

    protected NodeSetupController(AbstractPane abstractPane, NodeModelDelegate nodeModelDelegate, String string, File file, File file2, SDebug sDebug, boolean bl) {
        this.pane = abstractPane;
        this.nmd = nodeModelDelegate;
        this.mpFile = file;
        this.importXml = string;
        this.dbg = sDebug;
        this.wizInfo = new NsdWizardInfo(file2);
        this.wizInfo.setNodeName(this.nmd.getName());
        this.wizInfo.setNmd(this.nmd);
        this.setup(bl);
        if (this.dbg.on()) {
            this.dbg.println("NodeSetupController: start");
        }
    }

    private void setup(boolean bl) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)this.pane));
        this.nsp = new NodeSetupParser(this.nmd, this.dbg);
        try {
            Document document;
            if (this.mpFile != null) {
                document = this.nsp.parse(this.mpFile);
            } else if (this.importXml != null) {
                document = this.nsp.parse(this.importXml);
            } else {
                NodeSetupFtpDialog nodeSetupFtpDialog = new NodeSetupFtpDialog(frame, this.wizInfo, this.dbg);
                nodeSetupFtpDialog.setVisible(true);
                if (nodeSetupFtpDialog.isCancelled()) {
                    this.dbg.info("Operation cancelled");
                    return;
                }
                String string = nodeSetupFtpDialog.getXmlContents();
                if (string != null && string.length() > 0) {
                    document = this.nsp.parse(string);
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, "Download failed.");
                    return;
                }
            }
            this.wizInfo = this.nsp.extractNodeDescriptions(document, this.wizInfo);
            if (this.wizInfo.getNodeCnt() == 1) {
                this.wizInfo.setDefaultNode();
            } else {
                this.dbg.info("Do node selection.");
                NodeSetupSelection nodeSetupSelection = new NodeSetupSelection(frame, true, this.wizInfo, this.wizInfo.getNodesArray(), this.dbg);
                nodeSetupSelection.setVisible(true);
                if (nodeSetupSelection.isCancelled()) {
                    this.dbg.info("Operation cancelled");
                    return;
                }
            }
            this.checkXmlFileVersion();
            if (this.wizInfo.getSelNode() != null) {
                this.dbg.info("Working on node " + this.wizInfo.getSelNode());
                this.wizInfo = this.nsp.extractNodeInfo(this.wizInfo.getSelNode(), document, this.wizInfo);
                this.wizInfo.setXmlContent(this.nsp.createDocOfSite(document, this.wizInfo.getSelNode()));
                if (bl) {
                    this.wizInfo.setAllSelected(true);
                    this.dbg.info("Show selected XML on node " + this.wizInfo.getSelNode());
                    NodeSetupDialog nodeSetupDialog = new NodeSetupDialog(this.wizInfo, frame);
                    nodeSetupDialog.showModal();
                } else {
                    this.dbg.info("Install selected XML on node " + this.wizInfo.getSelNode());
                    NodeSetupWizard nodeSetupWizard = new NodeSetupWizard(frame, this.wizInfo, true, true, this.dbg);
                    nodeSetupWizard.setVisible(true);
                }
            } else {
                this.dbg.info("Node not selected.");
            }
        }
        catch (SAXParseException sAXParseException) {
            String string = this.mpFile != null ? this.composeExceptionMsg(sAXParseException, new File(this.mpFile.getAbsolutePath()), this.mpFile.getAbsolutePath()) : this.composeExceptionMsg(sAXParseException, new StringReader(this.importXml), "<From Node>");
            ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, string);
        }
        catch (Exception exception) {
            this.dbg.println(exception.toString());
            if (this.dbg.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, exception);
        }
    }

    private String composeExceptionMsg(SAXException sAXException, Object object, String string) {
        int n;
        int n2 = ((SAXParseException)sAXException).getLineNumber();
        String string2 = sAXException.getMessage();
        String string3 = null;
        String string4 = FileUtils.getLineContentsAt((Object)object, (int)n2);
        if (string2.endsWith("for type 'null'.")) {
            n = string2.length();
            string2 = string2.substring(1, n - 16);
        }
        n = 0;
        n = string2.indexOf(":");
        if (n != -1) {
            string2 = string2.substring(n + 2, string2.length());
        }
        string4 = string4 != null ? string4.trim() : "<empty file>";
        string3 = "File: " + string + "\n" + "Line#: " + n2 + "\n" + "Line: " + string4 + "\n" + "Message: " + string2;
        return string3;
    }

    private void checkXmlFileVersion() {
        String string;
        this.dbg.info("Entered NodeSetupSelection.checkXmlFileVersion()");
        EleInterfaceVersion eleInterfaceVersion = new EleInterfaceVersion();
        String string2 = eleInterfaceVersion.getSwVersion().substring(0, 5);
        String string3 = string = this.wizInfo.getNodesVer()[this.wizInfo.getSelIndex() + 1] != null ? this.wizInfo.getNodesVer()[this.wizInfo.getSelIndex() + 1] : "07.XX";
        if (!string2.regionMatches(true, 0, string, 0, 4)) {
            CerentDialog.infoDialog((Component)((Object)this.pane), (String)("The NE (" + string + ") that you are trying to import does not match the CTC version (" + string2 + ").\n Some changes may not take effect."), (String)"Wizard Node Selection");
        }
    }
}

