/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.nodesetup.AbstractNodeSetupDialog;
import cerent.cms.ui.nodesetup.LayoutManager;
import cerent.cms.ui.nodesetup.NodeSetupShowLogDialog;
import cerent.cms.ui.nodesetup.NodeSetupWizard;
import cerent.cms.ui.nodesetup.NsdAnpPane;
import cerent.cms.ui.nodesetup.NsdAnsPane;
import cerent.cms.ui.nodesetup.NsdParamsPane;
import cerent.cms.ui.nodesetup.NsdPassiveUnitsPane;
import cerent.cms.ui.nodesetup.NsdPatchcordsPane;
import cerent.cms.ui.nodesetup.NsdPpmPane;
import cerent.cms.ui.nodesetup.NsdSidesPane;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzNsdPane;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NodeSetupDialog
extends AbstractNodeSetupDialog {
    private static final SDebug db = new SDebug("NodeSetupDialog");
    protected static String VIGNETTE = "/images/CTC_dialogVignette.gif";
    private NodeModelDelegate nmd;
    private String currentPane;
    private String firstPane;
    private String latestPane;
    private JButton saveAs;
    private StatusCounters cntrs;
    private boolean showOnly = false;

    public NodeSetupDialog(NsdWizardInfo nsdWizardInfo, Frame frame) {
        super(frame, "Node Setup for " + nsdWizardInfo.getNodeName(), new WzDiagDebug("NodeSetupDialog"), true, true);
        this.showOnly = true;
        this.init(null, nsdWizardInfo, frame);
        this.finishButton.setVisible(false);
        this.saveAs.setVisible(true);
    }

    public NodeSetupDialog(NodeSetupWizard nodeSetupWizard, NsdWizardInfo nsdWizardInfo, Frame frame, boolean bl) {
        super(frame, "Node Setup for " + nsdWizardInfo.getNodeName(), new WzDiagDebug("NodeSetupDialog"), bl, true);
        this.init(nodeSetupWizard, nsdWizardInfo, frame);
        this.applyButton.setVisible(true);
        this.saveAs.setVisible(false);
        this.statusPanel.setEntireBackground(null);
        this.cntrs = new StatusCounters();
        this.statusPanel.push(this.cntrs, "Status");
        this.statusPanel.push(new JLabel(new ImageIcon(this.getClass().getResource(VIGNETTE))));
    }

    private void init(NodeSetupWizard nodeSetupWizard, NsdWizardInfo nsdWizardInfo, Frame frame) {
        this.wizard = nodeSetupWizard;
        this.wizardInfo = nsdWizardInfo;
        this.nmd = nsdWizardInfo.getNmd();
        int n = 950;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.statusPanel.removeMouseListener(this.statusPanel);
        this.splitter.setDividerLocation(160);
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
    }

    private void addPane(String string, WzNsdPane wzNsdPane) {
        this.addPane(string, string, wzNsdPane);
    }

    private void addPane(String string, String string2, WzNsdPane wzNsdPane) {
        this.wzPaneMap.put(string, wzNsdPane);
        wzNsdPane.setShowOnly(this.showOnly);
        if (this.currentPane == null) {
            this.currentPane = string;
        }
        if (this.firstPane == null) {
            this.firstPane = string2;
        }
        this.latestPane = string2;
    }

    @Override
    protected void createPanesAndSetCurrent() {
        String string = null;
        String string2 = "";
        WzNsdPane wzNsdPane = null;
        if (this.wizardInfo.isAnpSelected()) {
            for (int i = 0; i < this.wizardInfo.getAnp().size(); ++i) {
                string = "Shelf" + i;
                NsdWizardInfo.NodeStructure nodeStructure = this.wizardInfo.getAnp().elementAt(i);
                if (this.nmd.isMultishelf()) {
                    string2 = "Shelf # " + nodeStructure.shelf;
                    if (nodeStructure.shType != null) {
                        string2 = string2 + ", " + nodeStructure.shType;
                    }
                    if (nodeStructure.RUPos != null) {
                        string2 = string2 + " [R" + nodeStructure.rackNum + ",U" + nodeStructure.RUPos + "]";
                    } else if (nodeStructure.rackPos != null) {
                        string2 = string2 + " [R" + nodeStructure.rackNum + ",P" + nodeStructure.rackPos + "]";
                    }
                } else {
                    string2 = "Node Layout";
                }
                wzNsdPane = new NsdAnpPane(this, this.makeChildDebug("Anp"), this.wizardInfo, i, string2);
                this.addPane(string, string2, wzNsdPane);
            }
        }
        if (this.wizardInfo.isPassiveUnitsSelected()) {
            wzNsdPane = new NsdPassiveUnitsPane(this, this.makeChildDebug("PassiveUnits"), this.wizardInfo, "Passive Units");
            this.addPane("Passive Units", wzNsdPane);
        }
        if (wzNsdPane != null) {
            wzNsdPane.setPostCompleteTask(new LayoutManager(this.wizardInfo, this.wizardInfo.getNmd()));
        }
        if (this.wizardInfo.isParamSelected()) {
            wzNsdPane = new NsdParamsPane(this, this.makeChildDebug("Params"), this.wizardInfo, "Card Parameters");
            this.addPane("Card Parameters", wzNsdPane);
        }
        if (this.wizardInfo.isPpmSelected()) {
            wzNsdPane = new NsdPpmPane(this, this.makeChildDebug("Ppm"), this.wizardInfo, "Pluggable Port Modules");
            this.addPane("Pluggable Port Modules", wzNsdPane);
        }
        if (this.wizardInfo.isPatchcordsSelected()) {
            wzNsdPane = new NsdPatchcordsPane(this, this.makeChildDebug("Patchcords"), this.wizardInfo, "Internal Patchcords");
            this.addPane("Internal Patchcords", wzNsdPane);
        }
        if (this.wizardInfo.isSidesSelected()) {
            wzNsdPane = new NsdSidesPane(this, this.makeChildDebug("Sides"), this.wizardInfo, "Optical Sides");
            this.addPane("Optical Sides", wzNsdPane);
        }
        if (this.wizardInfo.isAnsSelected()) {
            wzNsdPane = new NsdAnsPane(this, this.makeChildDebug("Ans"), this.wizardInfo, "ANS Parameters");
            this.addPane("ANS Parameters", wzNsdPane);
        }
        this.wizardInfo.setFirstPane(this.firstPane);
        this.wizardInfo.setLastPane(this.latestPane);
        this.setCurrentPane(this.currentPane);
    }

    @Override
    protected AbstractButton[] getExtraButtons() {
        this.saveAs = new JButton("Save As...");
        this.saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeSetupDialog.this.saveXml();
            }
        });
        return new JButton[]{this.saveAs};
    }

    @Override
    protected void backFromEmptyStack() throws Exception {
        if (this.wizard != null) {
            this.close();
            this.dispose();
            this.wizard.setVisible(true);
        } else {
            super.backFromEmptyStack();
        }
    }

    protected void localValidation() {
    }

    @Override
    protected void handleCancel() {
        if (NodeSetupDialog.db.on) {
            db.println("handleCancel: cleaning up");
        }
        this.close();
    }

    @Override
    protected String getCancelMessage() {
        if (this.showOnly) {
            return null;
        }
        return "Canceling will not undo any provisioning already done.\nIs it OK to cancel " + this.getTitle() + "?";
    }

    private void close() {
    }

    private void terminate() {
        this.cancel(false);
        this.wizardInfo.terminate(this);
    }

    @Override
    public void finish() {
        this.terminate();
    }

    @Override
    public void apply() {
    }

    @Override
    protected void handleFinish() {
        super.handleFinish();
    }

    public void updateStatus() {
        this.cntrs.update(this.wizardInfo.getSuccessCnt(), this.wizardInfo.getWrnCnt(), this.wizardInfo.getErrCnt());
    }

    private void saveXml() {
        NodeSetupShowLogDialog.save(JOptionPane.getFrameForComponent(this), this.wizardInfo.getXmlContent());
    }

    private class StatusCounters
    extends JPanel {
        private JLabel success;
        private JLabel warning;
        private JLabel failure;

        StatusCounters() {
            super(new GridLayout(1, 3, 2, 2));
            this.success = this.createCounter("Success", Color.GREEN, Color.BLACK);
            this.warning = this.createCounter("Warning", Color.ORANGE, Color.BLACK);
            this.failure = this.createCounter("Failure", Color.RED, Color.BLACK);
            this.add(this.success);
            this.add(this.warning);
            this.add(this.failure);
            this.success.setText("0");
            this.warning.setText("0");
            this.failure.setText("0");
        }

        private JLabel createCounter(String string, Color color, Color color2) {
            JLabel jLabel = new JLabel();
            jLabel.setToolTipText(string);
            jLabel.setBackground(color);
            jLabel.setForeground(color2);
            jLabel.setOpaque(true);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            return jLabel;
        }

        void update(int n, int n2, int n3) {
            this.success.setText(Integer.toString(n));
            this.warning.setText(Integer.toString(n2));
            this.failure.setText(Integer.toString(n3));
        }
    }
}

