/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.ANS.NodeSetupModel;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeSetupError;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.nodesetup.AbstractNodeSetupPreDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.NumberTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.net.UnknownHostException;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NodeSetupFtpDialog
extends AbstractNodeSetupPreDialog
implements IObserver {
    private static final String DIALOG_TITLE = "Ftp Remote Installation File ";
    private JTextField hostnameTF;
    private NumberTextField portnumTF;
    private GNESelector gneSel;
    private JTextField usernameTF;
    private JPasswordField passwordTF;
    private JTextField dirnameTF;
    private JTextField filenameTF;
    private JProgressBar progressBar;
    private String hoststr;
    private static final int IDLE = 0;
    private static final int DOWNLOADING = 1;
    private static final int COMPLETED = 2;
    private static final String S_IDLE = "Idle";
    private static final String S_DOWNLOADING = "Downloading";
    private static final String S_UPLOADING = "Uploading";
    private static final String S_INTERRUPTED = "Interrupted";
    private static final String S_COMPLETED = "Completed";
    private static final String S_FAILED = "Failed - Unknown";
    private int status = 0;
    private String xmlstr = null;
    private static final Color failcol = Color.pink;
    private final Color okcol;
    private final NodeSetupModel nsm;

    public NodeSetupFtpDialog(Frame frame, NsdWizardInfo nsdWizardInfo, SDebug sDebug) {
        super(frame, true, DIALOG_TITLE, nsdWizardInfo, sDebug);
        this.nsm = nsdWizardInfo.getNmd().getNodeSetupModel();
        this.nsm.addObserver(this);
        this.portnumTF.setText("21");
        this.progressBar.setString(S_IDLE);
        this.okcol = this.progressBar.getBackground();
        INodeModel iNodeModel = this.nsm.getNodeModel();
        boolean bl = iNodeModel.getProxyConfiguration() == 3;
        boolean bl2 = iNodeModel.isSecureMode();
        if (bl) {
            INodeHelper iNodeHelper = iNodeModel.getUiToolkit().getNodeHelper();
            Collection collection = iNodeHelper.getAllGNENodesInNetwork();
            this.gneSel.init(collection);
        } else {
            this.gneSel.setVisible(false);
        }
        this.dbg.info("NodeSetupFtpDialog() initialized isENE=" + bl + ", secure=" + bl2);
    }

    @Override
    protected JPanel getRightPane() {
        this.dbg.info("Entered NodeSetupFtpDialog.getRightPane()");
        JPanel jPanel = AbstractPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        this.hostnameTF = this.addField(jPanel2, "Hostame:", new JTextField(20), 85, 20);
        this.portnumTF = (NumberTextField)this.addField(jPanel2, "Port:", new NumberTextField(5), 40, 20);
        jPanel.add(jPanel2);
        this.gneSel = new GNESelector(85, 160, 20);
        jPanel.add(this.gneSel);
        jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        this.usernameTF = this.addField(jPanel2, "Username:", new LetterOrDigitTextField(10), 85, 20);
        this.passwordTF = (JPasswordField)this.addField(jPanel2, "Password:", new JPasswordField(), 80, 20);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        this.dirnameTF = this.addField(jPanel2, "Directory:", new JTextField(30), 85, 20);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        this.filenameTF = this.addField(jPanel2, "Filename:", new JTextField(15), 85, 20);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        this.progressBar.setStringPainted(true);
        jPanel2.add(this.progressBar);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JTextField addField(JPanel jPanel, String string, JTextField jTextField, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        jPanel.add(jLabel);
        jTextField.setPreferredSize(new Dimension(n, n2));
        jPanel.add(jTextField);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                NodeSetupFtpDialog.this.checkNextButton();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                NodeSetupFtpDialog.this.checkNextButton();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                NodeSetupFtpDialog.this.checkNextButton();
            }
        });
        return jTextField;
    }

    @Override
    protected void handleNext() {
        this.dbg.info("NodeSetupFtpDialog.handleNext() status is " + this.status + ", " + this.progressBar.getString());
        if (this.status == 2) {
            this.dispose();
            return;
        }
        if (!this.validatePage()) {
            return;
        }
        this.startFtp();
    }

    @Override
    protected boolean handleCancel() {
        this.dbg.info("NodeSetupFtpDialog.handleCancel() status is " + this.status + ", " + this.progressBar.getString());
        if (this.status == 1) {
            this.cancelFtp();
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.dbg.info("NodeSetupFtpDialog.dispose() status is " + this.status + ", " + this.progressBar.getString());
        this.nsm.deleteObserver(this);
        if (this.status == 1) {
            this.cancelFtp();
        }
        super.dispose();
    }

    private void checkNextButton() {
        boolean bl = this.allFieldsFilledIn();
        this.setNextEnabled(bl);
        this.dbg.info("next button set to " + bl);
    }

    private boolean allFieldsFilledIn() {
        boolean bl = this.hostnameTF != null && !this.hostnameTF.getText().equals("");
        bl &= this.portnumTF != null && !this.portnumTF.getText().equals("");
        bl &= this.usernameTF != null && !this.usernameTF.getText().equals("");
        bl &= this.passwordTF != null && this.passwordTF.getPassword().length > 0;
        bl &= this.dirnameTF != null && !this.dirnameTF.getText().equals("");
        return bl &= this.filenameTF != null && !this.filenameTF.getText().equals("");
    }

    private boolean validatePage() {
        if (!this.allFieldsFilledIn()) {
            return false;
        }
        try {
            this.hoststr = InetUtil.makeDottedString(this.hostnameTF.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)"The value specified for the FTP Host Address is not a valid IP address.");
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)"Unknown FTP Host Address.");
            return false;
        }
        this.dbg.info("NodeSetupFtpDialog.validatePage() completed: hoststr=" + this.hoststr);
        return true;
    }

    private void startFtp() {
        this.dbg.info("NodeSetupFtpDialog.startFtp()");
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.gneSel.getSelectedGNE();
            stringBuilder.append(this.usernameTF.getText());
            if (string != null && string.length() > 0) {
                stringBuilder.append("@");
                stringBuilder.append(this.hoststr);
                this.hoststr = string;
            }
            if (this.dbg.on()) {
                this.dbg.println("Start FTP: server:" + this.hoststr + ", username:" + stringBuilder.toString());
            }
            this.nsm.ftpRemoteFile(this.hoststr, stringBuilder.toString(), String.valueOf(this.passwordTF.getPassword()), this.dirnameTF.getText(), this.filenameTF.getText(), Short.parseShort(this.portnumTF.getText()));
            this.setStatusSuccess(1, S_DOWNLOADING);
            this.progressBar.setIndeterminate(true);
            this.setNextEnabled(false);
        }
        catch (NodeSetupError nodeSetupError) {
            this.setStatusFailed(nodeSetupError.getErrorMsg());
        }
        this.dbg.info("new status is " + this.status + ", " + this.progressBar.getString());
    }

    private void cancelFtp() {
        this.dbg.info("NodeSetupFtpDialog.cancelFtp()");
        try {
            this.nsm.cancelFtp();
            this.setStatusFailed(S_INTERRUPTED);
            this.setNextEnabled(true);
        }
        catch (NodeSetupError nodeSetupError) {
            this.setStatusFailed(nodeSetupError.getErrorMsg());
        }
        this.dbg.info("new status is " + this.status + ", " + this.progressBar.getString());
    }

    private void ftpCompleted() {
        this.dbg.info("NodeSetupFtpDialog.ftpCompleted()");
        this.progressBar.setString(S_UPLOADING);
        try {
            this.xmlstr = this.nsm.readRemoteXMLFile();
            if (this.xmlstr != null && this.xmlstr.length() > 0) {
                this.setStatusSuccess(2, S_COMPLETED);
            } else {
                this.setStatusFailed(S_FAILED);
            }
        }
        catch (NodeSetupError nodeSetupError) {
            this.setStatusFailed(nodeSetupError.getErrorMsg());
        }
        this.progressBar.setIndeterminate(false);
        this.setNextEnabled(true);
        this.dbg.info("new status is " + this.status + ", " + this.progressBar.getString());
    }

    private void setAllEditable(boolean bl) {
        this.hostnameTF.setEditable(bl);
        this.portnumTF.setEditable(bl);
        this.usernameTF.setEditable(bl);
        this.passwordTF.setEditable(bl);
        this.dirnameTF.setEditable(bl);
        this.filenameTF.setEditable(bl);
    }

    private void setStatusSuccess(int n, String string) {
        this.status = n;
        this.progressBar.setString(string);
        this.progressBar.setBackground(this.okcol);
        this.setAllEditable(false);
    }

    private void setStatusFailed(String string) {
        this.status = 0;
        this.progressBar.setString(string);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBackground(failcol);
        this.setAllEditable(true);
    }

    public String getXmlContents() {
        return this.xmlstr;
    }

    public void update(IObservable iObservable, Object object) {
        this.dbg.info("NodeSetupFtpDialog.update() Obs=" + iObservable + ", o=" + object);
        this.ftpCompleted();
    }

    private static String getHostName(INodeModel iNodeModel) {
        IIpConfig iIpConfig = iNodeModel.getIpConfig();
        String string = iIpConfig.getNodeMode() ? InetUtil.makeDottedString(iIpConfig.getIpv6Address(), true) : InetUtil.makeDottedString(iIpConfig.getIpAddress(), false);
        return string;
    }

    private class GNECellRenderer
    extends DefaultListCellRenderer {
        private GNECellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            if (object instanceof INodeModel) {
                string = ((INodeModel)object).getName();
            } else if (object != null) {
                string = object.toString();
            }
            this.setText(string);
            return this;
        }
    }

    private class GNESelector
    extends JPanel {
        private final DefaultComboBoxModel model;
        private final JComboBox cb;
        private final JLabel lbl;

        GNESelector(int n, int n2, int n3) {
            super(new FlowLayout(0, 5, 5));
            this.lbl = new JLabel("GNE Selector:");
            this.lbl.setPreferredSize(new Dimension(n, n3));
            this.add(this.lbl);
            this.model = new DefaultComboBoxModel();
            this.cb = new JComboBox(this.model);
            this.cb.setPreferredSize(new Dimension(n2, n3));
            this.cb.setRenderer(new GNECellRenderer());
            this.add(this.cb);
            NodeSetupFtpDialog.this.dbg.info("GNESelector initialized");
        }

        void init(Collection<INodeModel> collection) {
            Object object = this.cb.getSelectedItem();
            this.model.removeAllElements();
            for (INodeModel iNodeModel : collection) {
                this.model.addElement(iNodeModel);
            }
            this.cb.setEnabled(collection.size() > 1);
            if (object != null) {
                this.cb.setSelectedItem(object);
            }
            this.setVisible(true);
            if (NodeSetupFtpDialog.this.dbg.on()) {
                NodeSetupFtpDialog.this.dbg.fine("Need GNE. Available GNEs are: " + collection);
            }
        }

        String getSelectedGNE() {
            if (this.isVisible() && this.cb.getSelectedItem() != null) {
                INodeModel iNodeModel = (INodeModel)this.cb.getSelectedItem();
                return NodeSetupFtpDialog.getHostName(iNodeModel);
            }
            return null;
        }
    }
}

