/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Dwdm.sDwdmLineConfig;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Optics.eBand;
import cerent.cms.idl.Optics.eCtdcu_comp;
import cerent.cms.idl.Optics.eFtdcu_comp;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.TdcuModuleModel;
import cerent.cms.model.UnsupportedCardOperMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.OpticalThresholdTableModel;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class ParamsManager
extends WzTask {
    private static final String CPP_START = ">> Starting Card Parameters Provisioning...";
    private static final String CPP_PROB = " could not be provisioned: ";
    private static final String CPP_NO_CARD = " could not be provisioned: no card found";
    private static final String CPP_OTN = ">> Provisioning OTN ";
    private static final String CPP_FEC = ">> Provisioning FEC ";
    private static final String CPP_MLSE = ">> Provisioning MLSE ";
    private static final String CPP_OVRCLK = ">> Provisioning OVERCLOCK ";
    private static final String CPP_EXC = ">> Exception in provisioning parameter ";
    private static final String CPP_OPT = ">> Provisioning OPT_AMP ";
    private static final String CPP_WL = ">> Provisioning WL ";
    private static final String CPP_CHWL = ">> Provisioning CH_WL ";
    private static final String CPP_BANDWL = ">> Provisioning BAND_WL ";
    private static final String CPP_OPERMODE = ">> Provisioning OPERMODE ";
    private static final String CPP_PSM_FAIL_TH = ">> Provisioning PSM LOS threshold ";
    private static final String CPP_REACH = ">> Provisioning REACH ";
    private static final String CPP_CONFIG_1_3 = ">> Configuring Ports 1-3 ";
    private static final String CPP_CONFIG_2_4 = ">> Configuring Ports 2-4 ";
    private static final String CPP_CONFIG_3_4 = ">> Configuring Ports 3-4 ";
    private static final String CPP_CONFIG_SPLITTER = ">> Configuring Splitter on Ports 1-3-4 ";
    private static final String CPP_CONFIG_YCABLE = ">> Configuring YCABLE ";
    private static final String CPP_CONFIG_REGEN_PEER = ">> Configuring Regen Peer ";
    private static final String CPP_CONFIG_DCU_COMP = ">> Provisioning TDCU/DCU Compensation ";
    private static final String CPP_ERR_NO_DCU_COMP = ">> Card does not support TDCU/DCU Compensation";
    private static final String CPP_CONFIG_WXC_MODE = ">> Provisioning WXC Oper Mode ";
    private static final String CPP_VAL = " with value ";
    private static final SDebug db = new SDebug("ParamsManager");

    public ParamsManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void doTask() {
        NsdWizardInfo.ParamStructure paramStructure = null;
        ModuleModel moduleModel = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        String string2 = null;
        this.setWorking();
        this.wzInfo.logInfo(">> Starting Card Parameters Provisioning...\n");
        int n3 = 0;
        while (true) {
            block145: {
                IOpticsProvExtModel iOpticsProvExtModel;
                boolean bl;
                Object object;
                String string3;
                String string4;
                block162: {
                    OpticsLineModel opticsLineModel;
                    block160: {
                        block170: {
                            block169: {
                                block168: {
                                    block167: {
                                        block166: {
                                            block165: {
                                                block164: {
                                                    block163: {
                                                        block161: {
                                                            block159: {
                                                                block158: {
                                                                    block157: {
                                                                        block156: {
                                                                            block155: {
                                                                                block154: {
                                                                                    block153: {
                                                                                        block152: {
                                                                                            block151: {
                                                                                                block147: {
                                                                                                    block146: {
                                                                                                        if (n3 >= this.wzInfo.getParams().size()) {
                                                                                                            this.setCompleted();
                                                                                                            return;
                                                                                                        }
                                                                                                        paramStructure = this.wzInfo.getParams().elementAt(n3);
                                                                                                        string4 = paramStructure.paramValue;
                                                                                                        string3 = paramStructure.paramName;
                                                                                                        if (paramStructure.unitid != null) {
                                                                                                            moduleModel = PassiveModuleModel.getPassiveUnitById(this.node, Integer.parseInt(paramStructure.unitid));
                                                                                                        } else {
                                                                                                            n = this.isMs ? Integer.parseInt(paramStructure.shelf) : 1;
                                                                                                            n2 = Integer.parseInt(paramStructure.slot);
                                                                                                            string = paramStructure.port;
                                                                                                            string2 = paramStructure.ppm;
                                                                                                            moduleModel = this.getCardModel(n, n2);
                                                                                                        }
                                                                                                        if (moduleModel != null) break block146;
                                                                                                        if (ParamsManager.db.on) {
                                                                                                            db.println("No slot found");
                                                                                                        }
                                                                                                        this.wzInfo.logError(">> " + string3 + CPP_NO_CARD + "\n");
                                                                                                        break block145;
                                                                                                    }
                                                                                                    if (!string3.equalsIgnoreCase("OPT_AMP")) break block147;
                                                                                                    this.printStartSentence(CPP_OPT, n, n2, null, string4, null);
                                                                                                    object = ((OpticsModuleModel)moduleModel).getOpticsAmplifiedLineModels();
                                                                                                    try {
                                                                                                        block150: {
                                                                                                            block148: {
                                                                                                                block149: {
                                                                                                                    if (((OpticsAmplifiedLineModel[])object).length <= 0) break block148;
                                                                                                                    if (!string4.equalsIgnoreCase("PRE_AMPLI")) break block149;
                                                                                                                    ((OpticsModuleModel)moduleModel).setAmpliRole(eOpticalAmplifierRole.PRE_AMPLI);
                                                                                                                    break block150;
                                                                                                                }
                                                                                                                if (string4.equalsIgnoreCase("BST_AMPLI")) {
                                                                                                                    ((OpticsModuleModel)moduleModel).setAmpliRole(eOpticalAmplifierRole.BST_AMPLI);
                                                                                                                    break block150;
                                                                                                                } else {
                                                                                                                    this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong parameter value\n");
                                                                                                                    break block145;
                                                                                                                }
                                                                                                            }
                                                                                                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong card found\n");
                                                                                                            break block145;
                                                                                                        }
                                                                                                        this.wzInfo.logSuccess(">> Done...\n");
                                                                                                    }
                                                                                                    catch (Exception exception) {
                                                                                                        if (ParamsManager.db.on) {
                                                                                                            db.println("Exception in provisioning parameter OPT_AMP");
                                                                                                            KDebug.printStackTrace((Throwable)exception);
                                                                                                        }
                                                                                                        this.wzInfo.logError(">> Exception in provisioning parameter OPT_AMP\n");
                                                                                                    }
                                                                                                    break block145;
                                                                                                }
                                                                                                if (!string3.equalsIgnoreCase("WL")) break block151;
                                                                                                this.printStartSentence(CPP_WL, n, n2, string, string4, " nm");
                                                                                                object = this.getTrunkPort(string3, moduleModel, string);
                                                                                                if (object == null) {
                                                                                                    this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port or card found" + "\n");
                                                                                                    break block145;
                                                                                                } else {
                                                                                                    String string5 = string4;
                                                                                                    eWavelength eWavelength2 = null;
                                                                                                    try {
                                                                                                        eWavelength2 = this.convertWl(string5);
                                                                                                    }
                                                                                                    catch (Exception exception) {
                                                                                                        if (db.on()) {
                                                                                                            db.println("Cannot translate WL found in mfg data: " + string5 + ": " + exception.getMessage());
                                                                                                            KDebug.printStackTrace((Throwable)exception);
                                                                                                        }
                                                                                                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong wavelength data" + "\n");
                                                                                                        break block145;
                                                                                                    }
                                                                                                    try {
                                                                                                        ((DwdmTrkLineModel)object).setWavelengthEnum(eWavelength2);
                                                                                                    }
                                                                                                    catch (Exception exception) {
                                                                                                        boolean bl2 = false;
                                                                                                        try {
                                                                                                            eWavelength eWavelength3 = ((DwdmTrkLineModel)object).getWavelengthEnum();
                                                                                                            bl2 = eWavelength3.equals(eWavelength2);
                                                                                                        }
                                                                                                        catch (Exception exception2) {
                                                                                                            // empty catch block
                                                                                                        }
                                                                                                        if (!bl2) {
                                                                                                            if (ParamsManager.db.on) {
                                                                                                                KDebug.printStackTrace((Throwable)exception);
                                                                                                                db.println("Setting WL failed");
                                                                                                            }
                                                                                                            this.wzInfo.logError(">> Exception in provisioning parameter WL\n");
                                                                                                            break block145;
                                                                                                        } else {
                                                                                                            this.wzInfo.logWarning(">> Same WL already configured on port\n");
                                                                                                        }
                                                                                                        break block145;
                                                                                                    }
                                                                                                    this.wzInfo.logSuccess(">> Done...\n");
                                                                                                }
                                                                                                break block145;
                                                                                            }
                                                                                            if (!string3.equalsIgnoreCase("OTN")) break block152;
                                                                                            this.printStartSentence(CPP_OTN, n, n2, null, string4, null);
                                                                                            object = this.getTrunkPort(string3, moduleModel, string);
                                                                                            if (object == null) {
                                                                                                this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port or card found" + "\n");
                                                                                                break block145;
                                                                                            } else {
                                                                                                try {
                                                                                                    ((DwdmTrkLineModel)object).setOTNStatus(string4.equalsIgnoreCase("enable"));
                                                                                                }
                                                                                                catch (Exception exception) {
                                                                                                    if (ParamsManager.db.on) {
                                                                                                        SDebug.printStackTrace((Throwable)exception);
                                                                                                        db.println("Setting OTN failed");
                                                                                                    }
                                                                                                    this.wzInfo.logError(">> Exception in provisioning parameter OTN\n");
                                                                                                    break block145;
                                                                                                }
                                                                                                this.wzInfo.logSuccess(">> Done...\n");
                                                                                            }
                                                                                            break block145;
                                                                                        }
                                                                                        if (!string3.equalsIgnoreCase("FEC")) break block153;
                                                                                        this.printStartSentence(CPP_FEC, n, n2, null, string4, null);
                                                                                        object = this.getTrunkPort(string3, moduleModel, string);
                                                                                        if (object == null) {
                                                                                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port or card found" + "\n");
                                                                                            break block145;
                                                                                        } else {
                                                                                            try {
                                                                                                int n4 = 0;
                                                                                                if (string4.equalsIgnoreCase("disable")) {
                                                                                                    n4 = 0;
                                                                                                } else if (string4.equalsIgnoreCase("enable") || string4.equalsIgnoreCase("standard")) {
                                                                                                    n4 = 1;
                                                                                                } else if (string4.equalsIgnoreCase("enhanced")) {
                                                                                                    n4 = 2;
                                                                                                }
                                                                                                ((DwdmTrkLineModel)object).setFECModeValue(n4);
                                                                                            }
                                                                                            catch (Exception exception) {
                                                                                                if (ParamsManager.db.on) {
                                                                                                    SDebug.printStackTrace((Throwable)exception);
                                                                                                    db.println("Setting FEC failed");
                                                                                                }
                                                                                                this.wzInfo.logError(">> Exception in provisioning parameter FEC\n");
                                                                                                break block145;
                                                                                            }
                                                                                            this.wzInfo.logSuccess(">> Done...\n");
                                                                                        }
                                                                                        break block145;
                                                                                    }
                                                                                    if (!string3.equalsIgnoreCase("MLSE")) break block154;
                                                                                    this.printStartSentence(CPP_MLSE, n, n2, null, string4, null);
                                                                                    object = this.getTrunkPort(string3, moduleModel, string);
                                                                                    if (object == null) {
                                                                                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port or card found" + "\n");
                                                                                        break block145;
                                                                                    } else {
                                                                                        try {
                                                                                            ((DwdmTrkLineModel)object).enableMlse(string4.equalsIgnoreCase("enable"));
                                                                                        }
                                                                                        catch (Exception exception) {
                                                                                            if (ParamsManager.db.on) {
                                                                                                SDebug.printStackTrace((Throwable)exception);
                                                                                                db.println("Setting MLSE failed");
                                                                                            }
                                                                                            this.wzInfo.logError(">> Exception in provisioning parameter MLSE\n");
                                                                                            break block145;
                                                                                        }
                                                                                        this.wzInfo.logSuccess(">> Done...\n");
                                                                                    }
                                                                                    break block145;
                                                                                }
                                                                                if (!string3.equalsIgnoreCase("OVERCLOCK")) break block155;
                                                                                this.printStartSentence(CPP_OVRCLK, n, n2, null, string4, null);
                                                                                object = this.getTrunkPort(string3, moduleModel, string);
                                                                                if (object == null) {
                                                                                    this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port or card found" + "\n");
                                                                                    break block145;
                                                                                } else {
                                                                                    try {
                                                                                        ((AbstractDwdmLineModel)object).setOverclock(string4.equalsIgnoreCase("enable") ? 1 : 0);
                                                                                    }
                                                                                    catch (Exception exception) {
                                                                                        if (ParamsManager.db.on) {
                                                                                            SDebug.printStackTrace((Throwable)exception);
                                                                                            db.println("Setting OVERCLOCK failed");
                                                                                        }
                                                                                        this.wzInfo.logError(">> Exception in provisioning parameter OVERCLOCK\n");
                                                                                        break block145;
                                                                                    }
                                                                                    this.wzInfo.logSuccess(">> Done...\n");
                                                                                }
                                                                                break block145;
                                                                            }
                                                                            if (!string3.equalsIgnoreCase("OPERMODE")) break block156;
                                                                            this.printStartSentence(CPP_OPERMODE, n, n2, null, string4, null);
                                                                            string4 = "OPER_MODE_" + string4;
                                                                            try {
                                                                                object = (eCardOperMode)eCardOperMode.class.getDeclaredField(string4).get(new Object());
                                                                                moduleModel.setCardOperMode((eCardOperMode)object);
                                                                                this.wzInfo.logSuccess(">> Done...\n");
                                                                            }
                                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)illegalArgumentException);
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            catch (SecurityException securityException) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)securityException);
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            catch (IllegalAccessException illegalAccessException) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)illegalAccessException);
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            catch (NoSuchFieldException noSuchFieldException) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)noSuchFieldException);
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            catch (EMCProvisionError eMCProvisionError) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)((Object)eMCProvisionError));
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            catch (UnsupportedCardOperMode unsupportedCardOperMode) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)unsupportedCardOperMode);
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            catch (ResourceInUse resourceInUse) {
                                                                                if (ParamsManager.db.on) {
                                                                                    KDebug.printStackTrace((Throwable)resourceInUse);
                                                                                    db.println("OPERMODE setting failed");
                                                                                }
                                                                                this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                                                                            }
                                                                            break block145;
                                                                        }
                                                                        if (!string3.equalsIgnoreCase("CH_WL")) break block157;
                                                                        this.printStartSentence(CPP_CHWL, n, n2, null, string4, " nm");
                                                                        object = null;
                                                                        String string6 = string4;
                                                                        eWavelength eWavelength4 = null;
                                                                        try {
                                                                            eWavelength4 = this.convertWl(string6);
                                                                        }
                                                                        catch (Exception exception) {
                                                                            if (db.on()) {
                                                                                db.println("Cannot translate WL found in mfg data: " + string6 + ": " + exception.getMessage());
                                                                                KDebug.printStackTrace((Throwable)exception);
                                                                            }
                                                                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong wavelength data\n");
                                                                            break block145;
                                                                        }
                                                                        try {
                                                                            object = ((OpticsModuleModel)moduleModel).getOpticsChannelModels();
                                                                            ((OpticsChannelModel)object[0]).setExpectedWaveLength(eWavelength4);
                                                                        }
                                                                        catch (NoSuchInterface noSuchInterface) {
                                                                            if (ParamsManager.db.on) {
                                                                                KDebug.printStackTrace((Throwable)noSuchInterface);
                                                                                db.println("CH_WL setting failed");
                                                                            }
                                                                            this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                                                                            break block145;
                                                                        }
                                                                        catch (WrongInterfaceType wrongInterfaceType) {
                                                                            if (ParamsManager.db.on) {
                                                                                KDebug.printStackTrace((Throwable)wrongInterfaceType);
                                                                                db.println("CH_WL setting failed");
                                                                            }
                                                                            this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                                                                            break block145;
                                                                        }
                                                                        catch (ConfigError configError) {
                                                                            if (ParamsManager.db.on) {
                                                                                KDebug.printStackTrace((Throwable)configError);
                                                                                db.println("CH_WL setting failed");
                                                                            }
                                                                            this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                                                                            break block145;
                                                                        }
                                                                        catch (InternalCommError internalCommError) {
                                                                            if (ParamsManager.db.on) {
                                                                                KDebug.printStackTrace((Throwable)internalCommError);
                                                                                db.println("CH_WL setting failed");
                                                                            }
                                                                            this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                                                                            break block145;
                                                                        }
                                                                        catch (Exception exception) {
                                                                            if (ParamsManager.db.on) {
                                                                                KDebug.printStackTrace((Throwable)exception);
                                                                                db.println("CH_WL setting failed");
                                                                            }
                                                                            this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                                                                            break block145;
                                                                        }
                                                                        this.wzInfo.logSuccess(">> Done...\n");
                                                                        break block145;
                                                                    }
                                                                    if (!string3.equalsIgnoreCase("BAND_WL")) break block158;
                                                                    this.printStartSentence(CPP_BANDWL, n, n2, null, string4, " nm");
                                                                    object = null;
                                                                    String string7 = string4;
                                                                    eBand eBand2 = null;
                                                                    try {
                                                                        eBand2 = this.convertBand(string7);
                                                                    }
                                                                    catch (Exception exception) {
                                                                        if (db.on()) {
                                                                            db.println("Cannot translate WL found in mfg data: " + string7 + ": " + exception.getMessage());
                                                                            KDebug.printStackTrace((Throwable)exception);
                                                                        }
                                                                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong wavelength data\n");
                                                                        break block145;
                                                                    }
                                                                    try {
                                                                        object = ((OpticsModuleModel)moduleModel).getOpticsOMSModels();
                                                                        ((OpticsMultiplexSectionModel)object[0]).setExpectedBand(eBand2);
                                                                    }
                                                                    catch (NoSuchInterface noSuchInterface) {
                                                                        if (ParamsManager.db.on) {
                                                                            KDebug.printStackTrace((Throwable)noSuchInterface);
                                                                            db.println("BAND_WL setting failed");
                                                                        }
                                                                        this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                                                                        break block145;
                                                                    }
                                                                    catch (WrongInterfaceType wrongInterfaceType) {
                                                                        if (ParamsManager.db.on) {
                                                                            KDebug.printStackTrace((Throwable)wrongInterfaceType);
                                                                            db.println("BAND_WL setting failed");
                                                                        }
                                                                        this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                                                                        break block145;
                                                                    }
                                                                    catch (ConfigError configError) {
                                                                        if (ParamsManager.db.on) {
                                                                            KDebug.printStackTrace((Throwable)configError);
                                                                            db.println("BAND_WL setting failed");
                                                                        }
                                                                        this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                                                                        break block145;
                                                                    }
                                                                    catch (InternalCommError internalCommError) {
                                                                        if (ParamsManager.db.on) {
                                                                            KDebug.printStackTrace((Throwable)internalCommError);
                                                                            db.println("BAND_WL setting failed");
                                                                        }
                                                                        this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                                                                        break block145;
                                                                    }
                                                                    catch (Exception exception) {
                                                                        if (ParamsManager.db.on) {
                                                                            KDebug.printStackTrace((Throwable)exception);
                                                                            db.println("BAND_WL setting failed");
                                                                        }
                                                                        this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                                                                        break block145;
                                                                    }
                                                                    this.wzInfo.logSuccess(">> Done...\n");
                                                                    break block145;
                                                                }
                                                                if (!string3.equalsIgnoreCase("LOS")) break block159;
                                                                this.printStartSentence(CPP_PSM_FAIL_TH, n, n2, null, string4, " nm");
                                                                object = ((OpticsModuleModel)moduleModel).getAllInterfaceModels();
                                                                opticsLineModel = null;
                                                                break block160;
                                                            }
                                                            if (!string3.equalsIgnoreCase("REACH")) break block161;
                                                            this.printStartSentence(CPP_REACH, n, n2, null, string4, null);
                                                            object = moduleModel.getLineModels();
                                                            bl = false;
                                                            iOpticsProvExtModel = null;
                                                            break block162;
                                                        }
                                                        if (!string3.equalsIgnoreCase("Cfg1-3")) break block163;
                                                        this.printStartSentence(CPP_CONFIG_1_3, n, n2, null, string4, null);
                                                        if (moduleModel.getEqType() == 293) {
                                                            try {
                                                                object = (OTU2XpModuleModel)moduleModel;
                                                                sDwdmLineConfig sDwdmLineConfig2 = null;
                                                                sDwdmLineConfig2 = ((OTU2XpModuleModel)object).getLineModel(1).getDwdmLineConfig();
                                                                if (string4.equalsIgnoreCase("Standard Regen")) {
                                                                    sDwdmLineConfig2.regenPeerLineIndex = ((OTU2XpModuleModel)object).getLineModel(3).getIndex();
                                                                } else if (string4.equalsIgnoreCase("LAN-WAN")) {
                                                                    sDwdmLineConfig2.regenPeerLineIndex = 0;
                                                                    sDwdmLineConfig2.isLanWanMode = true;
                                                                } else {
                                                                    sDwdmLineConfig2.regenPeerLineIndex = 0;
                                                                }
                                                                ((OTU2XpModuleModel)object).getLineModel(1).setDwdmLineConfig(sDwdmLineConfig2);
                                                                this.wzInfo.logSuccess(">> Done...\n");
                                                            }
                                                            catch (Exception exception) {
                                                                if (ParamsManager.db.on) {
                                                                    db.println("Wrong Configuration");
                                                                    KDebug.printStackTrace((Throwable)exception);
                                                                }
                                                                this.wzInfo.logError(">> " + string3 + CPP_PROB + "Wrong Configuration" + "\n");
                                                            }
                                                            break block145;
                                                        } else {
                                                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "Invalid Card" + "\n");
                                                        }
                                                        break block145;
                                                    }
                                                    if (!string3.equalsIgnoreCase("Cfg2-4")) break block164;
                                                    this.printStartSentence(CPP_CONFIG_2_4, n, n2, null, string4, null);
                                                    if (moduleModel.getEqType() == 293) {
                                                        object = (OTU2XpModuleModel)moduleModel;
                                                        sDwdmLineConfig sDwdmLineConfig3 = null;
                                                        try {
                                                            sDwdmLineConfig3 = ((OTU2XpModuleModel)object).getLineModel(2).getDwdmLineConfig();
                                                            sDwdmLineConfig3.regenPeerLineIndex = string4.equalsIgnoreCase("Standard Regen") ? ((OTU2XpModuleModel)object).getLineModel(4).getIndex() : 0;
                                                            ((OTU2XpModuleModel)object).getLineModel(2).setDwdmLineConfig(sDwdmLineConfig3);
                                                            this.wzInfo.logSuccess(">> Done...\n");
                                                        }
                                                        catch (Exception exception) {
                                                            if (ParamsManager.db.on) {
                                                                db.println("Wrong Configuration");
                                                                KDebug.printStackTrace((Throwable)exception);
                                                            }
                                                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "Wrong Configuration\n");
                                                        }
                                                        break block145;
                                                    } else {
                                                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "Invalid Card" + "\n");
                                                    }
                                                    break block145;
                                                }
                                                if (!string3.equalsIgnoreCase("Cfg3-4")) break block165;
                                                this.printStartSentence(CPP_CONFIG_3_4, n, n2, null, string4, null);
                                                if (moduleModel.getEqType() == 293) {
                                                    try {
                                                        object = (OTU2XpModuleModel)moduleModel;
                                                        sDwdmLineConfig sDwdmLineConfig4 = null;
                                                        sDwdmLineConfig4 = ((OTU2XpModuleModel)object).getLineModel(3).getDwdmLineConfig();
                                                        sDwdmLineConfig4.regenPeerLineIndex = string4.equalsIgnoreCase("Enhanced FEC") ? ((OTU2XpModuleModel)object).getLineModel(4).getIndex() : 0;
                                                        ((OTU2XpModuleModel)object).getLineModel(3).setDwdmLineConfig(sDwdmLineConfig4);
                                                        this.wzInfo.logSuccess(">> Done...\n");
                                                    }
                                                    catch (Exception exception) {
                                                        if (ParamsManager.db.on) {
                                                            db.println("Wrong Configuration");
                                                            KDebug.printStackTrace((Throwable)exception);
                                                        }
                                                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "Wrong Configuration\n");
                                                    }
                                                    break block145;
                                                } else {
                                                    this.wzInfo.logError(">> " + string3 + CPP_PROB + "Invalid Card" + "\n");
                                                }
                                                break block145;
                                            }
                                            if (!string3.equalsIgnoreCase("Cfg1-3-4")) break block166;
                                            this.printStartSentence(CPP_CONFIG_SPLITTER, n, n2, null, string4, null);
                                            if (moduleModel.getEqType() == 293) {
                                                try {
                                                    object = moduleModel.getChassis().getElementModels();
                                                    IPortModel iPortModel = ((OTU2XpModuleModel)moduleModel).getLineModel(3).getPortModel();
                                                    IPortModel iPortModel2 = ((OTU2XpModuleModel)moduleModel).getLineModel(4).getPortModel();
                                                    RevertiveBehavior revertiveBehavior = new RevertiveBehavior(1, 300);
                                                    sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(revertiveBehavior);
                                                    if (string4.equalsIgnoreCase("Splitter")) {
                                                        ((ElementModelsDelegate)object).createSplitter(new sYCableProvision(iPortModel.getEntityIndex(), iPortModel2.getEntityIndex(), sRevertiveBehavior2, false), "Splitter_Shelf" + n + "_Slot" + n2);
                                                    }
                                                    this.wzInfo.logSuccess(">> Done...\n");
                                                }
                                                catch (Exception exception) {
                                                    if (ParamsManager.db.on) {
                                                        db.println("Wrong Configuration");
                                                        KDebug.printStackTrace((Throwable)exception);
                                                    }
                                                    this.wzInfo.logError(">> " + string3 + CPP_PROB + "Wrong Configuration\n");
                                                }
                                                break block145;
                                            } else {
                                                this.wzInfo.logError(">> " + string3 + CPP_PROB + "Invalid Card" + "\n");
                                            }
                                            break block145;
                                        }
                                        if (!string3.equalsIgnoreCase("YcablePeerSlot")) break block167;
                                        this.printStartSentence(CPP_CONFIG_YCABLE, n, n2, string, string4, null);
                                        try {
                                            object = moduleModel.getChassis().getElementModels();
                                            int n5 = Integer.parseInt(string);
                                            int n6 = ((DwdmModuleModel)moduleModel).getDwdmPorts()[n5 - 1].getIndex();
                                            int n7 = Integer.parseInt(string4);
                                            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getCardModel(n, n7);
                                            int n8 = dwdmModuleModel.getDwdmPorts()[n5 - 1].getIndex();
                                            RevertiveBehavior revertiveBehavior = new RevertiveBehavior(1, 300);
                                            sRevertiveBehavior sRevertiveBehavior3 = RevertiveBehaviorFactory.getRevertiveBehavior(revertiveBehavior);
                                            ((ElementModelsDelegate)object).createYCable(new sYCableProvision(n6, n8, sRevertiveBehavior3, false), "YCable_Sh" + n + "_S" + n2 + "_S" + string4 + "_P" + string);
                                            this.wzInfo.logSuccess(">> Done...\n");
                                        }
                                        catch (Exception exception) {
                                            if (ParamsManager.db.on) {
                                                db.println("Wrong Configuration");
                                                KDebug.printStackTrace((Throwable)exception);
                                            }
                                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "Wrong Configuration\n");
                                        }
                                        break block145;
                                    }
                                    if (!string3.equalsIgnoreCase("RegenPeerSlot")) break block168;
                                    this.printStartSentence(CPP_CONFIG_REGEN_PEER, n, n2, string, string4, null);
                                    try {
                                        object = ((DwdmModuleModel)moduleModel).getFirstTrunkLine();
                                        sDwdmCardConfig sDwdmCardConfig2 = ((AbstractDwdmLineModel)object).getDwdmCardConfig();
                                        int n9 = Integer.parseInt(string4);
                                        sDwdmCardConfig2.regenPeerCardIndex = ((DwdmModuleModel)this.getCardModel(n, n9)).getEntityIndex();
                                        ((AbstractDwdmLineModel)object).setDwdmCardConfig(sDwdmCardConfig2);
                                        this.wzInfo.logSuccess(">> Done...\n");
                                    }
                                    catch (Exception exception) {
                                        if (ParamsManager.db.on) {
                                            db.println("Wrong Configuration");
                                            KDebug.printStackTrace((Throwable)exception);
                                        }
                                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "Wrong Configuration\n");
                                    }
                                    break block145;
                                }
                                if (!string3.equalsIgnoreCase("TDCU_COMPENSATION")) break block169;
                                this.printStartSentence(CPP_CONFIG_DCU_COMP, n, n2, null, string4, null);
                                if (moduleModel instanceof TdcuModuleModel) {
                                    this.setTDCUCompensation((TdcuModuleModel)moduleModel, string4 + " ps/nm");
                                    break block145;
                                } else {
                                    this.wzInfo.logError(">> Card does not support TDCU/DCU Compensation\n");
                                }
                                break block145;
                            }
                            if (!string3.equalsIgnoreCase("DCU_COMPENSATION")) break block170;
                            this.printStartSentence(CPP_CONFIG_DCU_COMP, paramStructure.unitid, string4, null);
                            if (moduleModel instanceof PassiveModuleModel) {
                                this.setDCUCompensation((PassiveModuleModel)moduleModel, string4);
                                break block145;
                            } else {
                                this.wzInfo.logError(">> Card does not support TDCU/DCU Compensation\n");
                            }
                            break block145;
                        }
                        if (string3.equalsIgnoreCase("WXC_MODE")) {
                            this.printStartSentence(CPP_CONFIG_WXC_MODE, n, n2, null, string4, null);
                            object = this.getAttribute("Wxc80CardMode", string4, moduleModel);
                            if (object != null) {
                                this.setCardMode(moduleModel, ((Attribute)object).getIntValue());
                                break block145;
                            } else {
                                this.wzInfo.logError(">> Invalid WXC MODE " + string4 + "\n");
                            }
                            break block145;
                        } else {
                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong parameter name\n");
                        }
                        break block145;
                    }
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        try {
                            if (!(object[i] instanceof OpticsLineModel) || (opticsLineModel = (OpticsLineModel)object[i]).getPortNumber() != Integer.parseInt(string)) continue;
                            sOpticsAlmThresholds sOpticsAlmThresholds2 = opticsLineModel.getOpticsAlmThresholds();
                            sOpticsAlmThresholds2.opticalPowerAlmTh.fail.low = OpticalThresholdTableModel.ValPerTen(string4);
                            opticsLineModel.setOpticsAlmThresholds(sOpticsAlmThresholds2);
                            this.wzInfo.logSuccess(">> Done...\n");
                            break block145;
                        }
                        catch (Exception exception) {
                            if (ParamsManager.db.on) {
                                db.println("Exception in provisioning parameter LOS for PSM");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port\n");
                        }
                    }
                    break block145;
                }
                for (int i = 0; i < ((Object)object).length; ++i) {
                    try {
                        if (!(object[i] instanceof DwdmTrkLineModel)) continue;
                        IPortModel iPortModel = ((InterfaceModel)object[i]).getPortModel();
                        int[] nArray = iPortModel.getPortNum();
                        int n10 = nArray[1];
                        int n11 = nArray[0];
                        if (n10 != Integer.parseInt(string) || n11 != Integer.parseInt(string2)) continue;
                        if (object[i] instanceof XPL2LineModel) {
                            iOpticsProvExtModel = ((XPL2LineModel)object[i]).getOpticsProvExtModel();
                        } else if (object[i] instanceof DwdmTrkLineModel) {
                            iOpticsProvExtModel = ((DwdmTrkLineModel)object[i]).getOpticsProvExtModel();
                        }
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        if (ParamsManager.db.on) {
                            db.println("No port model found");
                            KDebug.printStackTrace((Throwable)exception);
                        }
                        this.wzInfo.logError(">> " + string3 + CPP_PROB + "no port model found\n");
                    }
                }
                if (!bl) {
                    this.wzInfo.logError(">> " + string3 + CPP_PROB + "wrong port or card found\n");
                } else {
                    try {
                        eReach eReach2 = eReach.from_int(this.string2Obj(iOpticsProvExtModel.getNodeModel(), string4).getIntValue());
                        iOpticsProvExtModel.setLineReach(eReach2);
                    }
                    catch (Exception exception) {
                        if (ParamsManager.db.on) {
                            KDebug.printStackTrace((Throwable)exception);
                            db.println("REACH setting failed");
                        }
                        this.wzInfo.logError(">> Provisioning REACH wrong parameter or port value\n");
                        break block145;
                    }
                    this.wzInfo.logSuccess(">> Done...\n");
                }
            }
            ++n3;
        }
    }

    private void printStartSentence(String string, int n, int n2, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " at ");
        if (this.isMs) {
            stringBuilder.append("shelf " + n + ", ");
        }
        stringBuilder.append("slot " + n2 + ", ");
        if (string2 != null) {
            stringBuilder.append("port " + string2);
        }
        if (string4 == null) {
            string4 = "";
        }
        stringBuilder.append(CPP_VAL + string3 + string4 + "\n");
        this.wzInfo.logInfo(stringBuilder.toString());
    }

    private void printStartSentence(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " at unit id " + string2);
        if (string4 == null) {
            string4 = "";
        }
        stringBuilder.append(CPP_VAL + string3 + string4 + "\n");
        this.wzInfo.logInfo(stringBuilder.toString());
    }

    private Attribute string2Obj(INodeModel iNodeModel, String string) {
        Attribute attribute = null;
        ElAttributeMaps elAttributeMaps = ElementDefaults.getAttributeMap((IModel)iNodeModel);
        Attribute[] attributeArray = elAttributeMaps.getAttributeArray("declDwdmReach");
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getKey().compareTo(string) != 0) continue;
            attribute = attributeArray[i];
            break;
        }
        return attribute;
    }

    private Attribute getAttribute(String string, String string2, ModuleModel moduleModel) {
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = ElementDefaults.getAttributeMap(moduleModel).getAttributeArray(string)) {
            if (!attribute.getKey().equalsIgnoreCase(string2)) continue;
            return attribute;
        }
        return null;
    }

    private void setTDCUCompensation(TdcuModuleModel tdcuModuleModel, String string) {
        String string2 = tdcuModuleModel.getEqType() == 298 ? "fTdcuComp" : "cTdcuComp";
        Attribute attribute = this.getAttribute(string2, string, tdcuModuleModel);
        if (attribute != null) {
            try {
                if (tdcuModuleModel.getEqType() == 299) {
                    tdcuModuleModel.setCTdcuCompensationValue(eCtdcu_comp.from_int(attribute.getIntValue()));
                } else {
                    tdcuModuleModel.setFTdcuCompensationValue(eFtdcu_comp.from_int(attribute.getIntValue()));
                }
                this.wzInfo.logSuccess(">> Done...\n");
            }
            catch (Exception exception) {
                this.wzInfo.logError(">> Exception in provisioning parameter  TDCU COmpensation\n");
            }
            return;
        }
        this.wzInfo.logError(">> Invalid TDCU Compensation value " + string + "\n");
    }

    private void setDCUCompensation(PassiveModuleModel passiveModuleModel, String string) {
        try {
            if (passiveModuleModel.getEqType() == 312) {
                passiveModuleModel.setDCUCompensation(string);
                this.wzInfo.logSuccess(">> Done...\n");
            } else {
                this.wzInfo.logError(">> Card does not support TDCU/DCU Compensation\n");
            }
        }
        catch (Exception exception) {
            this.wzInfo.logError(">> Exception in provisioning parameter  TDCU COmpensation\n");
        }
    }

    private void setCardMode(ModuleModel moduleModel, int n) {
        try {
            moduleModel.setCardOperMode(eCardOperMode.from_int(n));
            this.wzInfo.logSuccess(">> Done...\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)illegalArgumentException);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (SecurityException securityException) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)securityException);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (EMCProvisionError eMCProvisionError) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)((Object)eMCProvisionError));
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (UnsupportedCardOperMode unsupportedCardOperMode) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)unsupportedCardOperMode);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (ResourceInUse resourceInUse) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)resourceInUse);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
    }

    private DwdmTrkLineModel getTrunkPort(String string, ModuleModel moduleModel, String string2) {
        InterfaceModel[] interfaceModelArray = null;
        IPortModel iPortModel = null;
        int n = 0;
        interfaceModelArray = moduleModel.getLineModels();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            try {
                int[] nArray;
                if (!(interfaceModelArray[i] instanceof DwdmTrkLineModel) || (n = (nArray = (iPortModel = ((DwdmTrkLineModel)interfaceModelArray[i]).getPortModel()).getPortNum())[0]) != Integer.parseInt(string2)) continue;
                return (DwdmTrkLineModel)interfaceModelArray[i];
            }
            catch (Exception exception) {
                if (ParamsManager.db.on) {
                    db.println("No port model found");
                    KDebug.printStackTrace((Throwable)exception);
                }
                this.wzInfo.logError(">> " + string + CPP_PROB + "no port model found\n");
            }
        }
        return null;
    }
}

