/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.nodesetup.AnpManager;
import cerent.cms.ui.nodesetup.IWzTaskListener;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public abstract class WzNsdPane
extends WzPane
implements IWzTaskListener {
    protected final NsdWizardInfo wizInfo;
    private final NodeSetupDialog nsd;
    private final WzTask task;
    private WzTask postCompleteTask;
    private boolean showOnly;
    protected JPanel rowTextArea;
    protected JPanel colTextArea;
    private UScrollPane colTextPane;
    protected String[] columnNames;
    protected String[][] dataValues;
    protected final boolean isMs;

    public WzNsdPane(NodeSetupDialog nodeSetupDialog, WzDiagDebug wzDiagDebug, String string, NsdWizardInfo nsdWizardInfo, WzTask wzTask) {
        super(nodeSetupDialog, wzDiagDebug, string);
        this.wizInfo = nsdWizardInfo;
        this.nsd = nodeSetupDialog;
        this.task = wzTask;
        this.task.addListener(this);
        this.isMs = nsdWizardInfo.getNmd().isMultishelf();
    }

    private void disableButtons() {
        this.nsd.setNextEnabled(this.getNextPaneName() != null);
        this.nsd.setApplyEnabled(false);
        if (this.getNextPaneName() == null) {
            this.nsd.setFinishEnabled(true);
        }
    }

    private JPanel createRightPanel() {
        this.rowTextArea = WzNsdPane.createHorizontalPanel(null);
        this.colTextArea = WzNsdPane.createVerticalPanel("Log");
        this.colTextPane = this.wizInfo.getLogAreaPane();
        this.colTextArea.add((Component)this.colTextPane);
        this.rowTextArea.add(this.colTextArea);
        return this.rowTextArea;
    }

    private JPanel createLeftPanel() {
        this.createColumns();
        this.createData();
        JTable jTable = new JTable(this.dataValues, this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setShowHorizontalLines(true);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        this.changeTableSetting(jTable);
        UScrollPane uScrollPane = new UScrollPane((Component)jTable);
        JPanel jPanel = WzNsdPane.createHorizontalPanel(null);
        JPanel jPanel2 = WzNsdPane.createVerticalPanel("");
        jPanel2.add((Component)uScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected abstract void createColumns();

    protected abstract void createData();

    protected void changeTableSetting(JTable jTable) {
    }

    public final void setShowOnly(boolean bl) {
        this.showOnly = bl;
    }

    public final void setPostCompleteTask(WzTask wzTask) {
        this.postCompleteTask = wzTask;
    }

    @Override
    public final void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        if (!this.showOnly) {
            JSplitPane jSplitPane = new JSplitPane();
            jSplitPane.setDividerLocation(375);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setContinuousLayout(true);
            jSplitPane.setLeftComponent(this.createLeftPanel());
            jSplitPane.setRightComponent(this.createRightPanel());
            this.add((Component)jSplitPane, "Center");
            this.nsd.setApplyEnabled(true);
            this.nsd.setButtonsEnabled(false, false);
        } else {
            this.add((Component)this.createLeftPanel(), "Center");
        }
    }

    @Override
    public final String handleNext() {
        try {
            this.resetOkToPostValidate();
            this.validatePage();
            if (!this.isOkToPostValidate()) {
                return null;
            }
            this.handlePostValidate();
        }
        catch (Exception exception) {
            this.handleNextException(exception);
            return null;
        }
        return this.getNextPaneName();
    }

    @Override
    public final void enteringPane() {
        this.initPane();
        if (this.db.on()) {
            this.db.println("enteringPage: start");
        }
        super.enteringPane();
        if (this.showOnly) {
            this.nsd.setNextEnabled(this.getNextPaneName() != null);
        }
    }

    @Override
    public final boolean handleBack() {
        if (this.db.on()) {
            this.db.println("handleBack: start");
        }
        if (this.rowTextArea != null) {
            this.rowTextArea.remove(this.colTextArea);
            this.colTextArea.remove((Component)this.colTextPane);
        }
        return super.handleBack();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    @Override
    public void validatePage() throws Exception {
        if (this.db.on()) {
            this.db.println("validatePage: start");
        }
        if (this.rowTextArea != null) {
            this.rowTextArea.remove(this.colTextArea);
            this.colTextArea.remove((Component)this.colTextPane);
        }
    }

    @Override
    public final void handleApply() {
        if (this.wizInfo.getFirstPane().equalsIgnoreCase(this.getName())) {
            this.task.begin();
            this.wizInfo.logInfo("------------------------------------------------");
        }
        this.task.doTask();
        if (this.task instanceof AnpManager && !((AnpManager)this.task).getChassisCheck()) {
            this.nsd.setNextEnabled(false);
            this.nsd.setFinishEnabled(true);
        }
    }

    private void taskReallyFinished() {
        this.wizInfo.logInfo(">> Applied...\n");
        this.nsd.updateStatus();
        if (this.wizInfo.getLastPane().equalsIgnoreCase(this.getName())) {
            this.wizInfo.logInfo("------------------------------------------------");
            this.task.end();
        }
        this.disableButtons();
    }

    @Override
    public final void taskFinished() {
        if (this.postCompleteTask != null) {
            this.postCompleteTask.addListener(new IWzTaskListener(){

                @Override
                public void taskFinished() {
                    WzNsdPane.this.taskReallyFinished();
                }

                @Override
                public void taskStatusChanged() {
                }
            });
            this.wizInfo.logInfo(">> Applied...\n");
            this.wizInfo.logInfo("------------------------------------------------");
            this.postCompleteTask.doTask();
            return;
        }
        this.taskReallyFinished();
    }

    @Override
    public final void taskStatusChanged() {
    }

    @Override
    public final CSHelpID getHelpID() {
        return CSHelpConst.NodeSetupWizard;
    }

    protected String getPortString(String string, String string2, String string3, String string4) {
        return this.task.getPortString(string, string2, string3, string4);
    }
}

