/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.ochterm.OchOpticalThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class OchOpticalThresholdProvPane
extends NodeProvPane
implements TableModelListener {
    protected InterfaceModel[] ochModels = null;
    protected AbstractOpticsLineModel[] lowerInterfaces;
    private Attribute[] supportedWavelenghts;
    private OpticsOchTermModel[] selectedOchModels;
    private OchOpticalThresholdTableModel dataModel;
    private ObservableManager _obsMgr = null;
    private DefaultComboBoxModel waveLModelCB;
    private DefaultComboBoxModel portModelCB;
    protected int thresholdLayer;
    private boolean notInited = true;
    private int wl = -1;
    private int port = -1;
    private JComboBox wlCB;
    private JComboBox portCB;
    protected static final SDebug db = new SDebug("OchOpticalThresholdProvPane");

    public OchOpticalThresholdProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n, JComboBox jComboBox, JComboBox jComboBox2) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
        this.supportedWavelenghts = opticsModuleModel.getSupportedWavelengths();
        this.wlCB = jComboBox;
        this.portCB = jComboBox2;
        this.thresholdLayer = n;
        this.init();
    }

    protected void init() {
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.waveLModelCB = new DefaultComboBoxModel();
        this.wlCB.setModel(this.waveLModelCB);
        this.getWavelength(this.waveLModelCB);
        this.wlCB.setSelectedIndex(-1);
        this.portModelCB = new DefaultComboBoxModel();
        this.portCB.setModel(this.portModelCB);
        this.getPortModels(this.portModelCB);
        this.portCB.setSelectedIndex(-1);
        this.ochModels = this.getAllOchModels();
        this.getObsMgr().addObservable((Observable[])this.lowerInterfaces);
        this.getObsMgr().addObservable((Observable[])this.ochModels);
        super.registerWithModel();
        this.notInited = false;
    }

    private OpticsOchTermModel[] getHO(InterfaceModel[] interfaceModelArray) {
        Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, 1, this.getUiModel());
        return collection.toArray(new OpticsOchTermModel[0]);
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        if (this.dataModel != null && this.selectedOchModels == null) {
            this.selectedOchModels = this.getOchByWl(this.wl, this.port);
            this.dataModel.setOchTermModel(this.selectedOchModels);
            this.dataModel.enteringPage();
            this.dataModel.refreshFromModel();
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        if (this.dataModel != null) {
            this.dataModel.refreshFromModel();
        }
        this.resetDirty();
    }

    @Override
    public void destroy() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lowerInterfaces);
            this._obsMgr.removeObservable((Observable[])this.selectedOchModels);
            this._obsMgr.removeObservable((Observable[])this.ochModels);
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    protected void removeColumn(int n) {
        String string = OchOpticalThresholdTableModel.columnNames[n];
        TableColumn tableColumn = this.table.getColumn(string);
        this.table.removeColumn(tableColumn);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = -1;
        if (this.selectedOchModels != null) {
            n = Arrays.asList(this.selectedOchModels).indexOf(observable);
        }
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (this.dataModel != null) {
                try {
                    this.dataModel.refreshLineFromModel(n);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
                }
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void applyChangesToModel() throws Exception, ConfigError {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this._obsMgr.setPassing(true);
        }
        return this._obsMgr;
    }

    @Override
    protected void structureChangeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got an added message from " + observable);
        }
        this.updateHO();
    }

    @Override
    protected void deleteMessage(Observable observable, Object object) {
        this.updateHO();
    }

    protected OchOpticalThresholdTableModel getDataModel(int n) {
        OchOpticalThresholdTableModel ochOpticalThresholdTableModel = null;
        try {
            ochOpticalThresholdTableModel = new OchOpticalThresholdTableModel(this.selectedOchModels, (OpticsModuleModel)this.lowerInterfaces[0].getModuleModel(), n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        return ochOpticalThresholdTableModel;
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: got CHANGED from " + observable.getClass());
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                OchOpticalThresholdProvPane.this.refreshLine(observable);
            }
        };
    }

    public void selectWlandPort() {
        if (this.wlCB.getSelectedIndex() != -1 && this.portCB.getSelectedIndex() != -1) {
            int n;
            if (this.wlCB.getSelectedObjects()[0] instanceof String) {
                int n2 = ((String)this.wlCB.getSelectedObjects()[0]).indexOf("**");
                String string = ((String)this.wlCB.getSelectedObjects()[0]).substring(0, n2);
                n = Wavelength.getLambdaFromLabel(string);
            } else {
                n = ((Attribute)this.wlCB.getSelectedObjects()[0]).getIntValue();
            }
            this.selectedOchModels = this.getOchByWl(n, ((PortModel)this.portCB.getSelectedObjects()[0]).getPort());
            this.dataModel.setOchTermModel(this.selectedOchModels);
        }
    }

    private OpticsOchTermModel[] getOchByWl(int n, int n2) {
        ArrayList<OpticsOchTermModel> arrayList = new ArrayList<OpticsOchTermModel>();
        OpticsOchTermModel[] opticsOchTermModelArray = this.getHO(((OpticsModuleModel)this.getUiModel()).getInterfaceSupportingOch());
        if (n != -1 && n2 != -1) {
            for (int i = 0; i < opticsOchTermModelArray.length; ++i) {
                try {
                    if (opticsOchTermModelArray[i].getExpectedWaveLength() != n || opticsOchTermModelArray[i].getPortNumber() != n2) continue;
                    arrayList.add(opticsOchTermModelArray[i]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            opticsOchTermModelArray = arrayList.toArray(new OpticsOchTermModel[0]);
        } else {
            opticsOchTermModelArray = null;
        }
        return opticsOchTermModelArray;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SMROpticalThresholdProvPane;
    }

    private synchronized void updateHO() {
        if (this.dataModel == null) {
            this.init();
        }
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.ochModels);
        }
        this.ochModels = this.getAllOchModels();
        this.getWavelength(this.waveLModelCB);
        this.getPortModels(this.portModelCB);
        this.portCB.setSelectedIndex(-1);
        this.wlCB.setSelectedIndex(-1);
        this.selectedOchModels = null;
        this.dataModel.setOchTermModel(this.selectedOchModels);
        if (this._obsMgr != null) {
            this._obsMgr.addObservable((Observable[])this.ochModels);
        }
    }

    private void getWavelength(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.removeAllElements();
        List<Integer> list = this.getAllOchWl();
        for (int i = 0; i < this.supportedWavelenghts.length; ++i) {
            if (list.contains(this.supportedWavelenghts[i].getValue())) {
                defaultComboBoxModel.addElement(this.supportedWavelenghts[i] + "**");
                continue;
            }
            defaultComboBoxModel.addElement(this.supportedWavelenghts[i]);
        }
    }

    private List<Integer> getAllOchWl() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[arrayList.size()]), 1, this.getUiModel());
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (InterfaceModel interfaceModel : collection) {
            try {
                arrayList2.add(new Integer(interfaceModel.getExpectedWaveLength()));
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList2;
    }

    private InterfaceModel[] getAllOchModels() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[arrayList.size()]), 1, this.getUiModel());
        return collection.toArray(new InterfaceModel[0]);
    }

    private void getPortModels(DefaultComboBoxModel defaultComboBoxModel) {
        int n;
        ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
        defaultComboBoxModel.removeAllElements();
        for (n = 0; n < this.lowerInterfaces.length; ++n) {
            try {
                if (!this.lowerInterfaces[n].isOCHTERMSupported()) continue;
                arrayList.add(this.lowerInterfaces[n].getPortModel());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("No such entity");
            }
        }
        Collections.sort(arrayList, new EntityModel.EntityModelComparator());
        for (n = 0; n < arrayList.size(); ++n) {
            defaultComboBoxModel.addElement(arrayList.toArray()[n]);
        }
    }
}

