/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.ochterm.OchParametersTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class OchParametersProvPane
extends NodeProvPane
implements TableModelListener,
ActionListener {
    private OpticsOchTermModel[] selectedochModels;
    private Attribute[] supportedWavelenghts;
    private InterfaceModel[] ochModels;
    private OchParametersTableModel dataModel = null;
    private OpticsModuleModel eqpmtModel;
    private ObservableManager _obsMgr = null;
    private UScrollPane scrollPane;
    private boolean notInited = true;
    private AbstractOpticsLineModel[] lowerInterfaces;
    private JComboBox wlCB;
    private DefaultComboBoxModel waveL;
    private JButton retrieveButton;
    private JLabel buttonLabel;
    protected static final SDebug db = new SDebug("OchParametersProvPane");

    public OchParametersProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        this.ochModels = null;
        this.selectedochModels = null;
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.supportedWavelenghts = this.eqpmtModel.getSupportedWavelengths();
    }

    protected void init() {
        this.dataModel = new OchParametersTableModel(this.selectedochModels, this.eqpmtModel);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.add((Component)this.scrollPane, "Center");
        this.waveL = new DefaultComboBoxModel();
        this.getWavelength(this.waveL);
        this.createButtonPanel();
        this.prepareColumns();
        this.addColumns();
        this.getObsMgr().addObservable((Observable[])this.lowerInterfaces);
        this.ochModels = this.getAllOchModels();
        this.getObsMgr().addObservable((Observable[])this.ochModels);
        super.registerWithModel();
        this.notInited = false;
    }

    private void getWavelength(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.removeAllElements();
        List<Integer> list = this.getAllOchWl();
        for (int i = 0; i < this.supportedWavelenghts.length; ++i) {
            if (list.contains(this.supportedWavelenghts[i].getValue())) {
                defaultComboBoxModel.addElement(this.supportedWavelenghts[i] + "**");
                continue;
            }
            defaultComboBoxModel.addElement(this.supportedWavelenghts[i]);
        }
    }

    protected void createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.bottom = 15;
        this.buttonLabel = new JLabel("Wavelength: ");
        jPanel.add((Component)this.buttonLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.wlCB = this.addCB(this.waveL, gridBagConstraints, jPanel);
        this.wlCB.setSelectedIndex(-1);
        cSHelpButtonPane.addLeft(jPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.retrieveButton = new JButton("Retrieve");
        this.retrieveButton.addActionListener(this);
        jPanel.add((Component)this.retrieveButton, gridBagConstraints);
        this.add(cSHelpButtonPane, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.retrieveButton) {
                this.uiToolkit.setCursor(3);
                if (this.wlCB.getSelectedIndex() != -1) {
                    int n;
                    if (this.wlCB.getSelectedObjects()[0] instanceof String) {
                        int n2 = ((String)this.wlCB.getSelectedObjects()[0]).indexOf("**");
                        String string = ((String)this.wlCB.getSelectedObjects()[0]).substring(0, n2);
                        n = Wavelength.getLambdaFromLabel(string);
                    } else {
                        n = ((Attribute)this.wlCB.getSelectedObjects()[0]).getIntValue();
                    }
                    this.selectedochModels = this.getOchbyWl(n);
                    this.dataModel.setOchTermModel(this.selectedochModels);
                    this._obsMgr.addObservable((Observable[])this.getOppositeOfSelectObjects());
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    private JComboBox addCB(DefaultComboBoxModel defaultComboBoxModel, GridBagConstraints gridBagConstraints, JPanel jPanel) {
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 160;
                return dimension;
            }
        };
        jComboBox.setRenderer(new CombosCellRenderer());
        jComboBox.addActionListener(this);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jComboBox;
    }

    protected void prepareColumns() {
        this.table.moveColumn(14, 2);
        this.table.moveColumn(15, 5);
        this.removeColumn(18);
        this.removeColumn(6);
        this.removeColumn(7);
        this.removeColumn(12);
        this.removeColumn(11);
        this.removeColumn(10);
        this.removeColumn(9);
        this.removeColumn(8);
        this.removeColumn(0);
        this.removeColumn(1);
        this.removeColumn(4);
        this.removeColumn(13);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(19));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForceVoaEnable()));
        tableColumn.setPreferredWidth(70);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(14));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(15));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(16));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        AdminState[] adminStateArray = AdminState.getAdminStatesNoIS_NoMT(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    private JComboBox getComboBoxForceVoaEnable() {
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"OFF", "ON"});
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private void addColumns() {
        this.addColumn(9);
        this.addColumn(10);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
        tableColumn.setPreferredWidth(170);
        if (this.eqpmtModel.getEqType() == 297) {
            this.addColumn(11);
            this.addColumn(12);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
            tableColumn.setPreferredWidth(170);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
            tableColumn.setPreferredWidth(170);
            this.addColumn(8);
        }
    }

    protected void addColumn(int n) {
        String string = this.dataModel.getColumnName(n);
        TableColumn tableColumn = new TableColumn(n);
        tableColumn.setHeaderValue(string);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        this.getTable().getColumnModel().addColumn(tableColumn);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (bl || bl2) {
            boolean bl3 = true;
            stringBuffer.append("\n");
            if (!bl3) {
                stringBuffer.append(this.getApplyString(bl3));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = -1;
        if (this.selectedochModels != null && (n = Arrays.asList(this.selectedochModels).indexOf(observable)) == -1) {
            n = Arrays.asList(this.getOppositeOfSelectObjects()).indexOf(observable);
        }
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (this.dataModel != null) {
                this.dataModel.refreshLineFromModel(n);
            }
        } else if (db.on()) {
            db.println("In OchParametersTableModel changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this._obsMgr.setPassing(true);
        }
        return this._obsMgr;
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: got CHANGED from " + observable.getClass());
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                OchParametersProvPane.this.refreshLine(observable);
            }
        };
    }

    @Override
    protected void structureChangeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got an added message from " + observable);
        }
        this.updateHO();
    }

    @Override
    protected void deleteMessage(Observable observable, Object object) {
        this.updateHO();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.getOppositeOfSelectObjects());
            this._obsMgr.removeObservable((Observable[])this.lowerInterfaces);
            this._obsMgr.removeObservable((Observable[])this.ochModels);
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        super.destroy();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SMROchParametersProvPane;
    }

    private OpticsOchTermModel[] getOchbyWl(int n) {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[arrayList.size()]), 1, this.getUiModel());
        ArrayList<OpticsOchTermModel> arrayList2 = new ArrayList<OpticsOchTermModel>();
        for (InterfaceModel interfaceModel : collection) {
            try {
                if (interfaceModel.getExpectedWaveLength() != n) continue;
                arrayList2.add((OpticsOchTermModel)interfaceModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList2.toArray(new OpticsOchTermModel[0]);
    }

    private List<Integer> getAllOchWl() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[arrayList.size()]), 1, this.getUiModel());
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (InterfaceModel interfaceModel : collection) {
            try {
                arrayList2.add(new Integer(interfaceModel.getExpectedWaveLength()));
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList2;
    }

    private InterfaceModel[] getAllOchModels() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[arrayList.size()]), 1, this.getUiModel());
        return collection.toArray(new InterfaceModel[0]);
    }

    private synchronized void updateHO() {
        if (this.dataModel == null) {
            this.init();
        }
        this.getWavelength(this.waveL);
        this.wlCB.setSelectedIndex(-1);
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.getOppositeOfSelectObjects());
            this._obsMgr.removeObservable((Observable[])this.ochModels);
        }
        this.selectedochModels = null;
        this.dataModel.setOchTermModel(this.selectedochModels);
        this.ochModels = this.getAllOchModels();
        if (this._obsMgr != null) {
            this._obsMgr.addObservable((Observable[])this.ochModels);
        }
    }

    protected void unregisterWithModel(InterfaceModel[] interfaceModelArray) {
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            if (interfaceModelArray[i] == null) continue;
            OpticsOchTermModel opticsOchTermModel = (OpticsOchTermModel)interfaceModelArray[i];
            opticsOchTermModel.deleteObserver((Observer)((Object)this));
            try {
                if ((opticsOchTermModel.getFeatures() & 1) == 1) continue;
                opticsOchTermModel.getFirstOppositeOchModel().deleteObserver((Observer)((Object)this));
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
                continue;
            }
            catch (FeatureUnsupported featureUnsupported) {
                featureUnsupported.printStackTrace();
            }
        }
    }

    private OpticsOchTermModel[] getOppositeOfSelectObjects() {
        ArrayList<OpticsOchTermModel> arrayList = new ArrayList<OpticsOchTermModel>();
        if (this.selectedochModels != null) {
            for (int i = 0; i < this.selectedochModels.length; ++i) {
                try {
                    arrayList.add(this.selectedochModels[i].getFirstOppositeOchModel());
                    continue;
                }
                catch (FeatureUnsupported featureUnsupported) {
                    SDebug.printStackTrace((Throwable)featureUnsupported);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    // empty catch block
                }
            }
        }
        return arrayList.toArray(new OpticsOchTermModel[0]);
    }
}

