/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerOptics;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Iterator;

public class OchPmTableModel
extends PmTableModel {
    private PmLayer ochCurrLayer;
    private static final SDebug db = new SDebug("OchPmTableModel");

    public OchPmTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, NodeModelDelegate nodeModelDelegate) {
        super(abstractOpticsLineModelArray, nodeModelDelegate);
        if (db.on()) {
            db.println("<init> ( " + abstractOpticsLineModelArray + " )");
        }
    }

    @Override
    protected Object getValueAtImpl(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        int n3 = n2 - 1;
        if (db.on()) {
            db.println("[OchPmTableModel] getValueAtImpl(" + n + "," + n2 + ")");
        }
        if (n2 == 0) {
            return this.currLayer.parmName(n);
        }
        if (db.on()) {
            db.println("Calling refreshPmStats for " + this.currLayer);
        }
        this.currLayer.refreshPmStats(n3);
        this.fromPeerCard = this.currLayer.isFromPeerCard();
        return this.currLayer.getPmValue(n, n3);
    }

    @Override
    public void setChoice(int n, int n2) {
        super.setChoice(n, n2);
        this.currLayer = null;
        Iterator iterator = this.layers.iterator();
        this.currRowMax = 3;
        this.currRowMin = 0;
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            this.currLayer = (PmLayer)iterator.next();
            if (((PmLayerOptics)this.currLayer).getInterfaceType() != 26) continue;
            bl = true;
        }
        if (!bl) {
            this.currLayer = null;
        }
    }

    @Override
    public int getRowCount() {
        if (this.currLayer != null) {
            return this.currLayer.parmCount();
        }
        return 0;
    }

    @Override
    public String getPortName(InterfaceModel interfaceModel) {
        int n = 0;
        String string = null;
        if (((AbstractOpticsLineModel)interfaceModel).isOCHTERMSupported()) {
            return super.getPortName(interfaceModel);
        }
        try {
            n = ((OpticsOchTermModel)interfaceModel).getActualWaveLength();
            string = Wavelength.getWavelengthStringFromWavelength(n);
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
            return Wavelength.getWavelengthStringFromWavelength(n);
        }
        return string;
    }
}

