/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.TdmLineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.CustomComboBoxModel;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractLoopBackPane
extends NodeProvPane
implements TableModelListener {
    protected INodeModel node;
    protected TdmLineMaintTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected OpticsModuleModel eqpmtModel = null;
    protected Runnable updateThread = null;
    protected int numLines = 0;
    protected LoopbackSelectionEditor myLoopbackEditor;
    private static final SDebug db = new SDebug("AbstractLoopBackPane");

    public AbstractLoopBackPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.lineModels = ((OpticsModuleModel)this.getUiModel()).getTdmLineModels();
        this.node = this.eqpmtModel.getNodeModel();
        this.dataModel = new TdmLineMaintTableModel(this.node, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.getAttributeArray(eAdminState.class))));
        tableColumn = this.table.getColumn(TdmLineMaintTableModel.columnNames[3]);
        CustomComboBoxModel customComboBoxModel = new CustomComboBoxModel();
        customComboBoxModel.setElements(this.pci.getLoopbackAttributeMap().values().toArray());
        this.myLoopbackEditor = new LoopbackSelectionEditor(customComboBoxModel);
        tableColumn.setCellEditor(this.myLoopbackEditor);
        tableColumn.sizeWidthToFit();
        this.registerWithLines();
        this.add((Component)uScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.dataModel.getAttributeMap().getAttributeArray("SONET." + clazz.getName());
    }

    protected String[] getLoopbackStrings() {
        return EnumStrings.getStrings(eLoopback.class);
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            if (!bl && AdminState.isTransitionToOOS(this.dataModel.getAdminStateFor(i), this.lineModels[i].getAdminStateEnum())) {
                bl = true;
                if (bl3 && bl2) break;
            }
            if (this.dataModel.getLoopbackValFor(i) == eLoopback.LINE_LOOPBACK) {
                if (this.lineModels[i].getLoopback() == eLoopback.LINE_LOOPBACK) continue;
                bl3 = true;
                if (!bl || !bl2) continue;
                break;
            }
            if (this.dataModel.getLoopbackValFor(i) == eLoopback.NO_LOOPBACK || !this.lineModels[i].getLoopback().equals(eLoopback.NO_LOOPBACK)) continue;
            bl2 = true;
            if (bl && bl3) break;
        }
        if (bl || bl3 || bl2) {
            String string = AdminState.getBaseOosWarning(this.terms) + "\n";
            String string2 = "Some lines are being placed in Facility (Line) loopback.\nChanging to Facility (Line) loopback may cause a timing loop\nif line is used as timing reference by far-end node\n";
            String string3 = "Some lines are being placed in Terminal (Inward) loopback.\n";
            bl4 = CerentDialog.yesNoDialog((Component)((Object)this), (String)((bl ? string : "") + (bl3 ? string2 : "") + (bl2 ? string3 : "") + "\n" + this.getApplyString()), (String)"Confirmation Dialog");
        }
        return bl4;
    }

    protected void applyInterdependentChangesToModel(int n) throws Exception {
        if (db.on()) {
            db.println("Setting Loopback for " + (n + 1) + " To " + this.dataModel.getLoopbackValFor(n).value());
        }
        if (AdminState.admitsLoopback(this.dataModel.getAdminStateFor(n))) {
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
            this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
        } else if (AdminState.admitsLoopback(this.lineModels[n].getAdminStateEnum())) {
            this.lineModels[n].setLoopback(this.dataModel.getLoopbackValFor(n));
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
        } else {
            this.lineModels[n].setAdminState(this.dataModel.getAdminStateFor(n));
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            for (n = 0; n < this.numLines; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyInterdependentChangesToModel(n);
            }
            this.dataModel.resetDirtyBits();
            this.setDirty(false);
        }
        catch (LoopbackActive loopbackActive) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".\nA cross-connect loopback already exists.", (Exception)((Object)loopbackActive));
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        int n = 0;
        int n2 = this.numLines - 1;
        if (n != -1) {
            n = tableModelEvent.getFirstRow() < 0 ? 0 : tableModelEvent.getFirstRow();
            n2 = tableModelEvent.getLastRow() > this.numLines ? this.numLines - 1 : tableModelEvent.getLastRow();
        }
        db.info("tableChanged: first/last row are " + n + "/" + n2);
        for (int i = n; i <= n2; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            db.info(" rows are dirty");
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    public void enteringPage() {
        try {
            this.refreshFromModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH);
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void registerWithLines() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].addObserver((Observer)((Object)this));
            }
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                AbstractLoopBackPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        if (this.lineModels != null) {
            this.dataModel.refreshFromModel();
            this.resetDirty();
        }
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected List filterLoopbackStates(TdmPortModel tdmPortModel, List list) {
        return list;
    }

    protected class LoopbackSelectionEditor
    extends DefaultCellEditor {
        private CustomComboBoxModel myComboModel;
        private List myInitialLoopbackStates;

        public LoopbackSelectionEditor(CustomComboBoxModel customComboBoxModel) {
            super(new JComboBox(customComboBoxModel));
            this.myComboModel = customComboBoxModel;
            this.myInitialLoopbackStates = customComboBoxModel.getElements();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            List list = AbstractLoopBackPane.this.filterLoopbackStates(AbstractLoopBackPane.this.eqpmtModel.getOC3Children()[n], this.myInitialLoopbackStates);
            this.myComboModel.setElements(list);
            this.delegate.setValue(object);
            return this.editorComponent;
        }
    }
}

