/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.oscm.OscmLinePmThresholdsTableModel;
import cerent.util.SDebug;

public class OscmSdhLinePmThresholdsTableModel
extends OscmLinePmThresholdsTableModel {
    private static final SDebug db = new SDebug("SdhLinePmThresholdsTableModel");
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int BBE_INDEX = 2;
    public static final int ES_INDEX = 3;
    public static final int SES_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int PSC_INDEX = 6;
    public static final int PSD_INDEX = 7;
    public static final int PSCW_INDEX = 8;
    public static final int PSDW_INDEX = 9;
    public static final int PSCS_INDEX = 10;
    public static final int PSDS_INDEX = 11;
    public static final int PSCR_INDEX = 12;
    public static final int PSDR_INDEX = 13;
    public static final int LAST_INDEX = 13;

    public OscmSdhLinePmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(iNodeModel, tdmLineModelArray, eIntervalType2, bl);
    }

    @Override
    protected void initColumnNames() {
        try {
            this.columnNames = ElementDefaults.getPmColumnNames(this.model[0].getModuleModel().getEqType(), this.getTerms());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.finer("Exception in initColumnNames() " + (Object)((Object)abstractCmsNoSuchEntityException));
        }
    }

    private int getBbe(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].bbe;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception();
            }
            switch (n2) {
                case 1: {
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 4: {
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 3: {
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 5: {
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 7: {
                    this.thresholdsVal[n].psd = n3;
                    break;
                }
                case 6: {
                    this.thresholdsVal[n].psc = n3;
                    break;
                }
                case 8: {
                    this.thresholdsVal[n].pscw = n3;
                    break;
                }
                case 9: {
                    this.thresholdsVal[n].psdw = n3;
                    break;
                }
                case 10: {
                    this.thresholdsVal[n].pscs = n3;
                    break;
                }
                case 11: {
                    this.thresholdsVal[n].psds = n3;
                    break;
                }
                case 12: {
                    this.thresholdsVal[n].pscr = n3;
                    break;
                }
                case 13: {
                    this.thresholdsVal[n].psdr = n3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column #" + n2);
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught in SdhLinePmThresholdsTableModel::setValueAt(): " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (Exception exception) {
            db.println("Error in setValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 4: {
                    return new Integer(this.getBbe(n));
                }
                case 2: {
                    return new Integer(this.getEs(n));
                }
                case 3: {
                    return new Integer(this.getSes(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
                case 7: {
                    return new Integer(this.getPsd(n));
                }
                case 6: {
                    return new Integer(this.getPsc(n));
                }
                case 8: {
                    return new Integer(this.getPscW(n));
                }
                case 9: {
                    return new Integer(this.getPsdW(n));
                }
                case 10: {
                    return new Integer(this.getPscS(n));
                }
                case 11: {
                    return new Integer(this.getPsdS(n));
                }
                case 12: {
                    return new Integer(this.getPscR(n));
                }
                case 13: {
                    return new Integer(this.getPsdR(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }
}

