/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.Ds123Media.eStatsType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayerDsnEn;
import cerent.util.SDebug;

public class PmLayerE3Path
extends PmLayerDsnEn {
    protected int numParms;
    public static String[] parmNames;
    public static final int ES_P_INDEX = 0;
    public static final int SES_P_INDEX = 1;
    public static final int UAS_P_INDEX = 2;
    public static final int ESR_P_INDEX = 3;
    public static final int SESR_P_INDEX = 4;
    public static final int NUM_OF_PARMS = 5;
    private static final SDebug db;

    public PmLayerE3Path(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        super(pmTableModel, ds123LineModel, n, db);
        this.initParmNames();
        this.numParms = parmNames.length;
    }

    private void initParmNames() {
        parmNames = new String[5];
        PmLayerE3Path.parmNames[0] = "E3 P-ES";
        PmLayerE3Path.parmNames[1] = "E3 P-SES";
        PmLayerE3Path.parmNames[2] = "E3 P-UAS";
        PmLayerE3Path.parmNames[3] = "E3 P-ESR";
        PmLayerE3Path.parmNames[4] = "E3 P-SESR";
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_VALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        if (PmLayerE3Path.db.on) {
            db.println("entering getPmValue - row= " + n + ", interval= " + n2);
        }
        switch (n) {
            case 0: {
                sPmStat2 = this.statsVal[n2].es;
                break;
            }
            case 1: {
                sPmStat2 = this.statsVal[n2].ses;
                break;
            }
            case 2: {
                sPmStat2 = this.statsVal[n2].uas;
                break;
            }
            case 3: {
                bl = true;
                sPmStatRatio2 = this.statsVal[n2].esr;
                break;
            }
            case 4: {
                bl = true;
                sPmStatRatio2 = this.statsVal[n2].sesr;
                break;
            }
        }
        if (PmLayerE3Path.db.on) {
            db.println("leaving getPmValue");
        }
        if (bl) {
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        return new PmRendererStat(sPmStat2);
    }

    @Override
    public String layerLabel() {
        return "E3";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.refreshPmStats(n, eStatsType.PATH_STATS);
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return parmNames.length;
    }

    static {
        db = new SDebug("PmLayerE3Path");
    }
}

