/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.Dwdm.sDwdmOTNPmStats;
import cerent.cms.idl.Dwdm.sOTNLinePmStats;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmOTUPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerOTN
extends PmLayer {
    protected AbstractDwdmLineModel model = null;
    protected int numParms;
    protected int numRegisters;
    protected sOTNLinePmStats[] statsVal;
    public static String[] parmNames = new String[]{"BBE-SM", "ES-SM", "SES-SM", "UAS-SM", "FC-SM", "ESR-SM", "SESR-SM", "BBER-SM", "BBE-PM", "ES-PM", "SES-PM", "UAS-PM", "FC-PM", "ESR-PM", "SESR-PM", "BBER-PM", "BBE-T1", "ES-T1", "SES-T1", "UAS-T1", "FC-T1", "ESR-T1", "SESR-T1", "BBER-T1", "BBE-T2", "ES-T2", "SES-T2", "UAS-T2", "FC-T2", "ESR-T2", "SESR-T2", "BBER-T2"};
    public static String[] nonTcmParmNames = new String[]{"BBE-SM", "ES-SM", "SES-SM", "UAS-SM", "FC-SM", "ESR-SM", "SESR-SM", "BBER-SM", "BBE-PM", "ES-PM", "SES-PM", "UAS-PM", "FC-PM", "ESR-PM", "SESR-PM", "BBER-PM"};
    public static String[] parmSectionNames = new String[]{"BBE-SM", "ES-SM", "SES-SM", "UAS-SM", "FC-SM", "ESR-SM", "SESR-SM", "BBER-SM"};
    public static final int SECTION_BBE = 0;
    public static final int SECTION_ES = 1;
    public static final int SECTION_SES = 2;
    public static final int SECTION_UAS = 3;
    public static final int SECTION_FC = 4;
    public static final int SECTION_ESR = 5;
    public static final int SECTION_SESR = 6;
    public static final int SECTION_BBER = 7;
    public static final int PATH_BBE = 8;
    public static final int PATH_ES = 9;
    public static final int PATH_SES = 10;
    public static final int PATH_UAS = 11;
    public static final int PATH_FC = 12;
    public static final int PATH_ESR = 13;
    public static final int PATH_SESR = 14;
    public static final int PATH_BBER = 15;
    public static final int TCM_1_BBE = 16;
    public static final int TCM_1_ES = 17;
    public static final int TCM_1_SES = 18;
    public static final int TCM_1_UAS = 19;
    public static final int TCM_1_FC = 20;
    public static final int TCM_1_ESR = 21;
    public static final int TCM_1_SESR = 22;
    public static final int TCM_1_BBER = 23;
    public static final int TCM_2_BBE = 24;
    public static final int TCM_2_ES = 25;
    public static final int TCM_2_SES = 26;
    public static final int TCM_2_UAS = 27;
    public static final int TCM_2_FC = 28;
    public static final int TCM_2_ESR = 29;
    public static final int TCM_2_SESR = 30;
    public static final int TCM_2_BBER = 31;
    private static final sDwdmOTNPmStats _defaultOtnStruct = new sDwdmOTNPmStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
    private static final sDwdmOTNPmStats[] temp = new sDwdmOTNPmStats[]{_defaultOtnStruct, _defaultOtnStruct, _defaultOtnStruct, _defaultOtnStruct};
    private static final sOTNLinePmStats _defaultOtnStats = new sOTNLinePmStats(temp);
    private static final SDebug db = new SDebug("PmLayerOTN");

    public PmLayerOTN(PmTableModel pmTableModel, AbstractDwdmLineModel abstractDwdmLineModel, int n) {
        super(pmTableModel, abstractDwdmLineModel, true);
        this.model = abstractDwdmLineModel;
        this.numRegisters = n;
        this.numParms = parmNames.length;
        try {
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)abstractDwdmLineModel.getModuleModel();
            DwdmOTUPortModel[] dwdmOTUPortModelArray = dwdmModuleModel.getDwdmOTU2Ports();
            if (dwdmOTUPortModelArray.length != 0 && !dwdmModuleModel.isPolluceCard()) {
                this.numParms = parmSectionNames.length;
            } else if (!dwdmModuleModel.supportTCM()) {
                this.numParms = nonTcmParmNames.length;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.statsVal = new sOTNLinePmStats[n];
        this.tossData();
    }

    @Override
    public void clearStats() {
        try {
            this.model.getIOTULineModel().clearOTNStats(this.nearEnd, this.intervalType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        switch (n) {
            case 0: {
                return new PmRendererStat(this.statsVal[n2].otnPm[0].bbe);
            }
            case 1: {
                return new PmRendererStat(this.statsVal[n2].otnPm[0].es);
            }
            case 2: {
                return new PmRendererStat(this.statsVal[n2].otnPm[0].ses);
            }
            case 3: {
                return new PmRendererStat(this.statsVal[n2].otnPm[0].uas);
            }
            case 4: {
                return new PmRendererStat(this.statsVal[n2].otnPm[0].fc);
            }
            case 5: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[0].esr);
            }
            case 6: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[0].sesr);
            }
            case 7: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[0].bber);
            }
            case 8: {
                return new PmRendererStat(this.statsVal[n2].otnPm[1].bbe);
            }
            case 9: {
                return new PmRendererStat(this.statsVal[n2].otnPm[1].es);
            }
            case 10: {
                return new PmRendererStat(this.statsVal[n2].otnPm[1].ses);
            }
            case 11: {
                return new PmRendererStat(this.statsVal[n2].otnPm[1].uas);
            }
            case 12: {
                return new PmRendererStat(this.statsVal[n2].otnPm[1].fc);
            }
            case 13: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[1].esr);
            }
            case 14: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[1].sesr);
            }
            case 15: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[1].bber);
            }
            case 16: {
                return new PmRendererStat(this.statsVal[n2].otnPm[2].bbe);
            }
            case 17: {
                return new PmRendererStat(this.statsVal[n2].otnPm[2].es);
            }
            case 18: {
                return new PmRendererStat(this.statsVal[n2].otnPm[2].ses);
            }
            case 19: {
                return new PmRendererStat(this.statsVal[n2].otnPm[2].uas);
            }
            case 20: {
                return new PmRendererStat(this.statsVal[n2].otnPm[2].fc);
            }
            case 21: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[2].esr);
            }
            case 22: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[2].sesr);
            }
            case 23: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[2].bber);
            }
            case 24: {
                return new PmRendererStat(this.statsVal[n2].otnPm[3].bbe);
            }
            case 25: {
                return new PmRendererStat(this.statsVal[n2].otnPm[3].es);
            }
            case 26: {
                return new PmRendererStat(this.statsVal[n2].otnPm[3].ses);
            }
            case 27: {
                return new PmRendererStat(this.statsVal[n2].otnPm[3].uas);
            }
            case 28: {
                return new PmRendererStat(this.statsVal[n2].otnPm[3].fc);
            }
            case 29: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[3].esr);
            }
            case 30: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[3].sesr);
            }
            case 31: {
                return new PmRendererStatRatio(this.statsVal[n2].otnPm[3].bber);
            }
        }
        db.println("WARNING: PmLayerOTN.getPmValue needs updating, unknown value " + n);
        return null;
    }

    @Override
    public String layerLabel() {
        return "Port";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            if (this.statsVal[n] == null || this.statsVal[n] == _defaultOtnStats) {
                this.statsVal[n] = _defaultOtnStats;
                this.statsVal[n] = this.model.getIOTULineModel().getOTNStats(this.nearEnd, this.intervalType, (short)n);
                if (db.on() && n == 0) {
                    this.printStats(0);
                }
            }
        }
        catch (InternalCommError internalCommError) {
            this.statsVal[n] = new sOTNLinePmStats(temp);
            throw internalCommError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    private void printStats(int n) {
        db.println("Section bbe= " + this.strPmStat(this.statsVal[n].otnPm[0].bbe) + " es=" + this.strPmStat(this.statsVal[n].otnPm[0].es) + " ses=" + this.strPmStat(this.statsVal[n].otnPm[0].ses) + " uas=" + this.strPmStat(this.statsVal[n].otnPm[0].uas) + " fc=" + this.strPmStat(this.statsVal[n].otnPm[0].fc) + " esr=" + this.strPmStat(this.statsVal[n].otnPm[0].esr) + " sesr=" + this.strPmStat(this.statsVal[n].otnPm[0].sesr) + " bber=" + this.strPmStat(this.statsVal[n].otnPm[0].bber));
        db.println("Path bbe=" + this.strPmStat(this.statsVal[n].otnPm[1].bbe) + " es=" + this.strPmStat(this.statsVal[n].otnPm[1].es) + " ses=" + this.strPmStat(this.statsVal[n].otnPm[1].ses) + " uas=" + this.strPmStat(this.statsVal[n].otnPm[1].uas) + " fc=" + this.strPmStat(this.statsVal[n].otnPm[1].fc) + " esr=" + this.strPmStat(this.statsVal[n].otnPm[1].esr) + " sesr=" + this.strPmStat(this.statsVal[n].otnPm[1].sesr) + " bber=" + this.strPmStat(this.statsVal[n].otnPm[1].bber));
        db.println("TCM1 bbe=" + this.strPmStat(this.statsVal[n].otnPm[2].bbe) + " es=" + this.strPmStat(this.statsVal[n].otnPm[2].es) + " ses=" + this.strPmStat(this.statsVal[n].otnPm[2].ses) + " uas=" + this.strPmStat(this.statsVal[n].otnPm[2].uas) + " fc=" + this.strPmStat(this.statsVal[n].otnPm[2].fc) + " esr=" + this.strPmStat(this.statsVal[n].otnPm[2].esr) + " sesr=" + this.strPmStat(this.statsVal[n].otnPm[2].sesr) + " bber=" + this.strPmStat(this.statsVal[n].otnPm[2].bber));
        db.println("TCM2 bbe=" + this.strPmStat(this.statsVal[n].otnPm[3].bbe) + " es=" + this.strPmStat(this.statsVal[n].otnPm[3].es) + " ses=" + this.strPmStat(this.statsVal[n].otnPm[3].ses) + " uas=" + this.strPmStat(this.statsVal[n].otnPm[3].uas) + " fc=" + this.strPmStat(this.statsVal[n].otnPm[3].fc) + " esr=" + this.strPmStat(this.statsVal[n].otnPm[3].esr) + " sesr=" + this.strPmStat(this.statsVal[n].otnPm[3].sesr) + " bber=" + this.strPmStat(this.statsVal[n].otnPm[3].bber));
    }

    private String strPmStat(sPmStat sPmStat2) {
        if (sPmStat2.valid) {
            return Integer.toString(sPmStat2.cnt);
        }
        return "#";
    }

    private String strPmStat(sPmStatRatio sPmStatRatio2) {
        if (sPmStatRatio2.valid) {
            return Integer.toString(sPmStatRatio2.cnt);
        }
        return "#";
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return this.numParms;
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        this.model = (AbstractDwdmLineModel)interfaceModel;
    }

    @Override
    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
    }

    @Override
    public boolean isHigherPmDisplayed() {
        return false;
    }
}

