/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.EqTypeListCellRenderer;
import cerent.cms.ui.Pane;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class PpmCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create PPM";
    private JButton okButton;
    private JButton cancelButton;
    private PpmCreatePane createPane;

    public static PpmCreationDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new PpmCreationDialog(frame, pane);
    }

    private PpmCreationDialog(Frame frame, Object object) {
        super(frame, TITLE, true, (Object)((Pane)object));
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        Pane pane = (Pane)object;
        jPanel.add((Component)this.getCreatePanel(pane), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        if (this.createPane != null) {
            this.createPane.destroy();
            this.createPane = null;
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                this.dispose();
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.toString());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.createPane.apply();
    }

    private JPanel getCreatePanel(Pane pane) {
        this.createPane = new PpmCreatePane(pane);
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    class PluggableSlotListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public PluggableSlotListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof PluggableSlotModel) {
                int[] nArray = ((PluggableSlotModel)object).getHierarchyNums();
                this.setText(PluggableHelper.getHierarchyNumString(nArray, '-'));
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    class PpmCreatePane
    extends JPanel
    implements ActionListener {
        protected JComboBox ppmNumCB;
        protected JComboBox ppmTypeCB;
        protected Pane parent;

        public PpmCreatePane(Pane pane) {
            this.parent = pane;
            this.add(this.createAttrsPanel());
        }

        public void destroy() {
            this.parent = null;
        }

        private Component createAttrsPanel() {
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.fillHorizontal();
            IModel iModel = this.parent.getUiModel();
            List list = new ArrayList();
            if (iModel instanceof PluggableCarrierModel) {
                list = ((PluggableCarrierModel)iModel).getAvailablePpmSlots();
            }
            this.ppmNumCB = new JComboBox<PluggableSlotModel>(list.toArray(new PluggableSlotModel[0]));
            this.ppmNumCB.setRenderer(new PluggableSlotListCellRenderer());
            this.ppmNumCB.addActionListener(this);
            this.ppmTypeCB = new JComboBox();
            this.ppmTypeCB.setRenderer(new EqTypeListCellRenderer((NodeModelDelegate)iModel.getNodeModel()));
            this.ppmTypeCB.setModel(new DefaultComboBoxModel<eEqType>(this.getPluggableTypeList()));
            UComboBox.setPreferredWidth((JComboBox)this.ppmNumCB, (int)(this.ppmNumCB.getPreferredSize().width + 10));
            UComboBox.setPreferredWidth((JComboBox)this.ppmTypeCB, (int)(this.ppmTypeCB.getPreferredSize().width + 10));
            gridBagPanel.add("PPM", 0, 0);
            gridBagPanel.add((Component)this.ppmNumCB, 1, 0);
            gridBagPanel.add("PPM Type ", 0, 1);
            gridBagPanel.add((Component)this.ppmTypeCB, 1, 1);
            return gridBagPanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.ppmNumCB) {
                this.ppmTypeCB.setModel(new DefaultComboBoxModel<eEqType>(this.getPluggableTypeList()));
            }
        }

        private eEqType[] getPluggableTypeList() {
            eEqType[] eEqTypeArray = new eEqType[]{};
            Object object = this.ppmNumCB.getSelectedItem();
            if (object instanceof PluggableSlotModel) {
                PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)object;
                eEqTypeArray = pluggableSlotModel.getPluggableTypeList();
            }
            return eEqTypeArray;
        }

        public void apply() {
            this.applyChangesToModel();
        }

        public void applyChangesToModel() {
            try {
                Object object = this.ppmNumCB.getSelectedItem();
                Object object2 = this.ppmTypeCB.getSelectedItem();
                if (object instanceof PluggableSlotModel && object2 instanceof eEqType) {
                    PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)object;
                    eEqType eEqType2 = (eEqType)object2;
                    pluggableSlotModel.provisionPluggable(eEqType2);
                }
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_APPLY_CHANGES);
            }
            catch (ResourceInUse resourceInUse) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_APPLY_CHANGES);
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                ErrorMsg.displayDetailed((Component)this, EMC.EID_FAIL_APPLY_CHANGES, notSupportedOnEquipment.getMessage());
            }
        }
    }
}

