/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PpmTableModel
extends AbstractTableModel {
    private PpmModel[] _models;
    private TDMTerminology _terms;
    private SDebug _db;
    private int _numLines;
    private int _numCols;
    private EntityCellRenderer _myRenderer;
    private String[] _ppmNums;
    private IServiceState[] _serviceState;
    private String[] _actEqType;
    public static final int PPM_NUM_INDEX = 0;
    public static final int SERVICE_STATE_INDEX = 1;
    public static final int ACT_EQPT_TYPE_INDEX = 2;
    public static final String[] _columnNames = new String[]{"PPM", "Service State", "Actual Equipment Type"};

    public PpmTableModel(PpmModel[] ppmModelArray, TDMTerminology tDMTerminology, SDebug sDebug) {
        this._models = ppmModelArray;
        this._terms = tDMTerminology;
        this._db = sDebug;
        this._numCols = _columnNames.length;
        this._myRenderer = this.getRenderer();
        this.init();
    }

    public EntityCellRenderer getRenderer() {
        return new EntityCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PpmModel ppmModel;
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n >= 0 && n < PpmTableModel.this._numLines && (ppmModel = PpmTableModel.this._models[n]) != null) {
                    this.setRowColor(jTable, jLabel, bl, ppmModel);
                }
                return jLabel;
            }

            private void setRowColor(JTable jTable, JLabel jLabel, boolean bl, PpmModel ppmModel) {
                if (bl) {
                    jLabel.setForeground(ElementDefaults.SELECTION_FG);
                    jLabel.setBackground(ElementDefaults.SELECTION_BG);
                } else {
                    int n = ppmModel.getState().value();
                    if (n == 0 || n == 1) {
                        jLabel.setForeground(ElementDefaults.PRE_PROVISION_FG);
                        jLabel.setBackground(ElementDefaults.PRE_PROVISION_BG);
                    } else if (n == 6) {
                        jLabel.setForeground(ElementDefaults.DELETED_FG);
                        jLabel.setBackground(ElementDefaults.DELETED_BG);
                    } else {
                        jLabel.setForeground(jTable.getForeground());
                        jLabel.setBackground(jTable.getBackground());
                    }
                }
            }
        };
    }

    protected void init() {
        this._numLines = this._models == null ? 0 : this._models.length;
        this._ppmNums = new String[this._numLines];
        this._serviceState = new IServiceState[this._numLines];
        this._actEqType = new String[this._numLines];
    }

    @Override
    public int getRowCount() {
        return this._numLines;
    }

    @Override
    public int getColumnCount() {
        return this._numCols;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return _columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string;
        block7: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getPpmNum(n);
                        break;
                    }
                    case 1: {
                        string = this.getServiceState(n).toString(this._terms);
                        break;
                    }
                    case 2: {
                        string = this.getActEqType(n);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this._db.println("Caught Exception in getValueAt");
                if (!this._db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getPpmNum(int n) {
        if (this._ppmNums[n] == null) {
            this._ppmNums[n] = this._myRenderer.getString(this._models[n], "");
        }
        return this._ppmNums[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this._serviceState[n] == null) {
            this._serviceState[n] = ServiceStateFactory.getServiceState(this._models[n].getServiceState());
        }
        return this._serviceState[n];
    }

    private String getActEqType(int n) {
        if (this._actEqType[n] == null) {
            this._actEqType[n] = this._models[n].getMfgData().name;
        }
        return this._actEqType[n];
    }

    public void refreshFromModel() {
        for (int i = 0; i < this._numLines; ++i) {
            this._ppmNums[i] = null;
            this._serviceState[i] = null;
            this._actEqType[i] = null;
        }
        this.fireTableRowsUpdated(0, this._numLines - 1);
    }

    public void refreshMyLines(PpmModel[] ppmModelArray) {
        this._models = ppmModelArray;
        this.init();
        this.fireTableDataChanged();
    }
}

