/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.psm;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.APCCorrectionPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.ObflPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.oadm.OadmInventoryPane;
import cerent.cms.ui.oadm.OadmPerfPane;
import cerent.cms.ui.psm.PsmAlsPane;
import cerent.cms.ui.psm.PsmProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class PsmCardTabbedView
extends CardTabbedView
implements ITabName {
    ModuleModel module = null;
    NodeModelDelegate node = null;
    private static final SDebug db = new SDebug("PsmCardTabbedView");

    public PsmCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
    }

    @Override
    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    private void init() {
        this.module = (ModuleModel)this.getUiModel();
        this.node = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.showTabs();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Pane getPerformanceTab() {
        return new OadmPerfPane("Performance", this, this.module);
    }

    @Override
    public Pane getProvTab() {
        return new PsmProvPane("Provisioning", this, this.module);
    }

    public Pane getInventoryTab() {
        return new OadmInventoryPane("Inventory", this);
    }

    @Override
    public Pane getMaintenanceTab() {
        return new AbstractSubTabbedPane("Maintenance", (TabbedView)this){

            @Override
            public void createSubTabs() {
                OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
                OpticsLineModel[] opticsLineModelArray = opticsModuleModel.getOpticsLineModels();
                this.subTabs.addTab("ALS", (Component)((Object)new PsmAlsPane("ALS", this.subTabs, opticsModuleModel)));
                this.subTabs.addTab("Protection", (Component)CardTabbedView.getProtectionPane(this.subTabs));
                this.subTabs.addTab("APC", (Component)((Object)new APCCorrectionPane("APC", this.subTabs, opticsModuleModel)));
                if (opticsModuleModel.isOFBLSupported()) {
                    this.subTabs.addTab("OBFL", (Component)PsmCardTabbedView.this.getOBFLTab(opticsModuleModel));
                }
            }
        };
    }

    protected Pane getOBFLTab(OpticsModuleModel opticsModuleModel) {
        return new ObflPane("OBFL", this, opticsModuleModel);
    }
}

