/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sIdStats;
import cerent.cms.idl.Rmon.sTimedIdStats;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchSampleIndex;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.rmon.RmonPmHistPane;
import cerent.util.Debug;
import cerent.util.IAsyncObserver;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.job.JobStatus;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public class RmonPmHistTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel,
Runnable {
    public static final int FIXED_COLUMNS = 1;
    private static final eStatsId[] NO_STATS_ID = new eStatsId[0];
    private static final String[] NO_PARMS_NAME = new String[0];
    protected String[] parmNames;
    protected int numRows;
    protected int numCols;
    protected boolean refresh;
    protected eStatsId[] statsIdList;
    protected HashMap[] timedStats;
    protected String lastIntervalTimeStamp;
    protected IRmonModel rmonModel;
    private EventUtilities eventUtilities;
    private final RmonPmHistPane parent;
    private int seriesIndex = 0;
    private IAsyncObserver jobObserver;
    private boolean jobInProgress = false;
    private static final Debug db = new Debug("RmonPmHistTableModel");

    public RmonPmHistTableModel(RmonPmHistPane rmonPmHistPane, ModuleModel moduleModel) {
        this.parent = rmonPmHistPane;
        this.refresh = false;
        this.numCols = 0;
        this.lastIntervalTimeStamp = "";
        this.eventUtilities = EventUtilities.getInstance(moduleModel.getNodeModelDelegate());
    }

    public void refresh(IRmonModel iRmonModel, int n, IAsyncObserver iAsyncObserver) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface, NoSuchSampleIndex, InternalCommError, WrongInterfaceType {
        this.rmonModel = iRmonModel;
        this.seriesIndex = n;
        if (this.jobInProgress) {
            if (iAsyncObserver != null) {
                iAsyncObserver.asyncUpdate(null, null);
            }
        } else {
            this.jobInProgress = true;
            this.jobObserver = iAsyncObserver;
            new Thread((Runnable)this, "RmonPmHistTableModel retrieve PM").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        if (this.numCols != ElementDefaults.getMaxBuckets(this.seriesIndex)) {
            this.numCols = ElementDefaults.getMaxBuckets(this.seriesIndex);
            bl = true;
        }
        this.refresh = false;
        this.lastIntervalTimeStamp = "";
        try {
            if (this.rmonModel == null) {
                this.statsIdList = NO_STATS_ID;
                this.parmNames = NO_PARMS_NAME;
                this.numRows = this.parmNames.length;
                return;
            }
            this.statsIdList = this.rmonModel.getCumulativeStatsIdList();
            this.parmNames = this.rmonModel.getStatsIdListStr(this.statsIdList);
            this.numRows = this.parmNames.length;
            this.refreshStats();
            this.refresh = true;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught " + exception + " in RmonPmHistTableModel.run");
                Debug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            if (bl) {
                this.fireTableStructureChanged();
                this.parent.fixedUpColumn();
            } else {
                this.fireTableDataChanged();
            }
            this.jobInProgress = false;
            if (this.jobObserver != null) {
                this.jobObserver.asyncUpdate(null, JobStatus.JOB_COMPLETE);
                this.jobObserver = null;
            }
        }
    }

    protected void updateRetrieveLabel(String string) {
        if (this.jobObserver != null) {
            this.jobObserver.asyncUpdate((Object)string, new JobStatus(1));
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.parmNames[n];
        }
        if (this.refresh && n2 < this.timedStats.length + 1) {
            return this.timedStats[n2 - 1].get(this.statsIdList[n]);
        }
        return null;
    }

    protected void refreshStats() throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface, WrongInterfaceType, NoSuchSampleIndex, InternalCommError {
        this.timedStats = new HashMap[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            this.updateRetrieveLabel("data for interval " + this.getColumnName(i) + " of " + ElementDefaults.PM_INTERVAL_TYPES[this.seriesIndex].getKey());
            sTimedIdStats sTimedIdStats2 = this.rmonModel.getHistoricalStats((short)this.seriesIndex, i);
            this.timedStats[i] = this.convertIdStats(sTimedIdStats2.statsSeries);
            if (this.lastIntervalTimeStamp.length() != 0 || !this.hasValidStats(sTimedIdStats2.statsSeries)) continue;
            this.lastIntervalTimeStamp = this.eventUtilities.convertSecondsToLongDateFormat(sTimedIdStats2.timeStamp);
        }
    }

    public String getLastIntervalTimeStamp() {
        return this.lastIntervalTimeStamp;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 1 + this.numCols;
    }

    @Override
    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        return ElementDefaults.PREV_60_COLUMN_NAMES[n - 1];
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    public int getFixedColumnCount() {
        return 1;
    }

    public void dispose() {
        this.jobInProgress = false;
    }

    private HashMap convertIdStats(sIdStats[] sIdStatsArray) {
        HashMap<eStatsId, Long> hashMap = new HashMap<eStatsId, Long>();
        for (int i = 0; i < sIdStatsArray.length; ++i) {
            hashMap.put(sIdStatsArray[i].statId, new Long(sIdStatsArray[i].count));
        }
        return hashMap;
    }

    private boolean hasValidStats(sIdStats[] sIdStatsArray) {
        for (int i = 0; i < sIdStatsArray.length; ++i) {
            if (sIdStatsArray[i].count == -1L) continue;
            return true;
        }
        return false;
    }
}

