/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowTableModel;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class AbstractShelfTablePane
extends ObserverPane
implements TableModelListener,
ListSelectionListener {
    protected String ENTRY_TYPE = "Abstract";
    protected NodeModelDelegate nodeModel;
    protected AbstractTableModel model;
    protected List tableData = null;
    private boolean inited = false;
    protected static final String RETRIEVE_STRING = "Retrieve";

    public AbstractShelfTablePane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    }

    public AbstractShelfTablePane(String string, TabbedView tabbedView) {
        this(string, null, tabbedView);
    }

    private void localInit0() {
        this.initModels();
        this.tableData = new ArrayList();
        this.table = new UTable((TableModel)this.model);
        this.table.setSelectionForeground(Color.white);
        if (this.model instanceof RowTableModel) {
            ((RowTableModel)this.model).initTable(this.table);
        }
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.model.addTableModelListener(this);
    }

    protected abstract void localInit();

    protected abstract void initModels();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        if (!this.inited) {
            this.localInit0();
            this.localInit();
            this.inited = true;
        }
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
        if (this.model instanceof SortableRowTableModel) {
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.table != null && this.model != null && this.model instanceof SortableRowTableModel) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
    }

    protected abstract void populateTableData();

    @Override
    public void refresh() {
    }

    public void repopulateTable() {
        if (db.on()) {
            db.println(this.getClass().toString() + " repopulateTable called, " + "setShowing= " + this.isShowing());
        }
        if (this.nodeModel != null && this.nodeModel.isInited() && this.nodeModel.getConnectionState()) {
            this.tableData.clear();
            this.populateTableData();
            if (this.model instanceof RowTableModel) {
                ((RowTableModel)this.model).dataSourceChanged();
            } else {
                this.model.fireTableDataChanged();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void destroy() {
        if (this.table != null && this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().removeListSelectionListener(this);
            this.tableData.clear();
        }
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        super.destroy();
    }

    protected void clearTableSelection() {
        if (this.table != null && !this.tableData.isEmpty()) {
            this.table.removeRowSelectionInterval(0, this.tableData.size() - 1);
        }
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    protected String getTimeStampString() {
        return "Retrieved: " + AbstractShelfTablePane.getFormattedDateTime();
    }
}

