/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ISecurityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.SmpDiagnosticExportModel;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFileChooser;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractSmpDiagnosticPane
extends AbstractPane
implements ActionListener,
IJobListener {
    protected static final String DIAG_MESSAGE = "The node diagnostic logs are NOT the \"Tech Support script \" output.\nPlease consult the Optical Networking support area of the cisco.com\nwebsite or contact CISCO technical support for more information on the\nTech Support script.";
    protected static final String DIAG_TITLE = "Node Diagnostics";
    protected static final String ALARM_FILENAME = "AlarmTableLog.html";
    protected static final String HISTORY_FILENAME = "HistoryTableLog.html";
    protected static final String CONDITIONS_FILENAME = "ConditionsTableLog.html";
    protected static final String INVENTORY_FILENAME = "InventoryTableLog.html";
    protected static final String AUDIT_FILENAME = "AuditTableLog.html";
    protected static final String CTCDUMPDIAG_FILENAME = "CTCDumpDiagLog.txt";
    protected static final String NODEDIAGS_FILENAME = "NodeDiagnostics.gz";
    protected static final String OBFLDIAGS_FILENAME = "OBFLDiagnostics.bin";
    protected static final String DBBACKUP_FILENAME = "NodeDatabaseBackup.bin";
    protected static final String CTPINST_FILENAME = "CTPInstall.xml";
    protected static final String CTPLOG_FILENAME = "CTPlog.txt";
    protected static final String ZIP_FILENAME = "TechSupportLogs";
    protected static File oldDir = null;
    protected static final String DIAGNOSTIC_TT = "Request a diagnostic file from the ";
    protected JButton diagnosticButton;
    protected JobProgressDialog progressDlg;
    protected SmpDiagnosticExportModel exportModel;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpDiagnosticPane");
    protected NodeModelDelegate nodeModel;
    protected JobController diagsJobController;
    protected JobController zipJobController;
    protected String zipFilename = "";
    protected ArrayList<String> filenamesToZipList;
    protected String tempOutputDir = "";
    protected boolean jobAborted = false;

    public AbstractSmpDiagnosticPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.exportModel = new SmpDiagnosticExportModel(this.nodeModel);
    }

    protected void init() {
    }

    protected void showDiagnosticButtonInfo() {
        CerentDialog.infoDialog((Component)((Object)this), (String)DIAG_MESSAGE, (String)DIAG_TITLE);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.diagnosticButton) {
            String string;
            this.showDiagnosticButtonInfo();
            this.zipFilename = "";
            this.tempOutputDir = "";
            String string2 = this.promptForZipFilename();
            File file = new File(string2);
            String string3 = string = file.getParent() != null ? file.getParent() : "";
            if (string2.length() > 0 && this.obtainOverwritePermission(string + File.separator, string2)) {
                this.getDiagnostics(this.nodeModel, string, string2);
            }
        }
    }

    protected String determineTempDirectoryName(String string, String string2) {
        File file = new File(string2);
        String string3 = file.getName();
        int n = string3.lastIndexOf(".zip");
        String string4 = string3.substring(0, n);
        String string5 = string + string4 + File.separator;
        File file2 = new File(string5);
        boolean bl = file2.exists();
        if (!bl) {
            bl = file2.mkdir();
        }
        if (bl) {
            this.tempOutputDir = string5;
            return string5;
        }
        this.tempOutputDir = "";
        return string;
    }

    protected void getDiagnostics(NodeModelDelegate nodeModelDelegate, String string, String string2) {
        this.diagnosticButton.setEnabled(false);
        String string3 = this.determineTempDirectoryName(string + File.separator, string2);
        String string4 = string3 + ALARM_FILENAME;
        String string5 = string3 + HISTORY_FILENAME;
        String string6 = string3 + CONDITIONS_FILENAME;
        String string7 = string3 + INVENTORY_FILENAME;
        String string8 = string3 + AUDIT_FILENAME;
        String string9 = string3 + CTCDUMPDIAG_FILENAME;
        String string10 = string3 + NODEDIAGS_FILENAME;
        String string11 = string3 + OBFLDIAGS_FILENAME;
        String string12 = string3 + DBBACKUP_FILENAME;
        String string13 = string3 + CTPINST_FILENAME;
        String string14 = string3 + CTPLOG_FILENAME;
        this.zipFilename = string2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.filenamesToZipList = new ArrayList();
        arrayList.add(this.exportModel.createExportAlarmsJob(string4));
        this.filenamesToZipList.add(string4);
        arrayList.add(this.exportModel.createExportHistoryJob(string5));
        this.filenamesToZipList.add(string5);
        arrayList.add(this.exportModel.createExportConditionsJob(string6));
        this.filenamesToZipList.add(string6);
        arrayList.add(this.exportModel.createExportInventoryJob(string7));
        this.filenamesToZipList.add(string7);
        if (this.isUserAuthorizedForAuditTrail()) {
            arrayList.add(this.exportModel.createExportAuditTrailJob(string8));
            this.filenamesToZipList.add(string8);
        }
        arrayList.add(this.exportModel.createExportDumpDiagJob(string9));
        this.filenamesToZipList.add(string9);
        arrayList.add(this.exportModel.createExportCTPInstallJob(string13));
        this.filenamesToZipList.add(string13);
        arrayList.add(this.exportModel.createExportCTPLogJob(string14));
        this.filenamesToZipList.add(string14);
        SecurityLevel securityLevel = nodeModelDelegate.supportsSecureMode() && nodeModelDelegate.isSecureMode() ? SecurityLevel.SUPERUSER : SecurityLevel.PROVISIONING;
        if (this.isUserAuthorized(securityLevel)) {
            arrayList.add(this.exportModel.createExportNodeDiagnosticsJob(string10));
            this.filenamesToZipList.add(string10);
            if (nodeModelDelegate.getPlatform().supportsOBFLDiagnostics()) {
                arrayList.add(this.exportModel.createExportOBFLDiagnosticsJob(string11));
                this.filenamesToZipList.add(string11);
            }
        }
        if (this.isUserAuthorized(SecurityLevel.MAINTENANCE)) {
            arrayList.add(this.exportModel.createExportDatabaseBackupJob(string12));
            this.filenamesToZipList.add(string12);
        }
        this.jobAborted = false;
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Save Node Diagnostic Logs", "", false, true);
        this.diagsJobController = JobControllerFactory.createJC((int)1, (int)500, (IJobProgressControl)this.progressDlg);
        IJobControl[] iJobControlArray = arrayList.toArray(new IJobControl[0]);
        JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobListener)this, (Object)this.diagsJobController);
        this.progressDlg.setGroupAndController(jobGroup, this.diagsJobController);
        this.diagsJobController.submitJob(jobGroup);
    }

    protected String promptForZipFilename() {
        UFileChooser uFileChooser = new UFileChooser();
        uFileChooser.setDialogTitle("Select a Filename for the Node Diagnostics Zip Archive");
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".zip") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Zip Archive Files";
            }
        };
        uFileChooser.addChoosableFileFilter(fileFilter);
        uFileChooser.setAcceptAllFileFilterUsed(false);
        if (oldDir != null) {
            uFileChooser.setCurrentDirectory(oldDir);
        }
        String string = "_" + this.getLimitedNodeName() + ".zip";
        String string2 = ZIP_FILENAME + string;
        File file = new File(string2);
        uFileChooser.setSelectedFile(file);
        int n = uFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            uFileChooser.dispose();
            return "";
        }
        oldDir = uFileChooser.getCurrentDirectory();
        File file2 = new File(oldDir.getAbsolutePath(), uFileChooser.getName(uFileChooser.getSelectedFile()));
        String string3 = file2.getName();
        if (!string3.endsWith(".zip")) {
            String string4 = file2.getAbsolutePath() + ".zip";
            file2 = new File(string4);
        }
        if (file2.getAbsolutePath().length() > 254) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FILENAME_TOO_LONG);
            uFileChooser.dispose();
            return "";
        }
        uFileChooser.dispose();
        return file2.getAbsolutePath();
    }

    protected String getLimitedNodeName() {
        String string = "";
        if (this.nodeModel != null) {
            String string2 = this.nodeModel.getName();
            string = string2.length() > 20 ? string2.substring(string2.length() - 20) : string2;
        }
        return string;
    }

    protected boolean obtainOverwritePermission(String string, String string2) {
        boolean bl;
        String string3 = this.determineTempDirectoryName(string, string2);
        String[] stringArray = new String[]{ALARM_FILENAME, HISTORY_FILENAME, CONDITIONS_FILENAME, INVENTORY_FILENAME, AUDIT_FILENAME, CTCDUMPDIAG_FILENAME, NODEDIAGS_FILENAME, OBFLDIAGS_FILENAME, DBBACKUP_FILENAME};
        boolean bl2 = false;
        for (bl = false; bl < stringArray.length; bl += 1) {
            if (!new File(string3, stringArray[bl]).exists()) continue;
            bl2 = true;
        }
        if (new File(string2).exists()) {
            bl2 = true;
        }
        bl = true;
        if (bl2) {
            bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"At least one of the tech supports logs\nis already present in the selected directory.\nAny existing logs will be overwritten. Continue?", (String)"Overwrite Existing Node Diagnostic Log(s)");
        }
        return bl;
    }

    protected boolean isUserAuthorizedForAuditTrail() {
        SecurityLevel securityLevel;
        ISecurityModel iSecurityModel;
        if (this.nodeModel.isInited() && (iSecurityModel = this.nodeModel.getSecurityModel()) != null && (securityLevel = iSecurityModel.getOperationPrivilege(Operation.RETRIEVE_AUDIT)) != null) {
            return this.isUserAuthorized(securityLevel);
        }
        return this.isUserAuthorized(SecurityLevel.SUPERUSER);
    }

    protected void removeTempExportFiles() {
        Iterator<String> iterator = this.filenamesToZipList.iterator();
        while (iterator.hasNext()) {
            File file = new File(iterator.next());
            file.delete();
        }
        if (this.tempOutputDir != null && this.tempOutputDir.length() > 0) {
            new File(this.tempOutputDir).delete();
        }
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, final IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractSmpDiagnosticPane.this.finishJob(jobStatus, (JobController)object, iJobControl);
            }
        });
    }

    protected void finishJob(JobStatus jobStatus, JobController jobController, IJobControl iJobControl) {
        Object object;
        Object object2;
        String[] stringArray;
        String string = "";
        if (this.progressDlg != null) {
            string = this.progressDlg.getTitle();
        }
        if (jobStatus.value() == 3) {
            this.jobAborted = true;
        } else if (jobStatus.value() == 2) {
            stringArray = jobStatus.getError();
            object2 = "";
            object2 = jobController == null || jobController == this.diagsJobController ? "An error occurred while saving the Node Diagnostic Logs during the following process:\n     " + iJobControl.getName() + "\nCTC will attempt to continue saving additional " + "Node Diagnostic Logs.\nSee details for more information." : "An error occurred while zipping the Node Diagnostic Logs.\nSee details for more information.";
            object = new DetailedLog(3, (String)object2, (Throwable)stringArray);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, object);
        }
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
            if (this.progressDlg != null) {
                this.progressDlg.dispose();
                this.progressDlg = null;
            }
            if (jobController == this.zipJobController) {
                this.zipJobController = null;
                if (jobStatus.value() != 2) {
                    this.removeTempExportFiles();
                }
                this.enableComponent(this.diagnosticButton);
                CerentDialog.infoDialog((Component)((Object)this), (String)"Save Node Diagnostic Logs completed.", (String)"Save Node Diagnostic Logs");
            } else if (this.zipJobController == null) {
                if (this.jobAborted) {
                    CerentDialog.infoDialog((Component)((Object)this), (String)(string + " aborted."), (String)string);
                    this.enableComponent(this.diagnosticButton);
                } else if (this.filenamesToZipList.size() > 0) {
                    stringArray = this.filenamesToZipList.toArray(new String[0]);
                    object2 = this.getZipRelativePaths(stringArray);
                    object = this.exportModel.createZipFilesJob(this.zipFilename, stringArray, (String[])object2);
                    this.zipJobController = JobControllerFactory.createJC((int)1, (int)500, null);
                    JobGroup jobGroup = new JobGroup((IJobControl)object, (IJobListener)this, (Object)this.zipJobController);
                    this.zipJobController.submitJob(jobGroup);
                } else {
                    this.enableComponent(this.diagnosticButton);
                }
            }
        }
    }

    protected String[] getZipRelativePaths(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.tempOutputDir);
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(stringArray[i]);
            String string = file.getName() + File.separator + file2.getName();
            arrayList.add(string);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    protected JButton addDiagnosticButton(Container container) {
        this.diagnosticButton = new JButton("Node Diagnostic Logs...");
        this.diagnosticButton.addActionListener(this);
        this.diagnosticButton.setDefaultCapable(false);
        this.diagnosticButton.setToolTipText(DIAGNOSTIC_TT + this.nodeModel.getPlatform().getControlCardName());
        this.diagnosticButton.setAlignmentX(0.5f);
        container.add(this.diagnosticButton);
        return this.diagnosticButton;
    }

    @Override
    public void enteringPage() {
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void refresh() {
    }
}

