/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.sRingMapEntry;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.ui.shelf.SppRingPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class BlsrRingMapDialog
extends UDialog
implements ActionListener {
    private static final String CLOSE = "Close";
    private static final Dimension TABLE_DIM_SMALL = new Dimension(300, 300);
    private static final int NULL_NODEID = 255;
    private static final String[] columnNames = new String[]{"Node ID", "IP Address"};
    private JButton closeButton;
    private RingMapTableModel ringMapTableModel;
    private BlsrModel blsrModel;
    private static SDebug db = new SDebug("BlsrRingMapDialog");

    public static BlsrRingMapDialog instance(SppRingPane sppRingPane, BlsrModel blsrModel) {
        INodeModel iNodeModel = blsrModel.getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        String string = tDMTerminology.getRingTerms(1) + " Ring Map: Ring Name ";
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)sppRingPane));
        return new BlsrRingMapDialog(frame, blsrModel, string);
    }

    private BlsrRingMapDialog(Frame frame, Object object, String string) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        JPanel jPanel2 = new JPanel();
        this.blsrModel = (BlsrModel)object;
        this.setTitle(this.getTitle() + this.blsrModel.getProvision().ringName);
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        this.closeButton = this.makeActionButton(CLOSE);
        jPanel2.add(this.closeButton);
        this.ringMapTableModel = new RingMapTableModel(this.blsrModel);
        UTable uTable = new UTable((TableModel)this.ringMapTableModel);
        UScrollPane uScrollPane = new UScrollPane((Component)uTable);
        uScrollPane.setPreferredSize(TABLE_DIM_SMALL);
        jPanel.add((Component)uScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    public void dispose() {
        this.ringMapTableModel = null;
        this.blsrModel = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    class RingMapTableModel
    extends AbstractTableModel {
        private sRingMapEntry[] ringMap;
        private int rowCount;
        private int colCount;

        RingMapTableModel(BlsrModel blsrModel) {
            int n = 0;
            if (blsrModel != null) {
                this.ringMap = blsrModel.getRingMap();
                n = this.ringMap.length;
                this.colCount = 2;
                this.rowCount = 0;
                while (this.rowCount < n && this.ringMap[this.rowCount].nodeId != 255) {
                    ++this.rowCount;
                }
            } else {
                this.ringMap = new sRingMapEntry[0];
            }
            if (db.on) {
                db.println("RingMapTableModel(): mapLength = " + n + ", rowCount = " + this.rowCount + ", colCount = " + this.colCount);
            }
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.colCount;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 < 2 && (this.ringMap == null || n >= this.ringMap.length || this.ringMap[n].nodeId == 255)) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return new Short(this.ringMap[n].nodeId);
                }
                case 1: {
                    return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(this.ringMap[n].ipAddr));
                }
            }
            return " ";
        }
    }
}

