/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.CtxMaModuleModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOSConsoleDisabledException;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PimModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SlotModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.IOSConfigDialog;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IOSTelnetFrame;
import java.awt.Component;
import java.util.Iterator;
import org.omg.CORBA.UNKNOWN;

public class CardBehavior {
    public static final String DELETE_CARD = "Delete Card";
    public static final String RESET_CARD = "Reset Card";
    public static final String HARD_RESET_CARD = "Hard-reset Card";
    public static final String SOFT_RESET_CARD = "Soft-reset Card";
    protected static final String OPEN_CARD = "Open Card";
    public static final String CMD_OPEN_IOS = "Open IOS Connection...";
    public static final String CMD_IOS_CONFIG = "IOS Startup Config...";
    private AbstractOpticsLineModel[] opticsLineModels = null;
    private int[] supportedXcCardEqTypes;
    private static final String RESET_WARNING = "Are you sure you want to reset this card?";
    private static final String SOFT_RESET_WARNING = "Are you sure you want to soft-reset this card?";
    private static final String HARD_RESET_WARNING = "Are you sure you want to hard-reset this card?";
    private static final String FORCED_SOFT_RESET = "The soft-reset failed.\nForcing this reset might cause traffic disruption.\n\nDo you want to force a soft-reset of this card?";
    private static final String FORCED_HARD_RESET = "The hard-reset failed.\nForcing this reset might cause traffic disruption.\n\nDo you want to force a hard-reset of this card?";
    protected SDebug db;

    public CardBehavior(IPlatform iPlatform, SDebug sDebug) {
        this.supportedXcCardEqTypes = iPlatform.getSupportedXcCardEqTypes();
        this.db = sDebug;
    }

    protected boolean isCardResetAllowed(ModuleModel moduleModel, StringBuffer stringBuffer, eModuleOp eModuleOp2) {
        ProtectionGroupModel protectionGroupModel;
        if (moduleModel == null) {
            stringBuffer.append("The card is unavailable.");
            return false;
        }
        boolean bl = true;
        String string = "";
        if (eModuleOp2 == eModuleOp.RESET) {
            string = RESET_WARNING;
        } else if (eModuleOp2 == eModuleOp.HARD_RESET) {
            string = HARD_RESET_WARNING;
        } else if (eModuleOp2 == eModuleOp.SOFT_RESET) {
            string = string + SOFT_RESET_WARNING;
        } else if (eModuleOp2 == eModuleOp.FORCE_HARD_RESET) {
            string = FORCED_HARD_RESET;
        } else if (eModuleOp2 == eModuleOp.FORCE_SOFT_RESET) {
            string = FORCED_SOFT_RESET;
        }
        eEqState eEqState2 = null;
        try {
            eEqState2 = moduleModel.getState();
        }
        catch (UNKNOWN uNKNOWN) {
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        if (eEqState2 == eEqState.ACTIVE && moduleModel.isInProtectionGroup() && (protectionGroupModel = moduleModel.getProtectionGroupModel()) != null) {
            ModuleModel moduleModel2 = (ModuleModel)protectionGroupModel.getProtectModuleModel();
            if (moduleModel2 == null) {
                string = "The protection group is not ready. Traffic might be lost.\n" + string;
            } else {
                ModuleModel[] moduleModelArray;
                if (moduleModel == moduleModel2 && (moduleModel2 = protectionGroupModel.getProtectedModuleModel()) == null) {
                    moduleModelArray = (ModuleModel[])protectionGroupModel.getMainModuleModels();
                    if (moduleModelArray.length == 1) {
                        moduleModel2 = moduleModelArray[0];
                    } else {
                        string = "The protection group is not ready. Traffic might be lost.\n" + string;
                    }
                }
                if (moduleModel2 != null) {
                    moduleModelArray = null;
                    try {
                        moduleModelArray = moduleModel2.getState();
                    }
                    catch (UNKNOWN uNKNOWN) {
                        this.db.println("isCardResetAllowed: caught UNKNOWN");
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        this.db.println("isCardResetAllowed: caught NotExist");
                    }
                    if (moduleModelArray == eEqState.NOT_PRESENT) {
                        string = "The protection group is incomplete. Traffic might be lost.\n" + string;
                    } else if (moduleModelArray != eEqState.STANDBY) {
                        if (moduleModel.getEqTypeEnum() == eEqType.XTC_CARD) {
                            bl = false;
                            string = "The other XTC is present but not in standby mode. The card cannot be reset.";
                        } else {
                            string = "The other card in the protection group is not ready. Traffic might be lost.\n" + string;
                        }
                    }
                }
            }
        }
        stringBuffer.append(string);
        return bl;
    }

    protected Exception maybeAnnotateException(ModuleModel moduleModel, Exception throwable) {
        if (moduleModel.getEqTypeEnum() == eEqType.XTC_CARD) {
            throwable = new AnnotatedException("The standby XTC is not ready for this operation.\nPlease try again when initialization completes (up to 5 minutes).", (Exception)throwable);
        } else {
            String string = moduleModel.getEqTypeName();
            if (string != null && (string.startsWith("XC") || string.startsWith("CXC"))) {
                throwable = new AnnotatedException("This operation could not be performed because\nthe required standby " + string + " card was not detected or has an SWMTXMOD alarm raised.\n\n" + "Please verify that a standby " + string + " card is present or clear the alarm.\n", (Exception)throwable);
            } else if (string != null && string.startsWith("TCC")) {
                throwable = new AnnotatedException("This operation could not be performed because\nthe required standby " + string + " card was not detected.\n\n" + "Please verify that a standby " + string + " card is present.\n", (Exception)throwable);
            }
        }
        return throwable;
    }

    public void addCard(final Component component, final EntityModel entityModel, final String string) {
        new Thread("Card Provisioner"){

            @Override
            public void run() {
                try {
                    EntityTableModel entityTableModel = entityModel.getNodeModelDelegate().getEntityTableModel();
                    int n = entityModel.getEntityIndex();
                    eEqType eEqType2 = EntityModel.name2EqType((NodeModelDelegate)entityModel.getNodeModel(), string);
                    if (entityTableModel != null && eEqType2 != null) {
                        entityTableModel.provisionModule(n, eEqType2);
                    }
                }
                catch (ResourceInUse resourceInUse) {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_CARD_SLOT_IN_USE);
                }
                catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
                    SDebug.printStackTrace((Throwable)cmsNodeUpgradingException);
                    ErrorMsg.displayError((Component)component, (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayDetailed(component, EMC.EID_CARD_PROV_ERROR_PARAM_1, "add", eMCProvisionError.getEID().getComposedMessage());
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_ADD);
                }
            }
        }.start();
    }

    public boolean deleteCard(Component component, EntityModel entityModel) {
        Object object;
        IModuleModel[] iModuleModelArray;
        ModuleModel moduleModel;
        String string;
        boolean bl = false;
        int n = entityModel.getEqType();
        String string2 = "Deleting Card";
        if (this.isCrossConnectCard(n)) {
            string = "The cross-connect card cannot be deleted unless no circuits are using this node.\nIs it OK to continue?";
        } else if (this.isProtectInAutomaticProtectionGroup(entityModel, n)) {
            moduleModel = (ModuleModel)entityModel;
            iModuleModelArray = moduleModel.getProtectionGroupModel().getMainModuleModels();
            object = new StringBuffer();
            ((StringBuffer)object).append("The card in Slot ");
            ((StringBuffer)object).append(moduleModel.getSlot());
            ((StringBuffer)object).append(" automatically protects the card in\n");
            ((StringBuffer)object).append("Slot ");
            ((StringBuffer)object).append(iModuleModelArray[0].getSlot());
            ((StringBuffer)object).append(" (");
            ((StringBuffer)object).append(iModuleModelArray[0].getEqLabel());
            ((StringBuffer)object).append(")");
            for (int i = 1; i < iModuleModelArray.length; ++i) {
                ((StringBuffer)object).append(", Slot ");
                ((StringBuffer)object).append(iModuleModelArray[i].getSlot());
                ((StringBuffer)object).append(" (");
                ((StringBuffer)object).append(iModuleModelArray[i].getEqLabel());
                ((StringBuffer)object).append(")");
            }
            ((StringBuffer)object).append(". Deleting the protect card will leave any\n");
            ((StringBuffer)object).append("traffic on the working card unprotected.\n");
            ((StringBuffer)object).append("\nIs it OK to continue?");
            string2 = "Deleting Protect Card";
            string = ((StringBuffer)object).toString();
        } else {
            switch (n) {
                case 129: 
                case 130: 
                case 196: 
                case 239: 
                case 240: 
                case 277: 
                case 278: 
                case 281: 
                case 287: 
                case 321: {
                    moduleModel = (ModuleModel)entityModel;
                    if (this.isDwdmNeType(moduleModel)) {
                        string = "Do you want to continue?";
                        break;
                    }
                    if (this.isPortIS(moduleModel)) {
                        string = "The selected operation will be traffic affecting\nDo you want to continue?";
                        break;
                    }
                    string = "Do you want to continue?";
                    break;
                }
                case 150: {
                    return this.deletePpm(component, entityModel);
                }
                case 238: {
                    iModuleModelArray = (IModuleModel[])entityModel;
                    object = iModuleModelArray.getParent();
                    eEqState eEqState2 = null;
                    string = "Do you want to continue?";
                    try {
                        eEqState2 = iModuleModelArray.getState();
                    }
                    catch (UNKNOWN uNKNOWN) {
                        this.db.println("CardBehavior unknown exception in delete card");
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        this.db.println(" CardBehavior objectNotExistException in delete card");
                    }
                    if (eEqState2 == eEqState.DELETED || eEqState2 == eEqState.NOT_PRESENT || this.MoreIdenticalCards((SlotModel)object, eEqType.MS_ISC_100T_CARD) >= 2) break;
                    string = "If you delete this card, the node is lost and cannot be reached.\nDo you want to continue?";
                    break;
                }
                default: {
                    string = "Do you want to continue?";
                }
            }
        }
        if (CerentDialog.yesNoDialog((Component)component, (String)string, (String)string2)) {
            moduleModel = (ModuleModel)entityModel;
            try {
                moduleModel.unprovision();
                bl = true;
            }
            catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
                ErrorMsg.displayError((Component)component, (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
            }
            catch (ResourceInUse resourceInUse) {
                ModuleModel moduleModel2;
                object = entityModel.getNodeModel().getTDMTerminology();
                StringBuffer stringBuffer = new StringBuffer();
                if (moduleModel.isSupportingBLSR()) {
                    stringBuffer.append("it is supporting the ");
                    stringBuffer.append(object.getRingTerms(1));
                    stringBuffer.append(".");
                } else if (moduleModel.isInProtectionGroup()) {
                    stringBuffer.append("it is part of a protection group.");
                } else if (moduleModel.isSupportingGCC()) {
                    stringBuffer.append("the GCC is in use.");
                } else if (moduleModel.isSupportingSDCC()) {
                    stringBuffer.append(this.getDccInUseStr((TDMTerminology)object, 8));
                } else if (moduleModel.isSupportingLDCC()) {
                    stringBuffer.append(this.getDccInUseStr((TDMTerminology)object, 10));
                } else if (moduleModel.isTimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (moduleModel.isEXT_1TimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (moduleModel.isEXT_2TimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (moduleModel.hasCircuits()) {
                    stringBuffer.append("one or more circuits transit it.");
                } else if (moduleModel.hasOhCircuits()) {
                    stringBuffer.append("one or more overhead circuits transit it.");
                } else if (moduleModel.hasPPC()) {
                    stringBuffer.append("The card cannot be deleted because it is the\norigination or termination for one or more provisionable patchcords.\nDelete the provisionable patchcords, then try again.");
                } else if (moduleModel instanceof DwdmModuleModel) {
                    moduleModel2 = (DwdmModuleModel)moduleModel;
                    if (((DwdmModuleModel)moduleModel2).hasRegenPeer()) {
                        stringBuffer.append("it is part of a regeneration group.");
                    } else if (((DwdmModuleModel)moduleModel2).isInAdmPeerGroup()) {
                        stringBuffer.append("it is part of an ADM peer group.");
                    } else if (((DwdmModuleModel)moduleModel2).hasDWDMPatchCord()) {
                        stringBuffer.append("one or more DWDM patchcords are still up.");
                    } else {
                        stringBuffer.append("it is in use.\n");
                        stringBuffer.append("This card cannot be deleted because \n");
                        stringBuffer.append("at least one client or trunk port\n");
                        stringBuffer.append("is not in the " + AdminState.getAdminTermDSBLD((TDMTerminology)object) + " state.");
                    }
                } else if (moduleModel instanceof OpticsModuleModel) {
                    moduleModel2 = (OpticsModuleModel)moduleModel;
                    if (entityModel.getNodeModelDelegate().getSideModels().hasSideForCard((IModuleModel)moduleModel2)) {
                        stringBuffer.append("\nit is a part of a side.\nDelete the side, then try again.");
                    } else if (n == 128 || n == 127) {
                        if (((OpticsModuleModel)moduleModel2).hasOSCMOC3UsedPorts()) {
                            stringBuffer.append("the OSC is in use.");
                        } else if (((OpticsModuleModel)moduleModel2).hasDWDMPatchCord()) {
                            stringBuffer.append("one or more DWDM patchcords are still up.");
                        }
                    } else if (((OpticsModuleModel)moduleModel2).hasDWDMPatchCord()) {
                        stringBuffer.append("one or more DWDM patchcords are still up.");
                    }
                } else {
                    stringBuffer.append("it is in use.");
                }
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_DELETE_PARAM_1, (Object)stringBuffer.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)component, (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
            }
        }
        return bl;
    }

    protected boolean isProtectInAutomaticProtectionGroup(EntityModel entityModel, int n) {
        boolean bl = false;
        switch (n) {
            case 233: 
            case 234: {
                bl = (entityModel.getNodeModelDelegate().getPlatform().is310ma() || entityModel.getNodeModelDelegate().getPlatform().is310maSDH()) && ((ModuleModel)entityModel).isProtectModule();
                break;
            }
        }
        return bl;
    }

    protected String getDccInUseStr(TDMTerminology tDMTerminology, int n) {
        return "the " + tDMTerminology.getGeneralTerms(n) + " is in use.";
    }

    public void resetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.RESET);
    }

    public void hardResetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.HARD_RESET);
    }

    public void softResetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.SOFT_RESET);
    }

    public void hardResetPim(Component component, PimModel pimModel) {
    }

    private void doResetCard(Component component, ModuleModel moduleModel, eModuleOp eModuleOp2) {
        block15: {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = this.isCardResetAllowed(moduleModel, stringBuffer, eModuleOp2);
            String string = "Resetting card";
            EID eID = EMC.EID_SOFT_RESET_CARD;
            boolean bl2 = false;
            if (eModuleOp2 == eModuleOp.SOFT_RESET) {
                string = "Soft-resetting card";
            } else if (eModuleOp2 == eModuleOp.HARD_RESET) {
                eID = EMC.EID_HARD_RESET_CARD;
                string = "Hard-resetting card";
            } else if (eModuleOp2 == eModuleOp.FORCE_SOFT_RESET) {
                eID = EMC.EID_SOFT_RESET_CARD;
                string = "Force Soft-reset";
                bl2 = true;
            } else if (eModuleOp2 == eModuleOp.FORCE_HARD_RESET) {
                eID = EMC.EID_HARD_RESET_CARD;
                string = "Force Hard-reset";
                bl2 = true;
            }
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = bl2 ? CerentDialog.yesNoWarningDialog((Component)component, (String)stringBuffer.toString(), (String)string) : CerentDialog.yesNoDialog((Component)component, (String)stringBuffer.toString(), (String)string);
                if (bl3) {
                    try {
                        moduleModel.doCommand(eModuleOp2);
                    }
                    catch (ProvisionError provisionError) {
                        if (this.supportsForcedResets(moduleModel) && (eModuleOp2 == eModuleOp.SOFT_RESET || eModuleOp2 == eModuleOp.HARD_RESET)) {
                            this.offerForcedReset(component, moduleModel, eModuleOp2);
                            break block15;
                        }
                        this.doResetError(component, moduleModel, eID);
                    }
                    catch (Busy busy) {
                        ErrorMsg.displayDetailed(component, eID, "The protection group is busy.");
                    }
                    catch (Exception exception) {
                        ErrorMsg.displayError((Component)component, (EID)eID);
                    }
                }
            } else {
                ErrorMsg.displayDetailed(component, eID, stringBuffer.toString());
            }
        }
    }

    public boolean isCardChangeAllowed(ModuleModel moduleModel) {
        if (moduleModel == null) {
            return false;
        }
        int n = -1;
        try {
            n = moduleModel.getServiceSt().getType();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            this.db.println("AbstractCmsObjectNotExistException in addCustomMenuItems");
        }
        return n != 9;
    }

    public boolean isCrossConnectCard(int n) {
        boolean bl = false;
        for (int i = 0; i < this.supportedXcCardEqTypes.length; ++i) {
            if (n != this.supportedXcCardEqTypes[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean supportsGenericResetCard(IPlatform iPlatform, int n, IChassisModel iChassisModel) {
        if (iPlatform.is600() || iPlatform.is310cl() || iPlatform.is310ma() || iPlatform.is310maSDH() || iChassisModel != null && iChassisModel.isUTSChassis() && (n == 330 || n == 331)) {
            return false;
        }
        return n != 187 && n != 283;
    }

    private boolean supportsForcedResets(ModuleModel moduleModel) {
        return moduleModel instanceof CtxMaModuleModel;
    }

    private boolean isDwdmNeType(ModuleModel moduleModel) {
        eDwdmRingType eDwdmRingType2;
        if (this.opticsLineModels == null) {
            this.LoadLineModels(moduleModel);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.opticsLineModels[0].getNodeModel();
        try {
            eDwdmRingType2 = nodeModelDelegate.getANSManager().getNeANSModel().getDwdmRingType();
        }
        catch (Exception exception) {
            eDwdmRingType2 = eDwdmRingType.METRO_CORE;
        }
        return eDwdmRingType2 != eDwdmRingType.NOT_DWDM;
    }

    public boolean isPortIS(ModuleModel moduleModel) {
        boolean bl = false;
        if (this.opticsLineModels == null) {
            this.LoadLineModels(moduleModel);
        }
        try {
            for (int i = 0; i < this.opticsLineModels.length; ++i) {
                int n = this.opticsLineModels[i].getAdminState();
                if (n != 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public void LoadLineModels(ModuleModel moduleModel) {
        OpticsPortModel[] opticsPortModelArray = moduleModel.getChildren().toArray(new OpticsPortModel[0]);
        this.opticsLineModels = new AbstractOpticsLineModel[opticsPortModelArray.length];
        for (int i = 0; i < this.opticsLineModels.length; ++i) {
            this.opticsLineModels[i] = opticsPortModelArray[i].getOpticsLineModel();
        }
    }

    protected boolean deletePpm(Component component, EntityModel entityModel) {
        PpmModel ppmModel = (PpmModel)entityModel;
        boolean bl = CerentDialog.yesNoDialog((Component)component, (String)("Are you sure you want to delete PPM " + PluggableHelper.getHierarchyNumString(ppmModel.getHierarchyNums(), '-') + "?"), (String)"Delete PPM");
        if (bl) {
            IModuleModel iModuleModel = entityModel.getModuleModel();
            TDMTerminology tDMTerminology = entityModel.getNodeModel().getTDMTerminology();
            String string = "A PPM cannot be deleted if:\n\t- It is in a protection group.\n\t- It has a DCC/GCC in use. \n\t- It has overhead circuits.\n\t- The PPM's actual equipment type is UNKNOWN.";
            if (iModuleModel instanceof DwdmModuleModel) {
                int n = iModuleModel.getEqType();
                if (((DwdmModuleModel)iModuleModel).supportTiming()) {
                    string = string + "\n\t- It is a timing source.";
                }
                string = string + "\n\t- The client port is not in the " + AdminState.getAdminTermDSBLD(tDMTerminology) + " state.";
                if (n != 183 && n != 184 && n != 243 && n != 282) {
                    string = string + "\n\t- The trunk port is not in the " + AdminState.getAdminTermDSBLD(tDMTerminology) + " state.";
                }
                if (n == 293) {
                    int n2;
                    block19: {
                        n2 = -1;
                        try {
                            n2 = ((OTU2XpModuleModel)iModuleModel).getCardMode();
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (this.db.on()) {
                                this.db.println("No Such Interface Exception in deletePpm");
                            }
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            if (!this.db.on()) break block19;
                            this.db.println("Wrong Interface Type Exception in deletePpm");
                        }
                    }
                    if (n2 == 4 || n2 == 6) {
                        string = string + "\n\t- The PPM is a part of 10GE LAN to WAN mode on an OTU2_XP card.";
                    }
                }
            } else {
                string = string + "\n\t- It has circuits.\n\t- It is a timing source.";
            }
            string = string + "\n\t- It has LMP data links.";
            try {
                ppmModel.unprovision();
                return true;
            }
            catch (ProvisionError provisionError) {
                EID eID = provisionError.getEID();
                if (eID != null && eID != EMC.EID_GENERIC_PROV_ERROR) {
                    if (eID == EMC.EID_HAS_PEER_GROUP) {
                        ErrorMsg.displayDetailed(component, EMC.EID_FAIL_PPM_DELETE, "It is part of an ADM peer group.");
                    } else {
                        ErrorMsg.displayError((Component)component, (EID)eID, (Object[])provisionError.getEIDParams());
                    }
                } else {
                    ErrorMsg.displayDetailed(component, EMC.EID_FAIL_PPM_DELETE, provisionError.getPrettyMessage() + string);
                }
            }
            catch (ResourceInUse resourceInUse) {
                ErrorMsg.displayDetailed(component, EMC.EID_PORT_IS_IN_USE, string);
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed(component, EMC.EID_FAIL_PPM_DELETE, exception.toString());
            }
        }
        return false;
    }

    public void openIOS(IModuleModel iModuleModel) {
        try {
            IOSTelnetFrame iOSTelnetFrame = IOSTelnetFrame.instance((IModuleModel)iModuleModel);
            iOSTelnetFrame.pack();
            iOSTelnetFrame.setVisible(true);
        }
        catch (IOSConsoleDisabledException iOSConsoleDisabledException) {
            ErrorMsg.displayError(null, (EID)EMC.EID_IOS_CONSOLE_DISABLED, (Object)new Integer(iModuleModel.getSlot()));
        }
    }

    public void openIOSConfig(Component component, IModuleModel iModuleModel) {
        IOSConfigDialog iOSConfigDialog = IOSConfigDialog.instance(component, iModuleModel);
        iOSConfigDialog.pack();
        iOSConfigDialog.setVisible(true);
    }

    protected void doForcedHardReset(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.FORCE_HARD_RESET);
    }

    protected void doForcedSoftReset(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.FORCE_SOFT_RESET);
    }

    private void offerForcedReset(Component component, ModuleModel moduleModel, eModuleOp eModuleOp2) {
        if (eModuleOp2 == eModuleOp.HARD_RESET) {
            this.doForcedHardReset(component, moduleModel);
        } else if (eModuleOp2 == eModuleOp.SOFT_RESET) {
            this.doForcedSoftReset(component, moduleModel);
        }
    }

    private void doResetError(Component component, ModuleModel moduleModel, EID eID) {
        Exception exception = this.maybeAnnotateException(moduleModel, null);
        if (exception instanceof AnnotatedException) {
            ErrorMsg.displayDetailed(component, eID, exception.getMessage());
        } else {
            ErrorMsg.displayError((Component)component, (EID)eID);
        }
    }

    protected int MoreIdenticalCards(SlotModel slotModel, eEqType eEqType2) {
        int n = 0;
        EntityModel entityModel = (EntityModel)slotModel.getParent();
        Iterator iterator = entityModel.getDescendantsOfType(eEqType2).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }
}

