/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FPGAUpdatePane
extends NodeProvPane
implements ActionListener {
    JButton forceUpgrade;
    JPanel fpgaPane;
    private static String CARD_FPGA_UPDATE_MSG = "The FPGA of this card, \ncannot be updated because \nat least one client port\nis not in the OOS,DSBLD state.";

    public FPGAUpdatePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
    }

    private void init() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        this.fpgaPane = new JPanel(new FlowLayout(0, 5, 5));
        Dimension dimension = new Dimension(500, 120);
        this.fpgaPane.setPreferredSize(dimension);
        this.fpgaPane.setMinimumSize(dimension);
        this.forceUpgrade = new JButton("Force FPGA Update");
        this.forceUpgrade.addActionListener(this);
        jPanel.add(this.fpgaPane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        ModuleModel moduleModel = this.getCtx(5);
        if (object == this.forceUpgrade) {
            String string = ErrorMsg.getString((EID)EMC.WID_CARD_MODE_FPGA_FORCE_UPDATE) + "\n\nOK to continue?";
            if (CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string, (String)"Force FPGA Firmware Update")) {
                try {
                    moduleModel.doCommand(eModuleOp.FORCE_FPGA_UPDATE);
                }
                catch (InvalidState invalidState) {
                    this.displayErrorDialog(this, new Exception(CARD_FPGA_UPDATE_MSG), CEMC.EID_FAIL_APPLY_CHANGES);
                }
                catch (ProvisionError provisionError) {
                    ErrorMsg.displayError((Component)this.getParent(), (EID)provisionError.getEID());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return;
        }
        this.setDirty();
    }

    private String[] fetchValues() {
        TreeMap treeMap = new TreeMap();
        String[] stringArray = null;
        ModuleModel moduleModel = this.getCtx(4);
        stringArray = moduleModel == null ? new String[1] : new String[2];
        treeMap.putAll(this.getCtx(5).getExtraInfoMap());
        String string2 = new String();
        for (String string2 : treeMap.keySet()) {
            if (!string2.equals("FPGAID")) continue;
            stringArray[0] = ((String)treeMap.get(string2)).toUpperCase(Locale.ENGLISH);
        }
        if (moduleModel != null) {
            treeMap.clear();
            treeMap.putAll(moduleModel.getExtraInfoMap());
            string2 = new String();
            for (String string2 : treeMap.keySet()) {
                if (!string2.equals("FPGAID")) continue;
                stringArray[1] = ((String)treeMap.get(string2)).toUpperCase(Locale.ENGLISH);
            }
        }
        return stringArray;
    }

    private ModuleModel getCtx(int n) {
        ChassisModel chassisModel = (ChassisModel)this.getUiModel();
        MfgEntityModel mfgEntityModel = null;
        mfgEntityModel = chassisModel.getNodeModelDelegate().isSdh() ? (MfgEntityModel)chassisModel.getChildrenOfType(eEqType.BACKPLANE_15310_MA_ETSI).get(0) : (MfgEntityModel)chassisModel.getChildrenOfType(eEqType.BACKPLANE_15310_MA_ANSI).get(0);
        List list = mfgEntityModel.getChildrenOfType(eEqType.CTX_SLOT);
        ArrayList arrayList = new ArrayList();
        for (SlotModel slotModel : list) {
            if (slotModel.getChildrenOfType(eEqType.CTX_2500_CARD).isEmpty()) continue;
            arrayList.add(slotModel.getChildrenOfType(eEqType.CTX_2500_CARD).get(0));
        }
        ModuleModel[] moduleModelArray = arrayList.toArray(new ModuleModel[0]);
        for (int i = 0; i < moduleModelArray.length; ++i) {
            if (moduleModelArray[i].getEqState() != n) continue;
            return moduleModelArray[i];
        }
        return null;
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.fpgaPane.removeAll();
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        String[] stringArray = this.fetchValues();
        jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(new JLabel("FPGA Revision Number on Active CTX: " + stringArray[0]));
        jPanel.add(Box.createHorizontalStrut(700));
        this.fpgaPane.add(jPanel);
        if (stringArray.length == 2) {
            jPanel = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(new JLabel("FPGA Revision Number on Standby CTX: " + stringArray[1]));
            jPanel.add(Box.createHorizontalStrut(700));
            this.fpgaPane.add(jPanel);
        }
        jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(this.forceUpgrade);
        jPanel.add(Box.createHorizontalStrut(700));
        this.fpgaPane.add(jPanel);
        this.forceUpgrade.setEnabled(true);
        this.fpgaPane.updateUI();
        super.refreshFromModel();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.FPGAUpdatePane;
    }
}

