/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.sIpFtpHost;
import cerent.cms.idl.Common.sIpSubnet;
import cerent.cms.model.FtpHostsModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.table.AbstractTableModel;

public class FtpHostTableModel
extends AbstractTableModel {
    protected FtpHostsModel _model;
    protected boolean[][] isDirty;
    protected INodeModel node;
    protected int numLines;
    public static final int LINENUMBER_INDEX = 0;
    public static final int TPGM_INDEX = 1;
    public static final String[] columnNames = new String[]{"FTP Host Address", "Prefix Length", "Enable FTP Relay", "FTP Relay Timer (minutes)"};
    protected String[] ipAddrs;
    protected String[] mask;
    protected Boolean[] relayEnable;
    protected String[] relayTimer;
    protected static final SDebug db = new SDebug("FtpHostTableModel");

    public FtpHostTableModel(INodeModel iNodeModel, FtpHostsModel ftpHostsModel) {
        this.node = iNodeModel;
        this._model = ftpHostsModel;
        this.init();
    }

    protected void init() {
        sIpFtpHost[] sIpFtpHostArray = this._model.getFtpHosts();
        this.numLines = sIpFtpHostArray.length;
        this.ipAddrs = new String[this.numLines];
        this.mask = new String[this.numLines];
        this.relayEnable = new Boolean[this.numLines];
        this.relayTimer = new String[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 2: {
                this.relayEnable[n] = (Boolean)object;
                if (object != Boolean.FALSE) break;
                this.relayTimer[n] = "0";
                break;
            }
            case 3: {
                this.relayTimer[n] = (String)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 2: {
                return AbstractPane.isUserAuthorized(this._model, SecurityLevel.SUPERUSER);
            }
            case 3: {
                return AbstractPane.isUserAuthorized(this._model, SecurityLevel.SUPERUSER) && this.relayEnable[n] == Boolean.TRUE;
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.ipAddrs[n];
                }
                case 1: {
                    return this.mask[n];
                }
                case 2: {
                    return this.relayEnable[n];
                }
                case 3: {
                    return this.relayTimer[n];
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public sIpFtpHost getRowInfo(int n) {
        sIpFtpHost sIpFtpHost2 = new sIpFtpHost();
        sIpFtpHost2.relayTimer = Integer.parseInt(this.relayTimer[n]);
        sIpFtpHost2.bRelayEnable = this.relayEnable[n];
        sIpFtpHost2.nets = new sIpSubnet();
        sIpFtpHost2.nets.address = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(this.ipAddrs[n]));
        sIpFtpHost2.nets.mask = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(this.mask[n]));
        return sIpFtpHost2;
    }

    public void refreshFromModel() {
        this.init();
        sIpFtpHost[] sIpFtpHostArray = this._model.getFtpHosts();
        for (int i = 0; i < sIpFtpHostArray.length; ++i) {
            this.ipAddrs[i] = FtpHostTableModel.asString(sIpFtpHostArray[i].nets.address);
            this.mask[i] = this.makePrefix(sIpFtpHostArray[i].nets.address, sIpFtpHostArray[i].nets.mask);
            this.relayEnable[i] = sIpFtpHostArray[i].bRelayEnable;
            this.relayTimer[i] = String.valueOf(sIpFtpHostArray[i].relayTimer);
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableDataChanged();
    }

    private String makePrefix(sIpAddr sIpAddr2, sIpAddr sIpAddr3) {
        int n;
        int n2 = 0;
        String string = FtpHostTableModel.asString(sIpAddr2);
        InetAddress inetAddress = null;
        boolean bl = false;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            db.println("Invalid IP Address");
        }
        if (inetAddress.getAddress().length == 4) {
            bl = true;
        }
        int n3 = n = bl ? 12 : 0;
        while (n < 16 && sIpAddr3.addr[n] != 0) {
            ++n2;
            ++n;
        }
        if (n2 > 0) {
            --n2;
        }
        n = n2 * 8;
        n2 = bl ? n2 + 12 : n2;
        return Integer.toString(n += FtpHostTableModel.bitCount(sIpAddr3.addr[n2]));
    }

    private static int bitCount(byte n) {
        int n2 = n;
        int n3 = 85;
        n2 = (n2 & n3) + (n2 >>> 1 & n3);
        n3 = 51;
        n2 = (n2 & n3) + (n2 >>> 2 & n3);
        return (n2 & 7) + (n2 >>> 4);
    }

    private static String asString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    public void refreshLineFromModel(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshMyLines(FtpHostsModel ftpHostsModel) {
        this._model = ftpHostsModel;
        this.init();
        this.fireTableDataChanged();
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }
}

