/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Dimension;

public class GenericPortGraphic
extends AbstractPortGraphic {
    protected String alarmProfileString;
    private static final SDebug db = new SDebug("GenericPortGraphic");
    protected EntityCellRenderer myPortRenderer = new EntityCellRenderer();

    public GenericPortGraphic(CardView cardView, EntityModel entityModel, int n) {
        this(cardView, entityModel, n, false);
    }

    public GenericPortGraphic(CardView cardView, EntityModel entityModel, int n, boolean bl) {
        super(cardView, entityModel, n, bl);
        if (db.on()) {
            db.println("<init>");
        }
        if (entityModel instanceof PortModel && db.on()) {
            db.println("model is instanceof PortModel");
        }
        this.showState();
        this.registerWithModel();
    }

    public GenericPortGraphic(CardView cardView, EntityModel entityModel, int n, boolean bl, Dimension dimension) {
        this(cardView, entityModel, n, bl);
        this.setPreferredSize(dimension);
    }

    @Override
    protected void registerWithModel() {
        if (db.on()) {
            db.println("registerWithModel");
        }
        if (this.model instanceof PortModel) {
            this.model.addObserver(this);
            if (this.ifModel != null) {
                this.ifModel.addObserver(this);
            }
        }
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println("dispose");
        }
        if (this.ifModel != null) {
            this.ifModel.deleteObserver(this);
        }
        if (this.model instanceof PortModel) {
            this.model.deleteObserver(this);
            if (this.ifModel != null) {
                this.ifModel.deleteObserver(this);
            }
        }
    }

    protected String getPortDescription() {
        if (this.ifModel == null) {
            return "";
        }
        try {
            String string = this.ifModel.getPortModel().getInterfaceModel().getAlias();
            String string2 = "";
            IPortModel iPortModel = this.ifModel.getPortModel();
            if (this.ifModel instanceof EtherLineModel || iPortModel.isMutable()) {
                string2 = "(" + PortHelper.getPortTypeString((IEntityModel)iPortModel) + ") ";
            }
            if (iPortModel instanceof OpticsPortModel) {
                string2 = "(" + ((OpticsPortModel)iPortModel).getOptPortTypeString() + ") ";
            }
            if (string.equals("")) {
                return string2 + string;
            }
            return string2 + "\"" + string + "\",";
        }
        catch (Exception exception) {
            db.println("Caught exception in getPortDescription");
            KDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    protected String getStatusLabel() {
        return "Service State: ";
    }

    public void updateToolTip() {
        if (db.on()) {
            db.println("getToolTipText triggered");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.getPortDescription());
            this.alarmProfileString = ((PortModel)this.model).getAlarmProfileName();
            String string = "";
            stringBuffer.append(this.getStatusLabel());
            stringBuffer.append(this.statusString);
            if (this.ifModel.getModuleModel() instanceof DwdmModuleModel) {
                stringBuffer.append(this.myPortRenderer.getDwdmLineProtectionDescription(this.ifModel, true));
            } else if (this.ifModel instanceof TdmLineModel) {
                stringBuffer.append(this.myPortRenderer.getSonetLineProtectionDescription((TdmLineModel)this.ifModel, true));
            }
            stringBuffer.append(", Alarm Profile: ");
            stringBuffer.append(this.alarmProfileString);
            if (string.length() != 0) {
                stringBuffer.append(", SFP: ").append(string);
            }
            this.setToolTipText(stringBuffer.toString());
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error formulating port graphic tooltip text: " + exception);
            }
            this.setToolTipText(null);
        }
    }

    @Override
    protected synchronized void showState() {
        TDMTerminology tDMTerminology;
        int n;
        int n2;
        block4: {
            if (db.on()) {
                db.println("showState for " + this.model);
            }
            n2 = 1;
            n = -1;
            tDMTerminology = this.model.getNodeModel().getTDMTerminology();
            if (this.model instanceof PortModel) {
                try {
                    n2 = ((PortModel)this.model).getAdminState();
                    n = ((PortModel)this.model).getServiceStateType();
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Caught exception in showState: " + exception);
                }
            }
        }
        this.statusString = tDMTerminology.getTermForServiceState(n);
        this.updateToolTip();
        this.setCurrentState(n2);
        this.setCurrentColor(GenericPortGraphic.getPortColorByAdminStateAndSeverity(n2, this.currentSeverity));
        this.repaint();
    }

    protected String getPhysicalMediumDescription() {
        TdmLineModel tdmLineModel;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ifModel instanceof TdmLineModel && !(string = this.myPortRenderer.getMediumTypeStr(tdmLineModel = (TdmLineModel)this.ifModel)).equals("")) {
            stringBuffer.append(" (");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

