/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Node.xInvalidMask;
import cerent.cms.idl.OSI.xInvalidGreTunnelDefaultRouteMask;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToAllOnes;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToBroadcast;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassA;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassB;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassC;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToClassDE;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToInternalNet;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToLocalNet;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToSelf;
import cerent.cms.idl.OSI.xInvalidGreTunnelRouteToSelfSubnet;
import cerent.cms.idl.OSI.xInvalidStaticRouteOrGateway;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DupGRETunnel;
import cerent.cms.model.IModel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.MaxGRETunnels;
import cerent.cms.model.OsiModel;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.GreTunnelCreatePane;
import cerent.cms.ui.shelf.SppOsiGreTunnelPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GreTunnelCreationDialog
extends UDialog
implements ActionListener,
IOsiConstants {
    public static final String TITLE = "Create IP Over CLNS Tunnel";
    private static final String DEFAULT = "Default";
    private JButton okButton;
    private JButton defaultButton;
    private JButton cancelButton;
    GreTunnelCreatePane attributesPane;
    static Object model;

    public static GreTunnelCreationDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        model = pane.getUiModel();
        return new GreTunnelCreationDialog(frame, model, ((SppOsiGreTunnelPane)pane).osiModel);
    }

    private GreTunnelCreationDialog(Frame frame, Object object, OsiModel osiModel) {
        super(frame, TITLE, true, object);
        this.attributesPane.setOsiModel(osiModel);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.createAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.attributesPane.setNodeModel(((IModel)object).getNodeModel());
    }

    public void dispose() {
        if (this.attributesPane != null) {
            this.attributesPane.destroy();
            this.attributesPane = null;
        }
        super.dispose();
        model = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.attributesPane.validateFields();
                this.apply();
                this.dispose();
            }
            catch (MaxGRETunnels maxGRETunnels) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GRE_TUNNEL_MAX);
            }
            catch (DupGRETunnel dupGRETunnel) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GRE_TUNNEL_DUP);
            }
            catch (xInvalidGreTunnelRouteToSelf xInvalidGreTunnelRouteToSelf2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_SELF_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToSelfSubnet xInvalidGreTunnelRouteToSelfSubnet2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_SELF_SUBNET_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToAllOnes xInvalidGreTunnelRouteToAllOnes2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_ALL_ONES_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToLocalNet xInvalidGreTunnelRouteToLocalNet2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_LOCAL_NET_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidMask xInvalidMask2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_INVALID_MASK);
            }
            catch (xInvalidGreTunnelDefaultRouteMask xInvalidGreTunnelDefaultRouteMask2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DEFAULT_ROUTE_MASK);
            }
            catch (xInvalidGreTunnelRouteToInternalNet xInvalidGreTunnelRouteToInternalNet2) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_ROUTE_TO_INTERNAL_NET_2, "GRE tunnel", this.attributesPane.formatInternalSubnets());
            }
            catch (xInvalidGreTunnelRouteToClassDE xInvalidGreTunnelRouteToClassDE2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_DE_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToClassA xInvalidGreTunnelRouteToClassA2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_A_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToClassB xInvalidGreTunnelRouteToClassB2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_B_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToClassC xInvalidGreTunnelRouteToClassC2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_C_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidGreTunnelRouteToBroadcast xInvalidGreTunnelRouteToBroadcast2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_BROADCAST_PARAM_1, (Object)"GRE tunnel");
            }
            catch (xInvalidStaticRouteOrGateway xInvalidStaticRouteOrGateway2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_DEFAULT_ROUTE_GATEWAY);
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_GRE_TUNNEL_ACTION_FAIL_PARAM_2, "create", "Configuration Error");
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_GRE_TUNNEL_ACTION_FAIL_PARAM_2, "create", exception.getMessage());
            }
        } else if (object == this.defaultButton) {
            this.attributesPane.putDefaultGreTunnel();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.attributesPane.applyChangesToModel();
    }

    private JPanel createAttributesPanel() {
        this.attributesPane = new GreTunnelCreatePane(((IModel)model).getNodeModel());
        return this.attributesPane;
    }

    public JPanel getAttributesPanel() {
        return this.attributesPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.defaultButton = this.makeActionButton(DEFAULT);
        jPanel.add(this.defaultButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

