/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.Feature;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.LcdIpSetting;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IpAddrPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    private static final Dimension tabSize = new Dimension(TabbedView.TABBED_VIEW_DIM.width, 250);
    private JTextField ipAddrTF;
    private JTextField defRouterTF;
    private JLabel defRouterLB;
    private JTextField etherMacTF;
    private JLabel netmaskLB;
    private SpinPropertyEditor netmaskEdit;
    private JComboBox lcdIpSettingCB = null;
    private JCheckBox ctcIpSuppressedCB;
    private JLabel ipv6AddrLB;
    private JTextField ipv6AddrTF;
    private JCheckBox enableIpv6;
    private JTextField ipv6AddrPrefixTF;
    private JTextField defRouterV6TF;
    private JLabel defRouterV6LB;
    private boolean mustReboot;
    short netmask;
    boolean userCtcIpDisplaySelection;
    boolean ctcIpDisplaySuppressed;
    boolean isNodeIP;
    int lcdIpSetting;
    int userLcdIpSetting;
    private NodeProvPane parent;
    IIpAddr ipAddr;
    IIpAddr defaultRouter;
    boolean ipv6Mode;
    IIpAddr ipv6Addr;
    short prefixLength;
    IIpAddr defaultRouterV6;
    IEtherMacAddr etherMacAddr;
    private boolean defRouterChanged;
    private boolean ipv6ConfigChanged;
    JPanel ipv6Panel;
    private static final Attribute[] LCD_IP_SETTING_ATTRS = new Attribute[LcdIpSetting.LCD_IP_SETTING.length];
    protected static final SDebug db;

    public IpAddrPanel(NodeProvPane nodeProvPane, boolean bl) {
        this.parent = nodeProvPane;
        this.mustReboot = false;
        this.isNodeIP = bl;
        this.ctcIpSuppressedCB = null;
        this.defRouterChanged = false;
        this.ipv6ConfigChanged = false;
        this.init();
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setPreferredSize(tabSize);
        this.setMaximumSize(tabSize);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.getIpPanel();
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected void getIpPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(Box.createVerticalStrut(40));
        this.ipAddrTF = this.addTextPanel(jPanel, this.createLabel(" Node Address: "), 13, this);
        jPanel.add(Box.createHorizontalStrut(20));
        this.netmaskEdit = new SpinPropertyEditor(" Net/Subnet Mask Length:    ", 1, 8, 30);
        if (this.parent.isUserAuthorized()) {
            this.netmaskEdit.addPropertyChangeListener(this);
        } else {
            this.netmaskEdit.setEnabled(false);
        }
        jPanel.add(this.netmaskEdit);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(new JLabel(" Mask: "));
        this.netmaskLB = new JLabel("255.255.255.252");
        this.netmaskLB.setMaximumSize(this.netmaskLB.getPreferredSize());
        jPanel.add(this.netmaskLB);
        jPanel.add(Box.createRigidArea(new Dimension(100, 20)));
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(Box.createVerticalStrut(30));
        this.etherMacTF = this.addTextPanel(jPanel, this.createLabel(" MAC Address: "), 13, this);
        this.etherMacTF.setEditable(false);
        this.etherMacTF.setForeground(Color.gray);
        this.etherMacTF.setBackground(Color.white);
        jPanel.add(Box.createHorizontalStrut(20));
        this.defRouterLB = new JLabel(" Default Router: ");
        this.defRouterTF = this.addTextPanel(jPanel, this.defRouterLB, 13, this);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(Box.createRigidArea(new Dimension(100, 20)));
        this.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.parent.getUiModel().getNodeModel();
        if (nodeModelDelegate.provides(Feature.IDL_LCDIp)) {
            jPanel.add(Box.createVerticalStrut(40));
            jPanel.add(this.createLabel(" LCD Setting:"));
            this.lcdIpSettingCB = new JComboBox<Attribute>(LCD_IP_SETTING_ATTRS);
            jPanel.add(this.lcdIpSettingCB);
            this.lcdIpSettingCB.setEnabled(this.parent.isUserAuthorized());
            this.lcdIpSettingCB.addActionListener(this);
            jPanel.add(Box.createHorizontalStrut(12));
        }
        this.ctcIpSuppressedCB = new JCheckBox(" Suppress CTC IP Display");
        jPanel.add(this.ctcIpSuppressedCB);
        this.ctcIpSuppressedCB.setEnabled(this.parent.isUserAuthorized());
        this.ctcIpSuppressedCB.addActionListener(this);
        jPanel.add(Box.createRigidArea(new Dimension(100, 20)));
        jPanel.add(Box.createHorizontalStrut(50));
        this.add(jPanel);
        this.ipv6Panel = new JPanel(new GridLayout(3, 1));
        jPanel.add(Box.createVerticalStrut(30));
        this.ipv6Panel.setBorder(BorderFactory.createTitledBorder("IPv6 Configuration"));
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.enableIpv6 = new JCheckBox("Enable IPv6");
        jPanel.add(this.enableIpv6);
        this.ipv6Panel.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(Box.createVerticalStrut(30));
        JLabel jLabel = new JLabel(" IPv6 Address:");
        jLabel.setSize(new Dimension(135, 20));
        jLabel.setPreferredSize(new Dimension(135, 20));
        this.ipv6AddrTF = this.addTextPanel(jPanel, jLabel, 30, this);
        jPanel.add(Box.createHorizontalStrut(20));
        this.enableIpv6.setEnabled(this.parent.isUserAuthorized());
        this.enableIpv6.addActionListener(this);
        JLabel jLabel2 = new JLabel("Prefix Length: ");
        this.ipv6AddrPrefixTF = this.addTextPanel(jPanel, jLabel2, 4, this);
        jPanel.add(Box.createHorizontalStrut(20));
        this.ipv6Panel.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(Box.createVerticalStrut(30));
        this.defRouterV6LB = new JLabel(" IPv6 Default Router: ");
        this.defRouterV6LB.setSize(new Dimension(135, 20));
        this.defRouterV6LB.setPreferredSize(new Dimension(135, 20));
        this.defRouterV6TF = this.addTextPanel(jPanel, this.defRouterV6LB, 30, this);
        jPanel.add(Box.createHorizontalStrut(20));
        this.ipv6Panel.add(jPanel);
        this.add(this.ipv6Panel);
        this.ipv6AddrTF.setEnabled(false);
        this.defRouterV6TF.setEnabled(false);
        this.ipv6AddrPrefixTF.setEnabled(false);
    }

    private JCheckBox addCheckBox(JPanel jPanel, String string, boolean bl, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setEnabled(bl);
        jCheckBox.addActionListener(actionListener);
        jPanel.add(jCheckBox);
        return jCheckBox;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(140, 20));
        return jLabel;
    }

    public void setIpConfig(NodeModelDelegate nodeModelDelegate, IIpAddr iIpAddr, IIpAddr iIpAddr2, short s, boolean bl, IIpAddr iIpAddr3, short s2, IIpAddr iIpAddr4) {
        if (db.on()) {
            db.println("setting node IP config: start");
        }
        NodeModelDelegate nodeModelDelegate2 = nodeModelDelegate;
        boolean bl2 = nodeModelDelegate2.isSecureMode();
        this.ipAddr = iIpAddr;
        this.netmask = s;
        this.defaultRouter = iIpAddr2;
        this.ipv6Mode = bl;
        this.ipv6Addr = iIpAddr3;
        this.prefixLength = s2;
        this.defaultRouterV6 = iIpAddr4;
        if (this.enableIpv6 != null) {
            this.enableIpv6.setSelected(this.ipv6Mode);
        }
        this.ipv6AddrTF.setEnabled(this.ipv6Mode);
        this.defRouterV6TF.setEnabled(this.ipv6Mode);
        this.ipv6AddrPrefixTF.setEnabled(this.ipv6Mode);
        this.userCtcIpDisplaySelection = this.ctcIpDisplaySuppressed = nodeModelDelegate2.getCtcIpDisplaySuppression(this.isNodeIP);
        if (!nodeModelDelegate2.allowIpDisplayed(this.isNodeIP)) {
            this.ipAddrTF.setText("");
        } else {
            this.ipAddrTF.setText(InetUtil.makeDottedString(this.ipAddr));
            if (this.ipv6Mode) {
                this.ipv6AddrTF.setText(InetUtil.makeDottedString(this.ipv6Addr, true));
                this.ipv6AddrPrefixTF.setText(Integer.toString(this.prefixLength));
            }
        }
        if (bl2 && this.isNodeIP) {
            this.defRouterLB.setVisible(false);
            this.defRouterTF.setVisible(false);
            this.ipv6Panel.setVisible(false);
        } else {
            this.defRouterTF.setText(InetUtil.makeDottedString(this.defaultRouter));
            if (this.ipv6Mode) {
                this.defRouterV6TF.setText(InetUtil.makeDottedString(this.defaultRouterV6, true));
            }
        }
        this.netmaskEdit.setValue(String.valueOf(this.netmask));
        this.updateMaskLabel();
        if (nodeModelDelegate2.getPlatform().isPotentiallyLcdIpCapable()) {
            this.lcdIpSetting = nodeModelDelegate2.getLcdIpSetting(this.isNodeIP);
        }
        if (this.lcdIpSettingCB != null) {
            this.lcdIpSettingCB.setSelectedItem(IpAddrPanel.getLcdIpSettingAttr(this.lcdIpSetting));
        }
        if (this.ctcIpSuppressedCB != null) {
            this.ctcIpSuppressedCB.setSelected(this.ctcIpDisplaySuppressed);
        }
        if (db.on()) {
            db.println("refreshFromModel");
            db.println("lcdIpSetting: " + this.lcdIpSetting);
            db.println("ctcIpSetting: " + this.ctcIpDisplaySuppressed);
            db.println("refreshFromModel: finish");
        }
        this.etherMacAddr = this.isNodeIP ? nodeModelDelegate2.getNodeEtherMACAddress() : nodeModelDelegate2.getSecureEtherMACAddress();
        this.etherMacTF.getDocument().removeDocumentListener(this);
        this.etherMacTF.setText(MacAddrFormat.format(this.etherMacAddr.getAddr()));
        this.etherMacTF.getDocument().addDocumentListener(this);
        this.mustReboot = false;
        this.defRouterChanged = false;
        this.ipv6ConfigChanged = false;
    }

    public IIpAddr getIpAddr() {
        return this.ipAddr;
    }

    public IIpAddr getDefaultRouterAddr() {
        return this.defaultRouter;
    }

    public short getNetmaskPrefixLength() {
        return this.netmask;
    }

    public IIpAddr getIpAddrV6() {
        return this.ipv6Addr;
    }

    public IIpAddr getV6DefaultRouterAddr() {
        return this.defaultRouterV6;
    }

    public short getIpv6PrefixLength() {
        return this.prefixLength;
    }

    public boolean getCtcIpSuppressed() {
        return this.ctcIpDisplaySuppressed;
    }

    public boolean isNodeInIPv6Mode() {
        return this.ipv6Mode;
    }

    public int getLcdIpSetting() {
        return this.lcdIpSetting;
    }

    public boolean mustReboot() {
        return this.mustReboot;
    }

    public boolean isDefRouterChanged() {
        return this.defRouterChanged;
    }

    public boolean isIpv6ConfigChanged() {
        return this.ipv6ConfigChanged;
    }

    public boolean validatePanel() {
        if (!this.netmaskEdit.onValidate()) {
            this.netmaskEdit.requestEditorFocus();
            return false;
        }
        if (!this.validateIPv6Config()) {
            return false;
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.parent.getUiModel().getNodeModel();
        if (nodeModelDelegate.allowIpDisplayed(this.isNodeIP)) {
            this.ipAddr = InetUtil.makeIpAddr(this.ipAddrTF.getText());
        }
        if (!nodeModelDelegate.isSecureMode() || !this.isNodeIP) {
            this.defaultRouter = InetUtil.makeIpAddr(this.defRouterTF.getText());
        }
        if (this.ipv6Mode) {
            this.ipv6Addr = InetUtil.makeIpAddr(this.ipv6AddrTF.getText());
        } else {
            this.ipv6Addr = InetUtil.makeIpAddr("0::0");
            this.prefixLength = 0;
        }
        this.defaultRouterV6 = (!nodeModelDelegate.isSecureMode() || !this.isNodeIP) && this.ipv6Mode ? InetUtil.makeIpAddr(this.defRouterV6TF.getText()) : InetUtil.makeIpAddr("0::0");
        try {
            this.netmask = Short.valueOf((String)this.netmaskEdit.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            db.finer("NumberFormatException in onValidate() " + numberFormatException);
        }
        this.ctcIpDisplaySuppressed = this.userCtcIpDisplaySelection;
        if (this.lcdIpSettingCB != null) {
            this.lcdIpSetting = this.userLcdIpSetting;
        }
        return true;
    }

    private boolean validateIPv6Config() {
        boolean bl = true;
        if (this.isNodeInIPv6Mode()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.ipv6AddrTF.getText());
                InetAddress inetAddress2 = InetAddress.getByName(this.defRouterV6TF.getText());
                if (inetAddress.equals(InetAddress.getByName("0:0:0:0:0:0:0:0")) || inetAddress.getAddress().length != 16 || inetAddress.equals(InetAddress.getByName("0::1"))) {
                    throw new UnknownHostException();
                }
                if (!this.parent.getUiModel().getNodeModel().isSecureMode() && (inetAddress2.equals(InetAddress.getByName("0::1")) || inetAddress2.getAddress().length != 16)) {
                    throw new UnknownHostException();
                }
            }
            catch (UnknownHostException unknownHostException) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_IPV6_INVALID_ADDRESS);
                bl = false;
            }
            try {
                this.prefixLength = Short.valueOf(this.ipv6AddrPrefixTF.getText());
                if (this.prefixLength < 0 || this.prefixLength > 128) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_IPV6_INVALID_PREFIX_LENGTH);
                bl = false;
            }
        }
        return bl;
    }

    private void updateMaskLabel() {
        try {
            int n = Integer.parseInt((String)this.netmaskEdit.getValue());
            int n2 = InetUtil.makeNetMask(n);
            this.netmaskLB.setText(InetUtil.makeDottedString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            db.finer("NumberFormatException in updateMaskLabel() " + numberFormatException);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.parent.setDirty();
        Object object = propertyChangeEvent.getSource();
        if (object == this.netmaskEdit) {
            this.mustReboot = true;
            this.updateMaskLabel();
        }
    }

    private JTextField addTextPanel(JPanel jPanel, JLabel jLabel, int n, DocumentListener documentListener) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        if (jLabel != null) {
            jPanel2.add(jLabel);
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        if (this.parent.isUserAuthorized()) {
            jTextField.getDocument().addDocumentListener(this);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    private void generalChanges(DocumentEvent documentEvent) {
        this.parent.setDirty();
        if (documentEvent.getDocument() == this.ipv6AddrTF.getDocument() || documentEvent.getDocument() == this.ipv6AddrPrefixTF.getDocument() || documentEvent.getDocument() == this.defRouterV6TF.getDocument()) {
            this.ipv6ConfigChanged = true;
        } else if (documentEvent.getDocument() != this.defRouterTF.getDocument()) {
            this.mustReboot = true;
        } else {
            this.defRouterChanged = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.lcdIpSettingCB)) {
            this.userLcdIpSetting = ((Attribute)this.lcdIpSettingCB.getSelectedItem()).getIntValue();
            this.parent.setDirty();
        } else if (object.equals(this.ctcIpSuppressedCB)) {
            this.userCtcIpDisplaySelection = this.ctcIpSuppressedCB.isSelected();
            this.parent.setDirty();
        } else if (object.equals(this.enableIpv6)) {
            this.ipv6Mode = this.enableIpv6.isSelected();
            this.ipv6ConfigChanged = true;
            this.resetIPv6Paramters();
            this.parent.setDirty();
        }
    }

    public void resetIPv6Paramters() {
        this.ipv6AddrTF.setEnabled(this.ipv6Mode);
        this.enableIpv6.setSelected(this.ipv6Mode);
        this.defRouterV6TF.setEnabled(this.ipv6Mode);
        this.ipv6AddrPrefixTF.setEnabled(this.ipv6Mode);
        if (!this.ipv6Mode) {
            this.ipv6AddrTF.setText("");
            this.defRouterV6TF.setText("");
            this.ipv6AddrPrefixTF.setText("");
            this.ipv6Addr = InetUtil.makeIpAddr("0::0");
            this.defaultRouterV6 = InetUtil.makeIpAddr("0::0");
            this.prefixLength = 0;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    private static Attribute getLcdIpSettingAttr(int n) {
        return 0 <= n && n < LCD_IP_SETTING_ATTRS.length ? LCD_IP_SETTING_ATTRS[n] : LCD_IP_SETTING_ATTRS[0];
    }

    static {
        for (int i = 0; i < LCD_IP_SETTING_ATTRS.length; ++i) {
            IpAddrPanel.LCD_IP_SETTING_ATTRS[i] = new Attribute(LcdIpSetting.LCD_IP_SETTING[i], i);
        }
        db = new SDebug((KDebug)AbstractShelfProvPane.db, "IpAddrPanel");
    }
}

