/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.OchsPwrMonitoringChartModel;
import cerent.cms.ui.shelf.XAssisChartElements;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.BarChart;
import com.klg.jclass.chart.ChartDataModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;

public class MaintPwrMonitoringPane
extends AbstractPane
implements ActionListener,
ITabName {
    private static final String REFRESH = "Refresh";
    private JButton refreshButton = new JButton("Refresh");
    private JLabel refreshLabel = new JLabel("");
    private boolean isGUIInited = false;
    private boolean isModelInited = false;
    protected boolean isMultiShelf = ((NodeModelDelegate)this.getUiModel().getNodeModel()).isMultishelf();
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "MaintPwrMonitoringPane");
    private JPanel chartsPanel = null;
    public static final int DONTCARESIDE = 255;
    private JSplitPane splitPane;
    private BarChart[] chart = null;
    private OchsPwrMonitoringChartModel[] chartDataModel = null;
    private JPanel[] chartPane = null;
    ISideModel iSideModel;

    public MaintPwrMonitoringPane(String string, TabbedView tabbedView, ISideModel iSideModel) {
        this(string, tabbedView.getUiModel(), tabbedView);
        this.iSideModel = iSideModel;
        this.chartDataModel = new OchsPwrMonitoringChartModel[2];
        this.chartPane = new JPanel[2];
        this.chart = new BarChart[2];
        for (int i = 0; i < 2; ++i) {
            this.chartPane[i] = new JPanel(new BorderLayout());
        }
    }

    public MaintPwrMonitoringPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
    }

    private void initGUI() {
        if (db.on()) {
            db.println("initGUI()");
        }
        this.setLayout(new BorderLayout());
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.initButtonPanel();
        this.initChartsPanel();
        this.initCharts();
        this.isGUIInited = true;
    }

    protected void initButtonPanel() {
        if (db.on()) {
            db.println("initButtonPanel()");
        }
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintDwdmPwrMonitoring);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        cSHelpButtonPane.addLeft(this.refreshButton);
        cSHelpButtonPane.addRight(this.refreshLabel);
        this.add(cSHelpButtonPane, "South");
    }

    protected void adjustGUIforExcFeatNotSupport() {
        if (db.on()) {
            db.println("initButtonPanel()");
        }
        this.setLayout(new BorderLayout());
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.chartsPanel = new JPanel(new BorderLayout());
        this.chartsPanel.add("Center", new JLabel("Power equalization not available in the current configuration."));
        this.add(this.chartsPanel, "Center");
    }

    private JPanel adjustGUIForDataNotAvail() {
        if (db.on()) {
            db.println("initButtonPanel()");
        }
        this.chartsPanel = new JPanel(new BorderLayout());
        this.chartsPanel.add("Center", new JLabel("Power equalization not available in the current configuration."));
        return this.chartsPanel;
    }

    protected void initModel() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        for (int i = 0; i < 2; ++i) {
            this.chartDataModel[i] = new OchsPwrMonitoringChartModel(nodeModelDelegate.getOchsPwrMonitoringModel(), this.iSideModel, i);
            try {
                this.chartDataModel[i].init();
                continue;
            }
            catch (FeatureUnsupported featureUnsupported) {
                this.adjustGUIforExcFeatNotSupport();
                return;
            }
            catch (CTCUserException cTCUserException) {
                this.adjustGUIforExcFeatNotSupport();
                return;
            }
        }
        this.isModelInited = true;
        if (!this.isGUIInited) {
            this.initGUI();
        } else {
            this.initCharts();
        }
    }

    private void initChartsPanel() {
        if (db.on()) {
            db.println("initChartsPanel: create the GUI containers");
        }
        this.chartsPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(0, this.chartPane[0], this.chartPane[XAssisChartElements.SIDEOUT]);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.chartsPanel.add((Component)this.splitPane, "Center");
        this.add(this.chartsPanel, "Center");
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerLocation(0.5);
    }

    private void initCharts() {
        if (this.isModelInited) {
            if (db.on()) {
                db.println("initCharts: model inited, draw charts");
            }
            for (int i = 0; i < 2; ++i) {
                if (this.chartDataModel[i] == null) continue;
                this.chart[i] = this.setUpChart(this.chartDataModel[i]);
                if (this.chartDataModel[i].IsPortIdxEqualZero()) {
                    this.chartPane[i].add((Component)this.adjustGUIForDataNotAvail(), "Center");
                } else {
                    this.chartPane[i].add((Component)this.chart[i].getComponentObj(), "Center");
                }
                if (!db.on()) continue;
                db.println("initCharts: added SIDE" + i + " chart to pane");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    private BarChart setUpChart(OchsPwrMonitoringChartModel ochsPwrMonitoringChartModel) {
        StringBuilder stringBuilder = new StringBuilder();
        BarChart barChart = new BarChart(BarChart.BarStyle.STACKED, false);
        barChart.setDataSource((ChartDataModel)ochsPwrMonitoringChartModel);
        barChart.setYStepUnit(new Double(1.0), new Double(1.0));
        stringBuilder.append("Optical Side");
        stringBuilder.append(" ");
        stringBuilder.append(ochsPwrMonitoringChartModel.getSideStr());
        stringBuilder.append(": ");
        if (!ochsPwrMonitoringChartModel.IsPortIdxEqualZero()) {
            IEntityModel iEntityModel = ochsPwrMonitoringChartModel.getPortModel();
            if (this.isMultiShelf) {
                stringBuilder.append("shelf ");
                stringBuilder.append(iEntityModel.getShelfId());
                stringBuilder.append(" - ");
            }
            stringBuilder.append("slot ");
            stringBuilder.append(iEntityModel.getSlot());
            stringBuilder.append(" - ");
            stringBuilder.append("port ");
            stringBuilder.append(iEntityModel.getPositionInParent());
            try {
                stringBuilder.append(" (" + ((IOpticsPortModel)iEntityModel).getOptPortTypeString() + ")");
            }
            catch (NoSuchEquipment noSuchEquipment) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            catch (WrongPortType wrongPortType) {
                SDebug.printStackTrace((Throwable)wrongPortType);
            }
            barChart.setAutoLabel(true);
            barChart.setBarOverlap(100);
            barChart.setGridVisible(true);
            barChart.setYaxisTitle("dBm");
            barChart.setXaxisTitle("Channel ID");
            barChart.setOrigin(-25.0);
            barChart.setMin(-25.0);
            barChart.setHeader(stringBuilder.toString());
            Color color = new Color(187, 187, 240);
            barChart.setBackground(color);
            barChart.setLegendAnchor(7);
            barChart.setLegendOrientation(8);
            barChart.setLegendVisible(true);
            barChart.setAutoLabelTexts(" dBm", (Object[])ochsPwrMonitoringChartModel.getActivetLambdas());
        }
        return barChart;
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage()");
        }
        ToolTipManager.sharedInstance().setDismissDelay(2000);
        if (!this.isModelInited) {
            if (db.on()) {
                db.println("enteringPage: call initModel()");
            }
            this.initModel();
        } else {
            this.refreshModel();
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage()");
        }
        ToolTipManager.sharedInstance().setDismissDelay(4000);
    }

    @Override
    public void refresh() {
        if (db.on()) {
            db.println("refresh()");
        }
        try {
            if (!this.isModelInited) {
                if (db.on()) {
                    db.println("refresh: call initModel(), initCharts()");
                }
                this.initModel();
                this.initCharts();
                this.validate();
            } else {
                this.refreshModel();
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                KDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_PWR_MONIT);
        }
        this.refreshLabel.setText(this.getTimeStampString());
    }

    protected String getTimeStampString() {
        return "Refreshed: " + MaintPwrMonitoringPane.getFormattedDateTime();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (db.on()) {
            db.println("destroy()");
        }
        if (this.isModelInited) {
            if (db.on()) {
                db.println("destroy: disposing chart models");
            }
            this.chartDataModel = null;
        }
    }

    private void refreshModel() {
        for (int i = 0; i < 2; ++i) {
            this.chartPane[i].removeAll();
            this.chartDataModel[i] = null;
            this.chart[i] = null;
        }
        this.initModel();
        this.validate();
    }
}

