/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.ui.shelf.HexTextField;
import cerent.cms.ui.shelf.NsapPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MaskedEntryDialog
extends JDialog
implements ActionListener {
    public static final String TITLE = "Masked NSAP Entry";
    private HexTextField afiTF;
    private HexTextField idiTF;
    private HexTextField dfiTF;
    private HexTextField orgTF;
    private HexTextField reservedTF;
    private HexTextField rdTF;
    private HexTextField areaTF;
    private HexTextField systemTF;
    private int AFI_LEN = 2;
    private int IDI_LEN = 4;
    private int DFI_LEN = 2;
    private int ORG_LEN = 6;
    private int RESERVE_LEN = 4;
    private int RD_LEN = 4;
    private int AREA_LEN = 4;
    private int SYS_LEN = 12;
    JButton okButton;
    JButton cancelButton;
    NsapPanel parent;

    public MaskedEntryDialog(NsapPanel nsapPanel) {
        super(JOptionPane.getFrameForComponent(nsapPanel), TITLE, true);
        this.parent = nsapPanel;
        this.getContentPane().add((Component)this.getMaskPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(450, 140));
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(nsapPanel));
    }

    private JPanel getMaskPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel("AFI"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel("IDI"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("DFI"), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)new JLabel("ORG"), gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel("Rsvd"), gridBagConstraints);
        gridBagConstraints.gridx = 9;
        jPanel.add((Component)new JLabel("RD"), gridBagConstraints);
        gridBagConstraints.gridx = 11;
        jPanel.add((Component)new JLabel("Area"), gridBagConstraints);
        if (this.parent.type != 3) {
            gridBagConstraints.gridx = 13;
            gridBagConstraints.gridwidth = 6;
            jPanel.add((Component)new JLabel("System"), gridBagConstraints);
        }
        this.afiTF = new HexTextField(this.AFI_LEN);
        this.idiTF = new HexTextField(this.IDI_LEN);
        this.dfiTF = new HexTextField(this.DFI_LEN);
        this.orgTF = new HexTextField(this.ORG_LEN);
        this.reservedTF = new HexTextField(this.RESERVE_LEN);
        this.rdTF = new HexTextField(this.RD_LEN);
        this.areaTF = new HexTextField(this.AREA_LEN);
        this.systemTF = new HexTextField(this.SYS_LEN);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.afiTF, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.idiTF, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.dfiTF, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.orgTF, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.reservedTF, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        jPanel.add((Component)this.rdTF, gridBagConstraints);
        gridBagConstraints.gridx = 11;
        jPanel.add((Component)this.areaTF, gridBagConstraints);
        if (this.parent.type != 3) {
            gridBagConstraints.gridx = 13;
            gridBagConstraints.gridwidth = 6;
            jPanel.add((Component)this.systemTF, gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.constructNsap();
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected void populateFullAddr(String string) {
        block6: {
            block5: {
                block4: {
                    if (this.parent.type != 3) break block4;
                    if (string.length() == 26) break block5;
                }
                if (this.parent.type == 3) break block6;
                if (string.length() != 38) break block6;
            }
            int n = 0;
            this.afiTF.setText(string.substring(n, this.AFI_LEN));
            this.idiTF.setText(string.substring(n += this.AFI_LEN, n + this.IDI_LEN));
            this.dfiTF.setText(string.substring(n += this.IDI_LEN, n + this.DFI_LEN));
            this.orgTF.setText(string.substring(n += this.DFI_LEN, n + this.ORG_LEN));
            this.reservedTF.setText(string.substring(n += this.ORG_LEN, n + this.RESERVE_LEN));
            this.rdTF.setText(string.substring(n += this.RESERVE_LEN, n + this.RD_LEN));
            this.areaTF.setText(string.substring(n += this.RD_LEN, n + this.AREA_LEN));
            n += this.AREA_LEN;
            if (this.parent.type != 3) {
                this.systemTF.setText(string.substring(n, n + this.SYS_LEN));
            }
        }
    }

    private void constructNsap() {
        String string = this.afiTF.getText() + this.idiTF.getText() + this.dfiTF.getText() + this.orgTF.getText() + this.reservedTF.getText() + this.rdTF.getText() + this.areaTF.getText();
        if (this.parent.type != 3) {
            string = string + this.systemTF.getText();
        }
        this.parent.setText(string);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

