/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TarpModel;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.MatAddDialog;
import cerent.cms.ui.shelf.NsapPanel;
import cerent.util.SDebug;
import cerent.util.gui.GridPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MatAttributePane
extends JPanel
implements IOsiConstants {
    protected MatAddDialog parent;
    protected TarpModel tarpModel;
    protected NodeModelDelegate nmd;
    private JComboBox levelCB;
    private NsapPanel nsapP;
    private static final SDebug db = new SDebug("MatAttributePane");

    protected MatAttributePane(MatAddDialog matAddDialog) {
        if (db.on()) {
            db.println("<init>: start");
        }
        this.parent = matAddDialog;
        this.nmd = ((IChassisModel)MatAddDialog.model).getNodeModelDelegate();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createAttributesPanel(), "Center");
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    protected JPanel createAttributesPanel() {
        this.levelCB = new JComboBox<Attribute>(this.getAttributeArray("O%S%I%MatLevel"));
        this.nsapP = new NsapPanel(0);
        GridPanel gridPanel = new GridPanel();
        gridPanel.addRow("Level", (JComponent)this.levelCB);
        gridPanel.addRow("NSAP", (JComponent)this.nsapP);
        return gridPanel;
    }

    public void onValidate() throws Exception {
        byte[] byArray = OsiHelper.getNsapBytes((String)this.nsapP.getText());
    }

    protected void setTarp(TarpModel tarpModel) {
        this.tarpModel = tarpModel;
    }

    public void applyChangesToModel() throws Exception {
        int n = ((Attribute)this.levelCB.getSelectedItem()).getValue();
        this.tarpModel.addMatEntry(n, OsiHelper.getNsapBytes((String)this.nsapP.getText()));
    }

    private Attribute[] getAttributeArray(String string) {
        return ElementDefaults.getAttributeMap(this.nmd).getAttributeArray(string);
    }

    private Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.nmd).getAttributeForVal(string, n);
    }
}

