/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.ui.shelf.AbstractMuxDmxCard;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticsPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;

public class MuxDmx32Card
extends AbstractMuxDmxCard {
    public static int NUM_SLOT_PER_ROW = 8;
    public static int Y_CONNECTORS_DISTANCE = 15;

    public MuxDmx32Card(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug, true);
    }

    @Override
    protected void addPortGraphics(EntityModel entityModel) {
        if (entityModel instanceof ModuleModel) {
            List list = entityModel.getChildren();
            this.numPorts = list.size();
            this.portGraphics = new OpticsPortGraphic[this.numPorts];
            int n = (this.cardPainter.getCardWidth() - 4) / 4;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.numPorts; ++i) {
                n3 = this.cardPainter.getMiniOpticonYOffset() + Y_CONNECTORS_DISTANCE * (i / NUM_SLOT_PER_ROW);
                n2 = 5 + n * (i % NUM_SLOT_PER_ROW);
                this.portGraphics[i] = new OpticsPortGraphic((CardGraphic)this, n2, n3, n, n, (OpticsPortModel)list.get(i));
            }
        }
    }

    protected int initWidth() {
        return this.cardPainter.getCardWidth() * this.getSlotsOccupied();
    }

    protected Dimension getSlotDim(int n) {
        return new Dimension(this.initWidth(), this.cardPainter.getCardHeight());
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.numPorts < 11) {
                    if (this.portGraphics[i] == null) continue;
                    this.portGraphics[i].drawOnlyOneConnector(graphics2D, false, false);
                    continue;
                }
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].drawOnlyOneConnector(graphics2D, false, true);
            }
        }
    }
}

