/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IOsiConstants;
import cerent.cms.ui.shelf.HexTextField;
import cerent.cms.ui.shelf.MaskedEntryDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class NsapPanel
extends JPanel
implements ActionListener,
IOsiConstants {
    HexTextField nsapTF;
    HexTextField nselTF;
    JButton useMaskJB;
    private static final String NULL_NSEL = "00";
    static final String CC = "CC";
    private static final String FF = "2F";
    private static final String TARP_NSEL = "AF";
    static final int FULL_MAA_LEN = 26;
    static final int FULL_NSAP_LEN = 38;
    int type;

    public NsapPanel(int n) {
        this.type = n;
        this.setLayout(new BorderLayout(4, 1));
        int n2 = n == 3 ? 26 : 38;
        this.nsapTF = new HexTextField(n2, ".");
        this.nselTF = new HexTextField(2);
        this.nselTF.setEnabled(false);
        if (n == 0) {
            this.nselTF.setText(TARP_NSEL);
        } else if (n != 2) {
            this.nselTF.setText(NULL_NSEL);
        }
        this.useMaskJB = new JButton("Use Mask...");
        this.useMaskJB.addActionListener(this);
        this.add((Component)this.nsapTF, "West");
        if (n != 3) {
            this.add((Component)this.nselTF, "Center");
        }
        this.add((Component)this.useMaskJB, "East");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.useMaskJB) {
            MaskedEntryDialog maskedEntryDialog = new MaskedEntryDialog(this);
            String string = this.nsapTF.getText().replaceAll("\\.", "");
            int n = string.length();
            if (this.type == 3 && n == 26 || this.type != 3 && n == 38) {
                maskedEntryDialog.populateFullAddr(string);
            }
            maskedEntryDialog.show();
        }
    }

    protected void setNsel2CSCO(boolean bl) {
        if (bl) {
            this.nselTF.setText(CC);
        } else {
            this.nselTF.setText(FF);
        }
    }

    protected void setText(String string) {
        this.nsapTF.setText(string);
    }

    public String getText() {
        String string = this.nsapTF.getText();
        if (this.type != 3) {
            string = string + this.nselTF.getText();
        }
        return string;
    }
}

