/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sTarpConfig;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OsiModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TarpModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OsiTarpConfigPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
IOsiConstants {
    JCheckBox l1propagationCB;
    JCheckBox l2propagationCB;
    JCheckBox originationCB;
    JCheckBox l1tdcCB;
    JCheckBox l2tdcCB;
    JCheckBox ldbCB;
    JCheckBox enhancedModeCB;
    JCheckBox type4PduCB;
    SpinPropertyEditor type4PduSpinner;
    SpinPropertyEditor ldbEntrySpinner;
    SpinPropertyEditor ldbFlushSpinner;
    SpinPropertyEditor t1Spinner;
    SpinPropertyEditor t2Spinner;
    SpinPropertyEditor t3Spinner;
    SpinPropertyEditor t4Spinner;
    private TarpModel tarpModel;
    private OsiModel osiModel;
    private short TYPE_4_DEFAULT = (short)60;
    private boolean l2Supported;

    public OsiTarpConfigPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.init();
    }

    private void helpPadGrid(JPanel jPanel) {
        jPanel.add(new JLabel(" "));
    }

    private void helpAddRow(JPanel jPanel, AbstractButton abstractButton) {
        abstractButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(abstractButton);
        jPanel.add(jPanel2);
    }

    private void helpAddRow(JPanel jPanel, String string, SpinPropertyEditor spinPropertyEditor, String string2) {
        spinPropertyEditor.addPropertyChangeListener(this);
        if (string != null) {
            jPanel.add(new JLabel(string));
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 0));
        jPanel2.add(spinPropertyEditor);
        jPanel2.add(new JLabel(string2));
        jPanel.add(jPanel2);
    }

    private void init() {
        JPanel jPanel = new JPanel();
        this.l2Supported = false;
        int[] nArray = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform().getOsiModes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 2) continue;
            this.l2Supported = true;
            break;
        }
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        this.l1propagationCB = new JCheckBox("TARP PDUs L1 Propagation");
        this.l1propagationCB.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, this.l1propagationCB);
        this.l2propagationCB = new JCheckBox("TARP PDUs L2 Propagation");
        this.l2propagationCB.setEnabled(this.isUserAuthorized());
        if (this.l2Supported) {
            this.helpAddRow(jPanel2, this.l2propagationCB);
        } else {
            this.helpPadGrid(jPanel2);
        }
        this.originationCB = new JCheckBox("TARP PDUs Origination");
        this.originationCB.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, this.originationCB);
        this.helpPadGrid(jPanel2);
        this.l1tdcCB = new JCheckBox("TARP Data Cache");
        this.l1tdcCB.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, this.l1tdcCB);
        this.l2tdcCB = new JCheckBox("L2 TARP Data Cache");
        this.l2tdcCB.setEnabled(this.isUserAuthorized());
        if (this.l2Supported) {
            this.helpAddRow(jPanel2, this.l2tdcCB);
        } else {
            this.helpPadGrid(jPanel2);
        }
        this.ldbCB = new JCheckBox("LDB");
        this.ldbCB.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, this.ldbCB);
        this.helpPadGrid(jPanel2);
        this.enhancedModeCB = new JCheckBox("LAN TARP Storm Supression");
        this.enhancedModeCB.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, this.enhancedModeCB);
        this.helpPadGrid(jPanel2);
        this.type4PduCB = new JCheckBox("Send Type 4 PDU on Startup");
        this.type4PduCB.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, this.type4PduCB);
        this.type4PduSpinner = new SpinPropertyEditor("Type 4 PDU Delay ", 1, 0, 255);
        this.type4PduSpinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.type4PduSpinner, "sec");
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(4, 2));
        this.ldbEntrySpinner = new SpinPropertyEditor("LDB Entry ", 1, 1, 10);
        this.ldbEntrySpinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.ldbEntrySpinner, "min");
        this.t1Spinner = new SpinPropertyEditor("T1 ", 1, 0, 3600);
        this.t1Spinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.t1Spinner, "sec");
        this.ldbFlushSpinner = new SpinPropertyEditor("LDB Flush ", 1, 0, 1440);
        this.ldbFlushSpinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.ldbFlushSpinner, "min");
        this.t2Spinner = new SpinPropertyEditor("T2 ", 1, 0, 3600);
        this.t2Spinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.t2Spinner, "sec");
        this.helpPadGrid(jPanel2);
        this.t3Spinner = new SpinPropertyEditor("T3 ", 1, 0, 3600);
        this.t3Spinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.t3Spinner, "sec");
        this.helpPadGrid(jPanel2);
        this.t4Spinner = new SpinPropertyEditor("T4 ", 1, 0, 3600);
        this.t4Spinner.setEnabled(this.isUserAuthorized());
        this.helpAddRow(jPanel2, null, this.t4Spinner, "sec");
        jPanel2.setBorder(BorderFactory.createTitledBorder("Timers"));
        jPanel.add(jPanel2);
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.type4PduCB)) {
            db.fine("handling type 4 PDU");
            short s = 0;
            if (this.type4PduCB.isSelected()) {
                s = this.TYPE_4_DEFAULT;
            }
            this.helpSetType4Pdu(s);
        }
        this.setDirty();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private void helpSetType4Pdu(short s) {
        boolean bl = true;
        if (s == 0) {
            bl = false;
        }
        this.type4PduCB.setSelected(bl);
        this.type4PduSpinner.setEnabled(this.isUserAuthorized() && bl);
        this.type4PduSpinner.setValue(new Short(s));
    }

    @Override
    public void refreshFromModel() throws Exception {
        sTarpConfig sTarpConfig2 = this.tarpModel.getTarpBody();
        this.l1propagationCB.setSelected((sTarpConfig2.tarpFu & 1) != 0);
        this.l1propagationCB.setEnabled(this.isUserAuthorized() && this.osiModel.getRoutingMode() != 0);
        this.l2propagationCB.setEnabled(this.isUserAuthorized() && this.osiModel.getRoutingMode() == 2);
        this.originationCB.setSelected((sTarpConfig2.tarpFu & 4) != 0);
        this.l1tdcCB.setSelected((sTarpConfig2.tarpFu & 8) != 0);
        if (this.l2Supported) {
            this.l2tdcCB.setSelected((sTarpConfig2.tarpFu & 0x10) != 0);
            this.l2propagationCB.setSelected((sTarpConfig2.tarpFu & 2) != 0);
        }
        this.ldbCB.setSelected((sTarpConfig2.tarpFu & 0x20) != 0);
        this.enhancedModeCB.setEnabled(this.isUserAuthorized() && this.osiModel.getRoutingMode() != 0);
        this.enhancedModeCB.setSelected((sTarpConfig2.tarpFu & 0x100) != 0);
        this.helpSetType4Pdu(sTarpConfig2.type4PduOnStartup);
        this.ldbEntrySpinner.setValue(new Short(sTarpConfig2.ldbEntryTimer));
        this.ldbEntrySpinner.setValue(new Short(sTarpConfig2.ldbEntryTimer));
        this.ldbFlushSpinner.setValue(new Short(sTarpConfig2.ldbFlushTimer));
        this.t1Spinner.setValue(new Short(sTarpConfig2.timers[0]));
        this.t2Spinner.setValue(new Short(sTarpConfig2.timers[1]));
        this.t3Spinner.setValue(new Short(sTarpConfig2.timers[2]));
        this.t4Spinner.setValue(new Short(sTarpConfig2.timers[3]));
        this.l2tdcCB.setEnabled(this.isUserAuthorized() && this.osiModel.getRoutingMode() == 2);
    }

    private short spinnerToShort(SpinPropertyEditor spinPropertyEditor) {
        String string = spinPropertyEditor.getValue().toString();
        short s = new Short(string);
        return s;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        sTarpConfig sTarpConfig2 = this.tarpModel.getTarpBody();
        short s = this.tarpModel.boolToFU(this.l1propagationCB.isSelected(), this.l2propagationCB.isSelected(), this.originationCB.isSelected(), this.l1tdcCB.isSelected(), this.l2tdcCB.isSelected(), this.ldbCB.isSelected(), true, true, this.enhancedModeCB.isSelected());
        if (s != sTarpConfig2.tarpFu) {
            this.tarpModel.setTarpFU(s);
        }
        short s2 = 0;
        s2 = this.spinnerToShort(this.type4PduSpinner);
        if (s2 != sTarpConfig2.type4PduOnStartup) {
            this.tarpModel.setType4PDU(s2);
        }
        if ((s2 = this.spinnerToShort(this.ldbEntrySpinner)) != sTarpConfig2.ldbEntryTimer) {
            this.tarpModel.setLDBEntryTimer(s2);
        }
        if ((s2 = this.spinnerToShort(this.ldbFlushSpinner)) != sTarpConfig2.ldbFlushTimer) {
            this.tarpModel.setLDBFlushTimer(s2);
        }
        if ((s2 = this.spinnerToShort(this.t1Spinner)) != sTarpConfig2.timers[0]) {
            this.tarpModel.setT1Timer(s2);
        }
        if ((s2 = this.spinnerToShort(this.t2Spinner)) != sTarpConfig2.timers[1]) {
            this.tarpModel.setT2Timer(s2);
        }
        if ((s2 = this.spinnerToShort(this.t3Spinner)) != sTarpConfig2.timers[2]) {
            this.tarpModel.setT3Timer(s2);
        }
        if ((s2 = this.spinnerToShort(this.t4Spinner)) != sTarpConfig2.timers[3]) {
            this.tarpModel.setT4Timer(s2);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.tarpModel = nodeModelDelegate.getTarpModel();
        this.osiModel = nodeModelDelegate.getOsiModel();
        if (this.tarpModel != null) {
            this.tarpModel.addObserver((Observer)((Object)this));
        }
        if (this.osiModel != null) {
            this.osiModel.addObserver((Observer)((Object)this));
        }
        super.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.tarpModel != null) {
            this.tarpModel.deleteObserver((Observer)((Object)this));
        }
        if (this.osiModel != null) {
            this.osiModel.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        if (this.tarpModel != null) {
            this.tarpModel.deleteObserver((Observer)((Object)this));
            this.tarpModel = null;
        }
        if (this.osiModel != null) {
            this.osiModel.deleteObserver((Observer)((Object)this));
            this.osiModel = null;
        }
        super.destroy();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OsiTarpConfigPane;
    }
}

