/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.idl.SonetTopology.sOnePlusOneProvision;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.model.Busy;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.EleNodeShelfModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoMoreVtCapableSts;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.shelf.PgAttrsPane;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import org.omg.CORBA.BAD_PARAM;

public class PgCreatePane
extends PgAttrsPane {
    boolean failedApply = false;
    private static final SDebug db = new SDebug("PgCreatePane");

    public PgCreatePane(EleNodeShelfModel eleNodeShelfModel) {
        super("CreatePane", eleNodeShelfModel, null);
    }

    boolean failedApply() {
        return this.failedApply;
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        IRevertiveBehavior iRevertiveBehavior = this.protType == 3 ? new RevertiveBehavior(1, ((RevertiveBehaviorPanel.ReversionTime)this.reversionTimer.getSelectedItem()).getTime()) : this.rbPanel.getRevertiveBehavior();
        sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
        StringBuilder stringBuilder = new StringBuilder("The protection group could not be created.");
        try {
            this.failedApply = true;
            switch (this.protType) {
                case 0: 
                case 1: {
                    this.doProvPgModel(sRevertiveBehavior2);
                    this.failedApply = false;
                    break;
                }
                case 2: 
                case 3: {
                    this.doCreate1Plus1(sRevertiveBehavior2, this.protType == 3);
                    this.failedApply = false;
                    break;
                }
                case 4: {
                    this.doCreateYCable(sRevertiveBehavior2);
                    this.failedApply = false;
                    break;
                }
                case 5: {
                    this.doCreateSplitter(sRevertiveBehavior2);
                    this.failedApply = false;
                    break;
                }
                case 6: {
                    this.doCreateL21Plus1(sRevertiveBehavior2);
                    this.failedApply = false;
                    break;
                }
                default: {
                    db.println("ERROR: Update switch statement in PgCreatePane.java");
                    break;
                }
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            stringBuilder.append("\nThe parameter was invalid. Please try again.\n");
            throw new AnnotatedException(stringBuilder.toString(), (Exception)((Object)bAD_PARAM));
        }
        catch (ProvisionError provisionError) {
            switch (this.protType) {
                case 4: {
                    stringBuilder.append("\nYou cannot provision Y-cable protection when:\n");
                    stringBuilder.append("1) The client port and the corresponding trunk port are not provisioned.\n");
                    stringBuilder.append("2) The client ports do not have the same payload data type and termination mode.\n");
                    stringBuilder.append("3) The client do not have not ALS disabled.\n");
                    if (this.protectEntity.getModuleModel().getEqType() == 271 || this.protectEntity.getModuleModel().getEqType() == 272) {
                        stringBuilder.append("4) (GE_XP and 10GE_XP cards only) The card mode is \"L2 over DWDM\".\n");
                        stringBuilder.append("5) (GE_XP cards only) Another Y-cable is already provisioned in the same \"half capacity\" with different port roles.\n");
                        stringBuilder.append("6) (GE_XP cards only) The client port mode is \"Auto\"");
                        break;
                    }
                    stringBuilder.append("4) (TXP cards only) The card is part of a regeneration group.\n");
                    stringBuilder.append("5) (MXP_2.5_10G and MXP-2.5_10E cards only) ITU-T G.709 OTN is disabed on the card.\n");
                    stringBuilder.append("6) (MXP_MR_2.5G and MXP_MR_10DME cards only) The cards do not have the same card mode.\n");
                    stringBuilder.append("7) (MXP_MR_2.5G and MXP_MR_10DME cards only) The cards do not have the same distance extension mode.\n");
                    stringBuilder.append("8) (MXP_MR_10DME card only) Fast switch attribute on active and protect ports must be same.\n");
                    stringBuilder.append("9) (40G MXP cards only) The 10GE client port has WIS as mapping mode.\n");
                    stringBuilder.append("10) (40G MXP cards only) The selected ports have different FEC setting.\n");
                    break;
                }
                case 2: {
                    if (this.protectEntity.getModuleModel().getEqType() == 273) {
                        stringBuilder.append("\nCheck to see if the ADM-10G card group peer has been set.\n");
                        break;
                    }
                }
                case 5: {
                    if (this.protectEntity.getModuleModel().getEqType() != 293) break;
                    stringBuilder.append("\nInvalid configuration for splitter protection\n");
                    stringBuilder.append("\nYou cannot provision Splitter protection group when:\n");
                    stringBuilder.append("1)The trunk ports or PPM types are not compatible \n");
                    stringBuilder.append("2)The client/trunk ports are a part of any protection group.\n");
                    stringBuilder.append("3)The trunk ports do not have the same payload type.\n");
                    stringBuilder.append("4)The trunk ports are not in the OOS state.\n");
                    stringBuilder.append("5)The trunk ports are a part of a regeneration group.\n");
                    stringBuilder.append("6)The trunk ports have overhead connections.\n");
                    stringBuilder.append("7)The protect port has an orderwire facilty\n.");
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    TDMTerminology tDMTerminology = this.scopeModel.getTDMTerminology();
                    String string = tDMTerminology.getRingTerms(0);
                    stringBuilder.append("\nCheck to see if the ports are supporting " + string + " circuits.\n");
                }
            }
            throw new AnnotatedException(stringBuilder.toString(), (Exception)((Object)provisionError));
        }
        catch (Busy busy) {
            Boolean bl = busy.usedAsClockSource();
            TDMTerminology tDMTerminology = this.scopeModel.getTDMTerminology();
            String string = tDMTerminology.getGeneralTerms(4);
            String string2 = tDMTerminology.getGeneralTerms(8);
            if (bl != null && bl.booleanValue()) {
                stringBuilder.append("\nCheck to see if any timing reference is used");
                stringBuilder.append("\non the same card where the protect port resides.\n");
            } else {
                stringBuilder.append("\nCheck to see if the protect port is supporting ");
                stringBuilder.append("circuits,\na timing reference, " + string + " " + string2 + ", orderwire, or a test access point.\n");
            }
            throw new AnnotatedException(stringBuilder.toString(), (Exception)((Object)busy));
        }
        catch (NoMoreVtCapableSts noMoreVtCapableSts) {
            stringBuilder.append("\nThe working port supports VT circuits,");
            stringBuilder.append("\nbut the VT cross-connect has no more capacity");
            stringBuilder.append("\nto add the protect port.\n");
            throw new AnnotatedException(stringBuilder.toString(), (Exception)((Object)noMoreVtCapableSts));
        }
        catch (DropsExceedMax dropsExceedMax) {
            stringBuilder.append("\nThe number of allowed drops will be exceeded.\n");
            throw new AnnotatedException(stringBuilder.toString(), (Exception)((Object)dropsExceedMax));
        }
    }

    private void doProvPgModel(sRevertiveBehavior sRevertiveBehavior2) throws AnnotatedException {
        Object[] objectArray = new ModuleModel[this.mainListModel.getSize()];
        this.mainListModel.copyInto(objectArray);
        StringBuffer stringBuffer = new StringBuffer("The protection group could not be created.");
        try {
            this.scopeModel.getEntityTableModel().provisionProtectionGroupModel(this.nameTF.getText(), this.getProtectionType(), sRevertiveBehavior2.reversionMode, sRevertiveBehavior2.reversionTime, (ModuleModel)this.protectCB.getSelectedItem(), (IModuleModel[])objectArray);
        }
        catch (ProvisionError provisionError) {
            stringBuffer.append("\nA provisioning error occurred. Please try again.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)provisionError));
        }
        catch (ResourceInUse resourceInUse) {
            stringBuffer.append("\nCheck to see if the protect card is supporting circuits or a test access point.\n");
            throw new AnnotatedException(stringBuffer.toString(), (Exception)((Object)resourceInUse));
        }
    }

    private void doCreate1Plus1(sRevertiveBehavior sRevertiveBehavior2, boolean bl) throws Busy, ProvisionError, NoMoreVtCapableSts, DropsExceedMax {
        eDetectionGuardTimer eDetectionGuardTimer2;
        eRecoveryGuardTimer eRecoveryGuardTimer2;
        eVerifyGuardTimer eVerifyGuardTimer2;
        boolean bl2;
        eOnePlusOneType eOnePlusOneType2;
        EntityModel entityModel = (EntityModel)this.mainList.getModel().getElementAt(0);
        EntityModel entityModel2 = (EntityModel)this.protectCB.getSelectedItem();
        if (bl) {
            eOnePlusOneType2 = eOnePlusOneType.ONEPLUSONE_OPTIMIZED;
            bl2 = true;
            eVerifyGuardTimer2 = eVerifyGuardTimer.from_int(this.vgTimer.getSelectedIndex());
            eRecoveryGuardTimer2 = eRecoveryGuardTimer.from_int(this.rgTimer.getSelectedIndex());
            eDetectionGuardTimer2 = eDetectionGuardTimer.from_int(this.dgTimer.getSelectedIndex());
        } else {
            eOnePlusOneType2 = eOnePlusOneType.ONEPLUSONE_STANDARD;
            bl2 = this.bidirCB.isSelected();
            eVerifyGuardTimer2 = eVerifyGuardTimer.from_int(0);
            eRecoveryGuardTimer2 = eRecoveryGuardTimer.from_int(0);
            eDetectionGuardTimer2 = eDetectionGuardTimer.from_int(0);
        }
        this.scopeModel.getElementModels().createOnePlusOne(new sOnePlusOneProvision(entityModel.getEntityIndex(), entityModel2.getEntityIndex(), sRevertiveBehavior2, bl2, eOnePlusOneType2, eVerifyGuardTimer2, eRecoveryGuardTimer2, eDetectionGuardTimer2), this.nameTF.getText());
    }

    private void doCreateYCable(sRevertiveBehavior sRevertiveBehavior2) throws Busy, NoMoreVtCapableSts, ProvisionError, DropsExceedMax {
        EntityModel entityModel = (EntityModel)this.mainList.getModel().getElementAt(0);
        EntityModel entityModel2 = (EntityModel)this.protectCB.getSelectedItem();
        this.scopeModel.getElementModels().createYCable(new sYCableProvision(entityModel.getEntityIndex(), entityModel2.getEntityIndex(), sRevertiveBehavior2, this.bidirCB.isSelected()), this.nameTF.getText());
    }

    private void doCreateSplitter(sRevertiveBehavior sRevertiveBehavior2) throws ProvisionError {
        EntityModel entityModel = (EntityModel)this.mainList.getModel().getElementAt(0);
        EntityModel entityModel2 = (EntityModel)this.protectCB.getSelectedItem();
        this.scopeModel.getElementModels().createSplitter(new sYCableProvision(entityModel.getEntityIndex(), entityModel2.getEntityIndex(), sRevertiveBehavior2, this.bidirCB.isSelected()), this.nameTF.getText());
    }

    private void doCreateL21Plus1(sRevertiveBehavior sRevertiveBehavior2) throws Busy, ProvisionError {
        EntityModel entityModel = (EntityModel)this.mainList.getModel().getElementAt(0);
        EntityModel entityModel2 = (EntityModel)this.protectCB.getSelectedItem();
        this.scopeModel.getElementModels().createOnePlusOneL2(new sYCableProvision(entityModel.getEntityIndex(), entityModel2.getEntityIndex(), sRevertiveBehavior2, this.bidirCB.isSelected()), this.nameTF.getText());
    }
}

