/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.shelf.PgEditPane;
import cerent.cms.ui.shelf.SppProtectionPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PgEditDialog
extends JDialog
implements ActionListener {
    private SDebug db;
    public static final String TITLE = "Edit Protection Group";
    private JButton okButton;
    private JButton cancelButton;
    private PgEditPane editPane;

    public PgEditDialog(SppProtectionPane sppProtectionPane, NodeModelDelegate nodeModelDelegate, Model model, SDebug sDebug) {
        super(JOptionPane.getFrameForComponent((Component)((Object)sppProtectionPane)), TITLE, true);
        this.db = sDebug;
        this.editPane = new PgEditPane(sppProtectionPane);
        try {
            this.editPane.setModel(model);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.getContentPane().add((Component)((Object)this.editPane), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(575, 350));
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent((Component)((Object)sppProtectionPane)));
    }

    @Override
    public void dispose() {
        this.editPane.dispose();
        this.editPane = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.editPane.isProvPaneDirty()) {
                    this.editPane.validateFields();
                    this.editPane.apply();
                }
                this.dispose();
            }
            catch (Exception exception) {
                if (exception.getMessage() != "Cancelled by user") {
                    if (this.db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayDetailed((Component)this, EMC.EID_FAIL_PROT_GROUP_EDIT, exception.getMessage());
                }
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(CSHelpConst.PgEditDialog));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

