/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DuplicateRadiusServerException;
import cerent.cms.model.EmptyAaaServerListException;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.MaxRadiusServersExceededException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RadiusServer;
import cerent.cms.model.RadiusServerModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.RadiusServerMaintDialog;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class RadiusServerInfoPane
extends AbstractShelfEditTablePane
implements ActionListener {
    private static final String UP = "Move Up";
    private static final String DOWN = "Move Down";
    private JButton upButton;
    private JButton downButton;
    private ObservableManager observableManager = null;
    private RadiusServerModel radiusServerModel = null;
    private NodeModelDelegate nodeModel;
    private static final SDebug db = new SDebug("RadiusServerInfoPane");

    public RadiusServerInfoPane(String string, TabbedView tabbedView, NodeModelDelegate nodeModelDelegate) {
        super(string, tabbedView);
        this.ENTRY_TYPE = "Radius Server";
        this.nodeModel = nodeModelDelegate;
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    @Override
    protected void initModels() {
        this.model = new RadiusServerInfoTableModel();
    }

    @Override
    protected void localInit() {
        super.localInit();
        this.customizedColumns();
    }

    private void customizedColumns() {
        if (this.table != null) {
            TableColumn tableColumn = null;
            tableColumn = this.table.getColumn(this.model.getColumnName(0));
            if (tableColumn != null) {
                tableColumn.setPreferredWidth(120);
            }
            if ((tableColumn = this.table.getColumn(this.model.getColumnName(1))) != null) {
                tableColumn.setPreferredWidth(120);
            }
            if ((tableColumn = this.table.getColumn(this.model.getColumnName(2))) != null) {
                tableColumn.setPreferredWidth(120);
            }
            if ((tableColumn = this.table.getColumn(this.model.getColumnName(3))) != null) {
                tableColumn.setPreferredWidth(120);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        block6: {
            try {
                RadiusServer[] radiusServerArray = this.radiusServerModel.getRadiusServerList();
                List list = this.tableData;
                synchronized (list) {
                    for (int i = 0; i < radiusServerArray.length; ++i) {
                        this.tableData.add(radiusServerArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    protected void registerWithModels() {
        this.radiusServerModel = this.nodeModel.getRadiusServerModel();
        if (this.radiusServerModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.radiusServerModel));
        } else {
            db.println("could not register model; radiusServerModel is null");
        }
    }

    @Override
    public void destroy() {
        if (this.radiusServerModel != null) {
            this.radiusServerModel.deleteObserver((Observer)((Object)this));
        }
        super.destroy();
    }

    @Override
    protected void createTableEntry() {
        block6: {
            RadiusServerMaintDialog radiusServerMaintDialog = new RadiusServerMaintDialog(this, this.radiusServerModel);
            if (radiusServerMaintDialog.isOk()) {
                try {
                    this.radiusServerModel.appendToRadiusServerList(radiusServerMaintDialog.getRadiusServer());
                }
                catch (MaxRadiusServersExceededException maxRadiusServersExceededException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RADIUS_SERVER_LIMIT_REACHED);
                }
                catch (DuplicateRadiusServerException duplicateRadiusServerException) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_RADIUS_SERVER);
                }
                catch (ConfigError configError) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GENERIC_PROV_ERROR);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!(exception instanceof CmsNodeUpgradingException)) break block6;
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void editSelectedTableEntry(int n) {
        boolean bl = false;
        RadiusServer radiusServer = null;
        IIpAddr iIpAddr = null;
        int n2 = -1;
        int n3 = -1;
        Object object = this.tableData;
        synchronized (object) {
            if (n >= 0 && n < this.model.getRowCount()) {
                radiusServer = (RadiusServer)this.tableData.get(n);
                iIpAddr = radiusServer.getIpAddr();
                n2 = radiusServer.getAuthPort();
                n3 = radiusServer.getAcctPort();
            }
        }
        if (radiusServer != null && ((RadiusServerMaintDialog)(object = new RadiusServerMaintDialog(this, this.radiusServerModel, radiusServer))).isOk()) {
            RadiusServer radiusServer2 = ((RadiusServerMaintDialog)object).getRadiusServer();
            List list = this.tableData;
            synchronized (list) {
                RadiusServer[] radiusServerArray = this.tableData.toArray(new RadiusServer[0]);
                for (int i = 0; i < radiusServerArray.length; ++i) {
                    radiusServer = radiusServerArray[i];
                    if (radiusServer.getIpAddr() != iIpAddr || radiusServer.getAuthPort() != n2 || radiusServer.getAcctPort() != n3) continue;
                    radiusServerArray[i] = radiusServer2;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.setRadiusServerList(radiusServerArray);
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RADIUS_SERVER_EDIT_FAILS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEditDeleteEnabled(boolean bl) {
        super.setEditDeleteEnabled(bl);
        if (this.isUserAuthorized()) {
            List list = this.tableData;
            synchronized (list) {
                int n = this.table.getSelectedRow();
                if (n == 0) {
                    WindowHelper.setEnabled((JComponent)this.upButton, (boolean)false);
                } else {
                    WindowHelper.setEnabled((JComponent)this.upButton, (boolean)bl);
                }
                if (n == this.model.getRowCount() - 1) {
                    WindowHelper.setEnabled((JComponent)this.downButton, (boolean)false);
                } else {
                    WindowHelper.setEnabled((JComponent)this.downButton, (boolean)bl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUp() {
        List list = this.tableData;
        synchronized (list) {
            int n = this.table.getSelectedRow();
            if (n == 0) {
                return;
            }
            if (n >= 0 && n < this.model.getRowCount()) {
                RadiusServer[] radiusServerArray = this.tableData.toArray(new RadiusServer[0]);
                RadiusServer radiusServer = (RadiusServer)this.tableData.get(n);
                for (int i = 0; i < radiusServerArray.length; ++i) {
                    if (radiusServerArray[i] != radiusServer) continue;
                    RadiusServer radiusServer2 = radiusServerArray[i - 1];
                    radiusServerArray[i - 1] = radiusServerArray[i];
                    radiusServerArray[i] = radiusServer2;
                    break;
                }
                this.setRadiusServerList(radiusServerArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDown() {
        List list = this.tableData;
        synchronized (list) {
            int n = this.table.getSelectedRow();
            if (n == this.model.getRowCount() - 1) {
                return;
            }
            if (n >= 0 && n < this.model.getRowCount()) {
                RadiusServer[] radiusServerArray = this.tableData.toArray(new RadiusServer[0]);
                RadiusServer radiusServer = (RadiusServer)this.tableData.get(n);
                for (int i = 0; i < radiusServerArray.length; ++i) {
                    if (radiusServerArray[i] != radiusServer) continue;
                    RadiusServer radiusServer2 = radiusServerArray[i + 1];
                    radiusServerArray[i + 1] = radiusServerArray[i];
                    radiusServerArray[i] = radiusServer2;
                    break;
                }
                this.setRadiusServerList(radiusServerArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteSelectedTableEntry(int n) {
        this.setEditDeleteEnabled(false);
        boolean bl = this.model.getRowCount() == 1 && this.radiusServerModel.getAAAServerAuthentication();
        String string = "Do you really want to delete this RADIUS server entry?";
        if (bl) {
            string = string + "\nDeleting the last RADIUS server entry will also disable RADIUS authentication.\n";
        }
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Confirmation")) {
            RadiusServer radiusServer = null;
            List list = this.tableData;
            synchronized (list) {
                if (n >= 0 && n < this.model.getRowCount()) {
                    radiusServer = (RadiusServer)this.tableData.get(n);
                }
            }
            if (this.radiusServerModel != null && radiusServer != null) {
                list = this.tableData;
                synchronized (list) {
                    ArrayList<RadiusServer> arrayList = new ArrayList<RadiusServer>();
                    for (RadiusServer radiusServer2 : this.tableData) {
                        if (radiusServer2 == radiusServer) continue;
                        arrayList.add(radiusServer2);
                    }
                    if (bl) {
                        try {
                            if (this.radiusServerModel.getAAAServerAccounting()) {
                                this.radiusServerModel.setAAAServerAccounting(false);
                            }
                            if (this.radiusServerModel.getUseLocalDatabase()) {
                                this.radiusServerModel.setUseLocalDatabase(false);
                            }
                            this.radiusServerModel.setAAAServerAuthentication(false);
                        }
                        catch (Exception exception) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    this.setRadiusServerList(arrayList.toArray(new RadiusServer[0]));
                }
            }
        }
    }

    private void setRadiusServerList(RadiusServer[] radiusServerArray) {
        block6: {
            try {
                this.radiusServerModel.setRadiusServerList(radiusServerArray);
            }
            catch (MaxRadiusServersExceededException maxRadiusServersExceededException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RADIUS_SERVER_LIMIT_REACHED);
            }
            catch (DuplicateRadiusServerException duplicateRadiusServerException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_RADIUS_SERVER);
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GENERIC_PROV_ERROR);
            }
            catch (EmptyAaaServerListException emptyAaaServerListException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RADIUS_SERVER_CANT_BE_EMPTY);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                if (!(exception instanceof CmsNodeUpgradingException)) break block6;
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
            }
        }
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    @Override
    protected JPanel getButtonBar() {
        JPanel jPanel = super.getButtonBar();
        if (jPanel instanceof CSHelpButtonPane) {
            CSHelpButtonPane cSHelpButtonPane = (CSHelpButtonPane)jPanel;
            this.upButton = new JButton(UP);
            this.downButton = new JButton(DOWN);
            if (this.isUserAuthorized()) {
                this.upButton.addActionListener(this);
                this.downButton.addActionListener(this);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
            cSHelpButtonPane.addLeft(this.upButton);
            cSHelpButtonPane.addLeft(this.downButton);
        }
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.upButton) {
            this.moveUp();
        } else if (object == this.downButton) {
            this.moveDown();
        }
        super.actionPerformed(actionEvent);
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            RadiusServerInfoPane.this.resetObservableManager();
            RadiusServerInfoPane.this.registerWithModels();
            RadiusServerInfoPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            RadiusServerInfoPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)RadiusServerInfoPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class RadiusServerInfoTableModel
    extends AbstractTableModel {
        public static final int IP_ADDRESS_INDEX = 0;
        public static final int SHARED_SECRET_INDEX = 1;
        public static final int AUTHENTICATION_PORT_INDEX = 2;
        public static final int ACCOUNTING_PORT_INDEX = 3;
        private RadiusServerInfoPane parent;
        private String[] columnNames = new String[]{"Node Address", "Shared Secret", "Authentication Port", "Accounting Port"};

        RadiusServerInfoTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n >= 0 && n < this.columnNames.length) {
                return this.columnNames[n];
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return RadiusServerInfoPane.this.tableData.size();
        }

        public Class getColumnClass(int n) {
            if (n == 2 || n == 3) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            block9: {
                if (n < RadiusServerInfoPane.this.tableData.size()) {
                    RadiusServer radiusServer = (RadiusServer)RadiusServerInfoPane.this.tableData.get(n);
                    try {
                        switch (n2) {
                            case 0: {
                                return InetUtil.makeDottedString(radiusServer.getIpAddr());
                            }
                            case 1: {
                                return new String(radiusServer.getSecret());
                            }
                            case 2: {
                                return new Integer(radiusServer.getAuthPort());
                            }
                            case 3: {
                                return new Integer(radiusServer.getAcctPort());
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block9;
                        db.println("Error in getValueAt " + exception);
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                        return exception.toString();
                    }
                }
            }
            return "";
        }
    }
}

