/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.NoPrivilegePane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SppDisclaimerPane;
import cerent.cms.ui.shelf.SppRadiusServerPane;
import cerent.cms.ui.shelf.SppSecurityAccessPane;
import cerent.cms.ui.shelf.SppSecurityConfigPane;
import cerent.cms.ui.shelf.SppSecurityPolicyPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;

public class SecurityPane
extends AbstractPane {
    private static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "SecurityPane");
    private final int USER_TAB = 0;
    private final int ACTIVE_TAB = 1;
    private final int POLICY_TAB = 2;
    private final int MODE_TAB = 3;
    private TabbedView parentView = null;
    private NodeModelDelegate nodeModel = null;
    private SecurityModel secModel = null;
    boolean isSuperUser = this.isUserAuthorized(SecurityLevel.SUPERUSER);

    public SecurityPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.parentView = tabbedView;
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (this.nodeModel != null) {
            this.secModel = SecurityModel.getInstance(this.nodeModel);
            this.secModel.addObserver((Observer)((Object)this));
            this.nodeModel.addObserver((Observer)((Object)this));
        }
        this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
        this.subTabs.setTabPlacement(1);
        this.subTabs.add((Component)((Pane)this.uiToolkit.getGuestPane(6, this.subTabs)));
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            this.subTabs.add((Component)((Pane)this.uiToolkit.getGuestPane(7, this.subTabs)));
            this.subTabs.add((Component)((Object)new SppSecurityPolicyPane("Policy", this.subTabs)));
            if (this.nodeModel.supportsSecureMode()) {
                this.subTabs.add((Component)((Object)new SppSecurityConfigPane("Data Comm", this.subTabs)));
            }
        } else {
            this.subTabs.add((Component)((Object)new NoPrivilegePane("Active Logins", tabbedView)));
            this.subTabs.add((Component)((Object)new NoPrivilegePane("Policy", tabbedView)));
            if (this.nodeModel.supportsSecureMode()) {
                this.subTabs.add((Component)((Object)new NoPrivilegePane("Data Comm", tabbedView)));
            }
        }
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            this.subTabs.add((Component)((Object)new SppSecurityAccessPane("Access", this.subTabs)));
        } else {
            this.subTabs.add((Component)((Object)new NoPrivilegePane("Access", tabbedView)));
        }
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            this.subTabs.add((Component)((Object)new SppRadiusServerPane("RADIUS Server", this.subTabs)));
        } else {
            this.subTabs.add((Component)((Object)new NoPrivilegePane("RADIUS Server", tabbedView)));
        }
        this.subTabs.add((Component)((Object)new SppDisclaimerPane("Legal Disclaimer", this.subTabs, this.secModel)));
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    @Override
    public void update(Observable observable, Object object) {
        block13: {
            boolean bl;
            if (SecurityPane.db.on) {
                db.println("enter: update: from: " + observable.toString());
            }
            if (observable instanceof SecurityModel && object == ModelUpdateType.CHANGED && this.isSuperUser != (bl = this.isUserAuthorized(SecurityLevel.SUPERUSER))) {
                if (SecurityPane.db.on) {
                    db.println("refreshing UI");
                }
                this.isSuperUser = bl;
                if (bl) {
                    block12: {
                        this.subTabs.setComponentAt(1, (Component)((Pane)this.uiToolkit.getGuestPane(7, this.subTabs)));
                        try {
                            if (this.subTabs.getComponentAt(1).isShowing()) {
                                this.subTabs.setSelectedIndex(0);
                                this.subTabs.setSelectedIndex(1);
                            }
                        }
                        catch (Exception exception) {
                            if (!SecurityPane.db.on) break block12;
                            db.println("exception in update ACTIVE_TAB");
                        }
                    }
                    SppSecurityPolicyPane sppSecurityPolicyPane = new SppSecurityPolicyPane("Policy", this.subTabs);
                    try {
                        this.subTabs.setComponentAt(2, (Component)((Object)sppSecurityPolicyPane));
                        if (this.subTabs.getComponentAt(2).isShowing()) {
                            sppSecurityPolicyPane.enteringPage();
                            sppSecurityPolicyPane.validate();
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        if (SecurityPane.db.on) {
                            db.println("exception in update POLICY_TAB");
                        }
                        break block13;
                    }
                }
                this.subTabs.setComponentAt(1, (Component)((Object)new NoPrivilegePane("Active Logins", this.parentView)));
                this.subTabs.setComponentAt(2, (Component)((Object)new NoPrivilegePane("Policy", this.parentView)));
                this.subTabs.setComponentAt(3, (Component)((Object)new NoPrivilegePane("Data Comm", this.parentView)));
            }
        }
        if (SecurityPane.db.on) {
            db.println("update: exit");
        }
    }

    @Override
    public void dispose() {
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
            this.secModel = null;
        }
        if (this.nodeModel != null) {
            this.nodeModel.deleteObserver((Observer)((Object)this));
            this.nodeModel = null;
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
            this.secModel = null;
        }
        if (this.nodeModel != null) {
            this.nodeModel.deleteObserver((Observer)((Object)this));
            this.nodeModel = null;
        }
        this.parentView = null;
        super.destroy();
    }

    @Override
    public void refresh() {
    }

    @Override
    public void enteringPage() {
    }

    @Override
    public void leavingPage() {
    }
}

