/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.AdminState;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgPortModel;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.cms.ui.shelf.ShelfInventoryRowObject;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

class ShelfInventoryPortRowObject {
    final MfgPortModel entity;
    final String eqType;
    final sMfgData_2_01 mfgData;
    final TDMTerminology terms;
    AdminState adminState;
    IServiceState serviceState;
    String location;
    protected boolean[] isDirty;
    private static final SDebug db = new SDebug((KDebug)ShelfInventoryPane.db, "ShelfInventoryPortRowObject");
    public static final int USER_CODE_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    private static final int NUM_DIRTY_FIELDS = 2;

    public ShelfInventoryPortRowObject(MfgPortModel mfgPortModel) {
        if (db.on()) {
            db.println("<init>");
        }
        this.entity = mfgPortModel;
        INodeModel iNodeModel = mfgPortModel.getNodeModel();
        this.location = mfgPortModel.getLocation();
        this.eqType = mfgPortModel.getEqTypeName();
        this.terms = iNodeModel.getTDMTerminology();
        this.mfgData = mfgPortModel.getMfgData();
        this.isDirty = new boolean[2];
        this.resetDirtyBits();
    }

    public void setDirty(int n, boolean bl) {
        if (n >= 0 && n < 2) {
            this.isDirty[n] = bl;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < 2; ++i) {
            if (!this.isDirty[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(int n) {
        return n >= 0 && n < 2 && this.isDirty[n];
    }

    public String getAdminStateString() {
        return "";
    }

    public String getServiceStateString() {
        return "";
    }

    public String getUserCode() {
        return this.mfgData.userCode;
    }

    public void setUserCode(String string) {
        if (!this.getUserCode().equals(string)) {
            this.mfgData.userCode = string;
            this.setDirty(0, true);
        }
    }

    private void resetDirtyBits() {
        for (int i = 0; i < 2; ++i) {
            this.isDirty[i] = false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShelfInventoryRowObject)) {
            return false;
        }
        ShelfInventoryPortRowObject shelfInventoryPortRowObject = (ShelfInventoryPortRowObject)object;
        return this.location.equals(shelfInventoryPortRowObject.location) && this.eqType.equals(shelfInventoryPortRowObject.eqType) && this.entity.equals(shelfInventoryPortRowObject.entity) && this.mfgData.equals(this.mfgData);
    }

    public String toString() {
        return this.entity != null ? this.entity.toString() : "null";
    }
}

