/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Alarm.xInvalidData;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AuditTrail;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.AuditStore;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.event.ARowSource;
import cerent.cms.ui.event.AuditPanel;
import cerent.cms.ui.event.ConditionsComparator;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.shelf.ShelfInventoryDataSource;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.util.DebugManager;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.RootDebug;
import cerent.util.SDebug;
import cerent.util.gui.TableHTMLWriter;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SmpDiagnosticExportModel {
    private static final Comparator condComp = ConditionsComparator.instance();
    private static final String CONSOLE_AVAILABLE = "ctc.console.available";
    private static final String ALARMS = "Saving Alarms Log";
    private static final String AUDIT_TRAIL = "Saving Audit Log";
    private static final String CONDITIONS = "Saving Conditions Log";
    private static final String DB_BACKUP = "Backing up Node Database";
    private static final String HISTORY = "Saving History Log";
    private static final String DUMP_DIAG = "Saving CTC Diagnostics";
    private static final String INVENTORY = "Saving Inventory Log";
    private static final String NODE_DIAG = "Saving Node Diagnostics";
    private static final String NODE_OBFL_DIAG = "Saving OBFL Diagnostics";
    private static final String CTP_INSTALL = "Saving CTP Installation";
    private static final String CTP_LOG = "Saving CTP Log";
    private static final String ZIP = "Zipping Diagnostics Files";
    private static final boolean excludeSuppressedDefault = false;
    private static final int[] allDbTypes = new int[]{5, 7, 6, 3, 4, 1, 0};
    private NodeModelDelegate nmd;
    private SDebug db;
    private IUiToolkit tk;

    public SmpDiagnosticExportModel(NodeModelDelegate nodeModelDelegate) {
        this.nmd = nodeModelDelegate;
        this.tk = nodeModelDelegate.getUiToolkit();
        this.db = nodeModelDelegate.getChildDebug(SmpDiagnosticExportModel.class, Debug.class, this);
    }

    public void dispose() {
        this.db.dispose();
    }

    private static void handleAbort() {
        if (Thread.interrupted()) {
            throw new AbortException("User-initiated abort");
        }
    }

    private void export(String string, JTable jTable, String string2) throws IOException {
        String string3 = "Exported Data - " + string2 + " - " + new Date();
        String string4 = InetUtil.makeDottedString(this.nmd.getIpConfig().getIpAddress());
        String string5 = this.nmd.getName();
        String string6 = "NE Name: " + string5 + "   Node Address: " + string4;
        this.exportTable(string, jTable, string3, string6);
    }

    private void exportTable(String string, JTable jTable, String string2, String string3) throws IOException {
        TableHTMLWriter tableHTMLWriter = new TableHTMLWriter(this.tk, jTable, true, null, string2, string3){

            protected void handleIOException(IOException iOException, String string) {
                super.handleIOException(iOException, string);
                if (iOException instanceof InterruptedIOException) {
                    AbortException abortException = new AbortException();
                    abortException.initCause(iOException);
                    throw abortException;
                }
            }
        };
        tableHTMLWriter.writeFile(string);
    }

    private JTable createJTable(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray) {
        SmpDiagnosticExportModel.handleAbort();
        SortableRowTableModel sortableRowTableModel = new SortableRowTableModel(rowDataSource, columnRendererArray);
        JTable jTable = new JTable((TableModel)((Object)sortableRowTableModel));
        sortableRowTableModel.initTable(jTable);
        return jTable;
    }

    private int getExcludes(AlarmStyle alarmStyle) {
        int n = 16;
        if (alarmStyle != AlarmStyle.ALARMS) {
            n |= 1;
        }
        if (alarmStyle == AlarmStyle.CONDITIONS) {
            n = n | 0x80 | 0x40;
        }
        if (!this.nmd.isMultishelf()) {
            n |= 0x400;
        }
        return n;
    }

    private void exportAlarmOrEvent(String string, RowDataSource rowDataSource, String string2, AlarmStyle alarmStyle) throws IOException {
        int n = this.getExcludes(alarmStyle);
        ColumnRenderer[] columnRendererArray = EventPanel.getColumnRenderers(n);
        JTable jTable = this.createJTable(rowDataSource, columnRendererArray);
        this.export(string, jTable, string2);
    }

    private RowDataSource createHistorySource() {
        ElementEventStore elementEventStore = new ElementEventStore(this.nmd, "Diagnostic AlarmLog");
        return elementEventStore;
    }

    private void populateHistorySource(RowDataSource rowDataSource, boolean bl) throws xInvalidData {
        ElementEventStore elementEventStore = (ElementEventStore)rowDataSource;
        sAlarmMessage[] sAlarmMessageArray = this.nmd.getAlarmHistory();
        if (sAlarmMessageArray != null) {
            ArrayList arrayList = new ArrayList();
            EventDispatcher eventDispatcher = this.nmd.getDispatcher();
            eventDispatcher.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, System.currentTimeMillis(), bl, true, bl, true, false);
            elementEventStore.flushStore();
            for (int i = 0; i < arrayList.size(); ++i) {
                EventInfo eventInfo = (EventInfo)arrayList.get(i);
                elementEventStore.storeEvent(eventInfo);
            }
        }
    }

    private RowDataSource getHistorySource(boolean bl) throws xInvalidData {
        RowDataSource rowDataSource = this.createHistorySource();
        this.populateHistorySource(rowDataSource, bl);
        return rowDataSource;
    }

    public void exportHistory(String string) throws xInvalidData, IOException {
        this.exportHistory(string, true);
    }

    public void exportHistory(String string, boolean bl) throws xInvalidData, IOException {
        RowDataSource rowDataSource = this.getHistorySource(bl);
        this.exportAlarmOrEvent(string, rowDataSource, HISTORY, AlarmStyle.HISTORY);
    }

    public JobControl createExportHistoryJob(final String string, final boolean bl) {
        return new JobControl(HISTORY, new IRunnable(){

            @Override
            public void run() throws xInvalidData, IOException {
                SmpDiagnosticExportModel.this.exportHistory(string, bl);
            }
        }, this.nmd, this.db);
    }

    public JobControl createExportHistoryJob(final String string) {
        return new JobControl(HISTORY, new IRunnable(){

            @Override
            public void run() throws xInvalidData, IOException {
                SmpDiagnosticExportModel.this.exportHistory(string);
            }
        }, this.nmd, this.db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDumpDiag(String string) throws IOException {
        DebugManager.init((boolean)Boolean.getBoolean(CONSOLE_AVAILABLE));
        DebugManager debugManager = DebugManager.instance();
        RootDebug rootDebug = debugManager.getRoot();
        boolean bl = rootDebug.getTime();
        boolean bl2 = rootDebug.getThread();
        rootDebug.time(true);
        rootDebug.thread(true);
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(string);
            debugManager.addPrintStream(printStream);
            rootDebug.dumpDiag();
            debugManager.removePrintStream(printStream);
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
            rootDebug.time(bl);
            rootDebug.thread(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToFile(String string, String string2) throws FileNotFoundException {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string, false));
            printStream.println(string2);
            printStream.flush();
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public JobControl createExportDumpDiagJob(final String string) {
        return new JobControl(DUMP_DIAG, new IRunnable(){

            @Override
            public void run() throws IOException {
                SmpDiagnosticExportModel.this.exportDumpDiag(string);
            }
        }, this.nmd, this.db);
    }

    public DelegatingJobControl createExportNodeDiagnosticsJob(String string) {
        return new DelegatingJobControl(this.nmd.createDataTransferJob(string, 6, null), NODE_DIAG, this.nmd, this.db);
    }

    public DelegatingJobControl createExportOBFLDiagnosticsJob(String string) {
        return new DelegatingJobControl(this.nmd.createDataTransferJob(string, 9, null), NODE_OBFL_DIAG, this.nmd, this.db);
    }

    public DelegatingJobControl createExportDatabaseBackupJob(String string) {
        return new DelegatingJobControl(this.nmd.createDataTransferJob(string, 1, null, allDbTypes), DB_BACKUP, this.nmd, this.db);
    }

    private RowDataSource createAuditTrailSource() {
        AuditStore auditStore = new AuditStore("Diagnostic AuditLog");
        return auditStore;
    }

    private void populateAuditTrailSource(RowDataSource rowDataSource) throws InvalidData, AbstractCmsIOException {
        AuditStore auditStore = (AuditStore)rowDataSource;
        AuditTrail[] auditTrailArray = this.nmd.getAuditTrailList(0);
        for (int i = 0; i < auditTrailArray.length; ++i) {
            auditStore.storeEvent(auditTrailArray[i]);
        }
    }

    private RowDataSource getAuditTrailSource() throws InvalidData, AbstractCmsIOException {
        RowDataSource rowDataSource = this.createAuditTrailSource();
        this.populateAuditTrailSource(rowDataSource);
        return rowDataSource;
    }

    public void exportAuditTrail(String string) throws InvalidData, AbstractCmsIOException, IOException {
        RowDataSource rowDataSource = this.getAuditTrailSource();
        ColumnRenderer[] columnRendererArray = AuditPanel.getColumnRenderers();
        JTable jTable = this.createJTable(rowDataSource, columnRendererArray);
        this.export(string, jTable, AUDIT_TRAIL);
    }

    public JobControl createExportAuditTrailJob(final String string) {
        return new JobControl(AUDIT_TRAIL, new IRunnable(){

            @Override
            public void run() throws InvalidData, AbstractCmsIOException, IOException {
                SmpDiagnosticExportModel.this.exportAuditTrail(string);
            }
        }, this.nmd, this.db);
    }

    private RowDataSource createInventorySource() {
        return new ShelfInventoryDataSource(this.nmd);
    }

    private void populateInventorySource(RowDataSource rowDataSource) throws Exception {
        ShelfInventoryDataSource shelfInventoryDataSource = (ShelfInventoryDataSource)rowDataSource;
        shelfInventoryDataSource.refreshFromModel(-1);
    }

    private RowDataSource getInventorySource() throws Exception {
        RowDataSource rowDataSource = this.createInventorySource();
        this.populateInventorySource(rowDataSource);
        return rowDataSource;
    }

    public void exportInventory(String string) throws Exception {
        RowDataSource rowDataSource = this.getInventorySource();
        ColumnRenderer[] columnRendererArray = ShelfInventoryPane.getColumnRenderers();
        JTable jTable = this.createJTable(rowDataSource, columnRendererArray);
        this.export(string, jTable, INVENTORY);
    }

    public JobControl createExportInventoryJob(final String string) {
        return new JobControl(INVENTORY, new IRunnable(){

            @Override
            public void run() throws Exception {
                SmpDiagnosticExportModel.this.exportInventory(string);
            }
        }, this.nmd, this.db);
    }

    private ElementAlarmStore createAlarmSource() {
        return new ElementAlarmStore(this.nmd, "Diagnostic AlarmStore");
    }

    private void populateAlarmSource(RowDataSource rowDataSource) {
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)rowDataSource;
        ArrayList arrayList = this.nmd.getAlarms();
        Collections.sort(arrayList, condComp);
        elementAlarmStore.addEvents(arrayList);
    }

    private RowDataSource getAlarmSource() {
        ElementAlarmStore elementAlarmStore = this.createAlarmSource();
        this.populateAlarmSource((RowDataSource)elementAlarmStore);
        return elementAlarmStore;
    }

    public void exportAlarms(String string) throws IOException {
        RowDataSource rowDataSource = this.getAlarmSource();
        this.exportAlarmOrEvent(string, rowDataSource, ALARMS, AlarmStyle.ALARMS);
    }

    public JobControl createExportAlarmsJob(final String string) {
        return new JobControl(ALARMS, new IRunnable(){

            @Override
            public void run() throws IOException {
                SmpDiagnosticExportModel.this.exportAlarms(string);
            }
        }, this.nmd, this.db);
    }

    private RowDataSource createConditionsSource() {
        return new ARowSource();
    }

    private void populateConditionsSource(RowDataSource rowDataSource, boolean bl) {
        ARowSource aRowSource = (ARowSource)rowDataSource;
        ArrayList arrayList = this.nmd.getNodeConditionList(bl);
        Collections.sort(arrayList, condComp);
        aRowSource.setArrayList(arrayList);
    }

    private RowDataSource getConditionsSource(boolean bl) {
        RowDataSource rowDataSource = this.createConditionsSource();
        this.populateConditionsSource(rowDataSource, bl);
        return rowDataSource;
    }

    public void exportConditions(String string, boolean bl) throws IOException {
        RowDataSource rowDataSource = this.getConditionsSource(bl);
        this.exportAlarmOrEvent(string, rowDataSource, CONDITIONS, AlarmStyle.CONDITIONS);
    }

    public void exportConditions(String string) throws IOException {
        this.exportConditions(string, false);
    }

    public JobControl createExportConditionsJob(final String string, final boolean bl) {
        return new JobControl(CONDITIONS, new IRunnable(){

            @Override
            public void run() throws IOException {
                SmpDiagnosticExportModel.this.exportConditions(string, bl);
            }
        }, this.nmd, this.db);
    }

    public JobControl createExportConditionsJob(String string) {
        return this.createExportConditionsJob(string, false);
    }

    public JobControl createExportCTPInstallJob(final String string) {
        return new JobControl(CTP_INSTALL, new IRunnable(){

            @Override
            public void run() throws IOException {
                String string2 = SmpDiagnosticExportModel.this.nmd.getNodeSetupModel().readInstXMLFile();
                SmpDiagnosticExportModel.this.exportToFile(string, string2);
            }
        }, this.nmd, this.db);
    }

    public JobControl createExportCTPLogJob(final String string) {
        return new JobControl(CTP_LOG, new IRunnable(){

            @Override
            public void run() throws IOException {
                String string2 = SmpDiagnosticExportModel.this.nmd.getNodeSetupModel().readInstLogFile();
                SmpDiagnosticExportModel.this.exportToFile(string, string2);
            }
        }, this.nmd, this.db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFiles(String string, String[] stringArray, String[] stringArray2) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ZipOutputStream zipOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            int n = -1;
            for (String string2 : stringArray) {
                ++n;
                if (string2 == null) continue;
                if (this.db.on()) {
                    this.db.println("About to try zipping: " + string2);
                }
                File file2 = new File(string2);
                String string3 = file2.getName();
                if (!file2.exists()) {
                    if (!this.db.on()) continue;
                    this.db.println("skipping non-existent file: " + string2);
                    continue;
                }
                String string4 = stringArray2 != null && stringArray2[n] != null ? stringArray2[n] : string3;
                zipOutputStream.putNextEntry(new ZipEntry(string4));
                FileInputStream fileInputStream = null;
                try {
                    int n2;
                    fileInputStream = new FileInputStream(string2);
                    while ((n2 = fileInputStream.read(byArray)) >= 0) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void zipFiles(String[] stringArray) throws IOException {
        String string = stringArray[0];
        System.arraycopy(stringArray, 1, stringArray, 0, stringArray.length - 1);
        stringArray[stringArray.length - 1] = null;
        this.zipFiles(string, stringArray, null);
    }

    public JobControl createZipFilesJob(final String string, final String[] stringArray, final String[] stringArray2) {
        return new JobControl(ZIP, new IRunnable(){

            @Override
            public void run() throws IOException {
                SmpDiagnosticExportModel.this.zipFiles(string, stringArray, stringArray2);
            }
        }, this.nmd, this.db);
    }

    public JobControl createZipFilesJob(final String string, final String[] stringArray) {
        return new JobControl(ZIP, new IRunnable(){

            @Override
            public void run() throws IOException {
                SmpDiagnosticExportModel.this.zipFiles(string, stringArray, null);
            }
        }, this.nmd, this.db);
    }

    public static class AbortException
    extends RuntimeException {
        public AbortException() {
        }

        public AbortException(String string) {
            super(string);
        }
    }

    private static enum AlarmStyle {
        ALARMS,
        HISTORY,
        CONDITIONS;

    }

    public class Debug
    extends SDebug {
        public Debug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void zipFiles(String[] stringArray) throws IOException {
            SmpDiagnosticExportModel.this.zipFiles(stringArray);
        }
    }

    public static class DelegatingJobControl
    implements IJobControl {
        private IJobControl delegate;
        private String name;
        private NodeModelDelegate nmd;
        private SDebug db;
        private long elapsedTimeMillis = -1L;

        protected DelegatingJobControl(IJobControl iJobControl, String string, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
            this.name = string;
            this.delegate = iJobControl;
            this.nmd = nodeModelDelegate;
            this.db = sDebug;
        }

        protected DelegatingJobControl(IJobControl iJobControl, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
            this(iJobControl, null, nodeModelDelegate, sDebug);
        }

        public IJobControl getDelegate() {
            return this.delegate;
        }

        public boolean isExceptionDueToAnAbort(Exception exception) {
            return exception instanceof AbortException || exception instanceof InterruptedIOException;
        }

        public String getName() {
            return this.name == null ? this.delegate.getName() : this.name;
        }

        public JobStatus executeJob() throws Exception {
            long l = System.currentTimeMillis();
            try {
                JobStatus jobStatus = this.delegate.executeJob();
                return jobStatus;
            }
            catch (Exception exception) {
                if (this.db.on()) {
                    this.db.println("error on " + this);
                    SDebug.printStackTrace((Throwable)exception);
                }
                throw exception;
            }
            finally {
                long l2 = System.currentTimeMillis();
                this.elapsedTimeMillis = l2 - l;
            }
        }

        public void abortJob() {
            this.delegate.abortJob();
        }

        public long getElapsedTime() {
            return this.elapsedTimeMillis;
        }

        public String toString() {
            return "Diagnostic job " + this.getName() + " for node: " + this.nmd.getName() + (this.elapsedTimeMillis < 0L ? "" : " (" + this.elapsedTimeMillis + " msecs)");
        }
    }

    private static interface IRunnable {
        public void run() throws Exception;
    }

    public static class JobControl
    implements IJobControl {
        private String name;
        private IRunnable runnable;
        private Thread runningThread;
        private NodeModelDelegate nmd;
        private SDebug db;
        private long elapsedTimeMillis = -1L;

        protected JobControl(String string, IRunnable iRunnable, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
            this.name = string;
            this.runnable = iRunnable;
            this.nmd = nodeModelDelegate;
            this.db = sDebug;
        }

        public String getName() {
            return this.name;
        }

        public JobStatus executeJob() throws Exception {
            long l = System.currentTimeMillis();
            this.runningThread = Thread.currentThread();
            JobStatus jobStatus = JobStatus.JOB_COMPLETE;
            try {
                this.runnable.run();
            }
            catch (AbortException abortException) {
                jobStatus = JobStatus.JOB_ABORT;
                if (this.db.on()) {
                    this.db.println("abort on " + this);
                }
            }
            catch (RuntimeException runtimeException) {
                jobStatus = new JobStatus(2, (Object)runtimeException);
                if (this.db.on()) {
                    this.db.println("error on " + this);
                    SDebug.printStackTrace((Throwable)runtimeException);
                }
                throw runtimeException;
            }
            catch (InterruptedIOException interruptedIOException) {
                AbortException abortException = new AbortException();
                abortException.initCause(interruptedIOException);
                if (this.db.on()) {
                    this.db.println("abort on " + this);
                }
                throw abortException;
            }
            catch (Exception exception) {
                jobStatus = new JobStatus(2, (Object)exception);
                if (this.db.on()) {
                    this.db.println("error on " + this);
                    SDebug.printStackTrace((Throwable)exception);
                }
                throw exception;
            }
            finally {
                long l2 = System.currentTimeMillis();
                this.elapsedTimeMillis = l2 - l;
                this.runningThread = null;
            }
            return jobStatus;
        }

        public void abortJob() {
            Thread thread = this.runningThread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        public long getElapsedTime() {
            return this.elapsedTimeMillis;
        }

        public String toString() {
            return "Diagnostic job " + this.getName() + " for node: " + this.nmd.getName() + (this.elapsedTimeMillis < 0L ? "" : " (" + this.elapsedTimeMillis + " msecs)");
        }
    }
}

