/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ISpanCheckModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SpanCheckModel;
import cerent.cms.model.SpanCheckModels;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SpanCheckTableModel
extends AbstractTableModel
implements Observer {
    public static final String[] columnNames = new String[]{"Side ", "Measured By", "Min Exp. Span Loss (dB)", "Max Exp. Span Loss (dB)", "Meas. Span Loss (dB)", "Resolution (dB)"};
    public static final int SIDE_INDEX = 0;
    public static final int CALCTYPE_INDEX = 1;
    public static final int EXP_MIN_SL_INDEX = 2;
    public static final int EXP_MAX_SL_INDEX = 3;
    public static final int MEAS_SL_INDEX = 4;
    public static final int RESOL_INDEX = 5;
    protected NodeModelDelegate model;
    protected Vector<SpanCheckInfo> spanCheckList = new Vector();
    protected static final SDebug db = new SDebug("SpanCheckTableModel");

    public SpanCheckTableModel(NodeModelDelegate nodeModelDelegate) {
        this.model = nodeModelDelegate;
        this.regNotify();
        this.init();
    }

    protected int getNumLines() {
        return this.spanCheckList.size();
    }

    private void init() {
        this.resetDirtyBits();
    }

    private void regNotify() {
        this.model.getSpanCheckModels().addObserver(this);
        ISpanCheckModel[] iSpanCheckModelArray = this.model.getSpanCheckModels().getSpanCheckModel();
        for (int i = 0; i < iSpanCheckModelArray.length; ++i) {
            ISpanCheckModel iSpanCheckModel = iSpanCheckModelArray[i];
            iSpanCheckModel.addObserver(this);
            this.spanCheckList.add(new SpanCheckInfo(iSpanCheckModel));
        }
    }

    private void unRegNotify() {
        this.model.getSpanCheckModels().deleteObserver(this);
        ISpanCheckModel[] iSpanCheckModelArray = this.model.getSpanCheckModels().getSpanCheckModel();
        for (int i = 0; i < iSpanCheckModelArray.length; ++i) {
            ISpanCheckModel iSpanCheckModel = iSpanCheckModelArray[i];
            iSpanCheckModel.deleteObserver(this);
        }
    }

    public void dispose() {
        this.unRegNotify();
    }

    String getSide(int n) {
        if (this.spanCheckList.get((int)n).sideVal == null) {
            this.spanCheckList.get((int)n).sideVal = this.spanCheckList.get((int)n).model.getSide();
        }
        return this.spanCheckList.get((int)n).sideVal;
    }

    String getMinExpectedSpanLoss(int n) {
        if (this.spanCheckList.get((int)n).expMinSpanLossVal == null) {
            this.spanCheckList.get((int)n).expMinSpanLossVal = this.spanCheckList.get((int)n).model.getMinExpectedSpanLoss();
        }
        return this.spanCheckList.get((int)n).expMinSpanLossVal;
    }

    String getMaxExpectedSpanLoss(int n) {
        if (this.spanCheckList.get((int)n).expMaxSpanLossVal == null) {
            this.spanCheckList.get((int)n).expMaxSpanLossVal = this.spanCheckList.get((int)n).model.getMaxExpectedSpanLoss();
        }
        return this.spanCheckList.get((int)n).expMaxSpanLossVal;
    }

    String getMeasuredSpanLoss(int n) {
        return this.spanCheckList.get((int)n).model.getMeasuredSpanLoss();
    }

    String getResolution(int n) {
        return this.spanCheckList.get((int)n).model.getResolution();
    }

    String getCalcType(int n) {
        return this.spanCheckList.get((int)n).model.getCalcType();
    }

    public Vector getSpanCheckList() {
        return this.spanCheckList;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 2: {
                if (this.spanCheckList.get((int)n).expMinSpanLossVal == (String)object) break;
                this.spanCheckList.get((int)n).expMinSpanLossVal = (String)object;
                break;
            }
            case 3: {
                if (this.spanCheckList.get((int)n).expMaxSpanLossVal == (String)object) break;
                this.spanCheckList.get((int)n).expMaxSpanLossVal = (String)object;
                break;
            }
            default: {
                return;
            }
        }
        this.spanCheckList.get((int)n).isDirty[n2] = true;
        this.fireTableCellUpdated(n, n2);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.getNumLines();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.getRowCount() > 0) {
            if (n2 == 3) {
                return this.spanCheckList.get((int)n).model.hasMaxValuebyAns();
            }
            if (n2 == 2) {
                return this.spanCheckList.get((int)n).model.hasMinValuebyAns();
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 2: {
                    return this.getMinExpectedSpanLoss(n);
                }
                case 3: {
                    return this.getMaxExpectedSpanLoss(n);
                }
                case 0: {
                    return this.getSide(n);
                }
                case 4: {
                    return this.getMeasuredSpanLoss(n);
                }
                case 5: {
                    return this.getResolution(n);
                }
                case 1: {
                    return this.getCalcType(n);
                }
            }
        }
        catch (Exception exception) {
            db.severe("Error in getting values " + exception);
        }
        return null;
    }

    public void refreshFromModel() {
        db.fine("refreshing table from model");
        for (SpanCheckInfo object : this.spanCheckList) {
            object.model.deleteObserver(this);
        }
        this.spanCheckList.clear();
        for (int i = 0; i < this.model.getSpanCheckModels().getSpanCheckModel().length; ++i) {
            SpanCheckModel spanCheckModel = (SpanCheckModel)this.model.getSpanCheckModels().getSpanCheckModel()[i];
            spanCheckModel.addObserver(this);
            this.spanCheckList.add(new SpanCheckInfo(spanCheckModel));
        }
        this.fireTableDataChanged();
    }

    public void refreshFromModel(int n) {
        db.fine("refreshing table from model side " + n);
        int n2 = 0;
        for (int i = 0; i < this.getNumLines(); ++i) {
            if (this.spanCheckList.get((int)i).sideIndex != n) continue;
            this.spanCheckList.get((int)i).expMinSpanLossVal = null;
            this.spanCheckList.get((int)i).expMaxSpanLossVal = null;
            this.spanCheckList.get((int)i).resolutionVal = null;
            this.spanCheckList.get((int)i).measSpanLossVal = null;
            this.spanCheckList.get((int)i).sideVal = null;
            this.spanCheckList.get((int)i).calcTypeVal = null;
            n2 = i;
            break;
        }
        this.fireTableRowsUpdated(n2, n2);
    }

    public boolean isDirty() {
        int n = this.getColumnCount();
        for (int i = 0; i < this.getNumLines(); ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.spanCheckList.get((int)i).isDirty[j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirtyBits() {
        for (SpanCheckInfo spanCheckInfo : this.spanCheckList) {
            for (int i = 0; i < columnNames.length; ++i) {
                spanCheckInfo.isDirty[i] = false;
            }
        }
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.getNumLines(); ++i) {
            if (this.spanCheckList.get((int)i).isDirty[2] && this.spanCheckList.get((int)i).isDirty[3]) {
                float f = Float.parseFloat(this.spanCheckList.get((int)i).model.getMaxExpectedSpanLoss());
                float f2 = Float.parseFloat(this.spanCheckList.get((int)i).expMinSpanLossVal);
                if (f2 > f) {
                    this.spanCheckList.get((int)i).model.setMaxExpectedSpanLoss(this.spanCheckList.get((int)i).expMaxSpanLossVal);
                    this.spanCheckList.get((int)i).model.setMinExpectedSpanLoss(this.spanCheckList.get((int)i).expMinSpanLossVal);
                    continue;
                }
                this.spanCheckList.get((int)i).model.setMinExpectedSpanLoss(this.spanCheckList.get((int)i).expMinSpanLossVal);
                this.spanCheckList.get((int)i).model.setMaxExpectedSpanLoss(this.spanCheckList.get((int)i).expMaxSpanLossVal);
                continue;
            }
            if (this.spanCheckList.get((int)i).isDirty[2]) {
                this.spanCheckList.get((int)i).model.setMinExpectedSpanLoss(this.spanCheckList.get((int)i).expMinSpanLossVal);
            }
            if (!this.spanCheckList.get((int)i).isDirty[3]) continue;
            this.spanCheckList.get((int)i).model.setMaxExpectedSpanLoss(this.spanCheckList.get((int)i).expMaxSpanLossVal);
        }
        this.refreshFromModel();
        this.resetDirtyBits();
    }

    @Override
    public void update(Observable observable, Object object) {
        int n;
        if (db.on()) {
            db.println("Got update from " + observable + " arg=" + object);
        }
        int n2 = 0;
        if (object instanceof IObjectMessageInfo) {
            n = ((IObjectMessageInfo)object).getUpdateType();
            n2 = ((IObjectMessageInfo)object).getIndex();
        } else {
            n = (Integer)object;
            if (observable instanceof Model) {
                n2 = ((Model)((Object)observable)).getIndex();
            }
        }
        if (observable instanceof SpanCheckModels) {
            if (n == 2) {
                this.refreshFromModel();
            }
        } else if (observable instanceof SpanCheckModel) {
            if (n == 1) {
                this.refreshFromModel(n2);
            } else if (n == 0) {
                this.refreshFromModel();
            }
        }
    }

    class SpanCheckInfo {
        boolean[] isDirty;
        ISpanCheckModel model;
        String sideVal;
        String expMinSpanLossVal;
        String expMaxSpanLossVal;
        String measSpanLossVal;
        String resolutionVal;
        String calcTypeVal;
        int sideIndex;

        public SpanCheckInfo(ISpanCheckModel iSpanCheckModel) {
            this.model = iSpanCheckModel;
            this.isDirty = new boolean[columnNames.length];
            this.sideIndex = iSpanCheckModel.getIndex();
            this.sideVal = iSpanCheckModel.getSide();
            this.expMinSpanLossVal = iSpanCheckModel.getMinExpectedSpanLoss();
            this.expMaxSpanLossVal = iSpanCheckModel.getMaxExpectedSpanLoss();
            this.measSpanLossVal = iSpanCheckModel.getMeasuredSpanLoss();
            this.calcTypeVal = iSpanCheckModel.getCalcType();
            this.resolutionVal = iSpanCheckModel.getResolution();
        }
    }
}

