/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eMultishelfLanConfig;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ShelfInfo;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.NumberTextField;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppMultishelfConfigPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private ButtonGroup radioButtons;
    private JRadioButton disableButton;
    private JRadioButton scButton;
    private JRadioButton ncButton;
    private JComboBox lanConfigCB;
    private VlanAttr pubVlanIdCB;
    private VlanAttr intlVlanIdCB;
    private JComboBox shelfIdCB;
    private DefaultComboBoxModel lanCBModel;
    private boolean enableB = false;
    private IObservableManager om;
    private static final String DISABLE = "Disable Multishelf";
    private static final String SC = "Enable as Subtended Shelf";
    private static final String NC = "Enable as Node Controller";
    private static final String[] LAN_CFG = new String[]{"N/A", "Ethernet Switch", "Stand-alone"};
    private static final int MAX_SHELF = 30;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppMultishelfConfigPane");
    private static final int TCC1_SLOT = 7;
    private static final int AIC_SLOT = 9;
    private static final int TCC2_SLOT = 11;
    private static final int TNC1_SLOT = 1;
    private static final int TNC2_M6_SLOT = 8;
    private static final int TNC2_M2_SLOT = 1;
    private static final int TNC2_M15_SLOT = 17;

    public SppMultishelfConfigPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SppMultishelfConfigPane;
    }

    private void init() {
        db.info("init: start");
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.enableB = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createButtonPanel());
        this.registerWithModel();
        db.info("init: finish");
    }

    @Override
    protected void registerWithModel() {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.reset();
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        iObservableManager.addObservable((Observable)((Object)((EntityModel)((Object)iChassisModel))));
        iObservableManager.addObservable((Observable)((Object)iChassisModel.getNodeModelDelegate()));
        iObservableManager.setActive(true);
    }

    @Override
    protected IObservableManager getObservableManager() {
        if (this.om == null) {
            this.om = new ObservableManager((Observer)((Object)this), true);
        }
        return this.om;
    }

    private JPanel createButtonPanel() {
        this.disableButton = new JRadioButton(DISABLE);
        this.disableButton.addActionListener(this);
        this.disableButton.setMnemonic(68);
        this.scButton = new JRadioButton(SC);
        this.scButton.addActionListener(this);
        this.scButton.setMnemonic(83);
        this.ncButton = new JRadioButton(NC);
        this.ncButton.addActionListener(this);
        this.ncButton.setMnemonic(78);
        this.radioButtons = new ButtonGroup();
        this.radioButtons.add(this.disableButton);
        this.radioButtons.add(this.scButton);
        this.radioButtons.add(this.ncButton);
        Short[] shortArray = new Short[29];
        for (int i = 1; i < 30; ++i) {
            shortArray[i - 1] = new Short((short)(i + 1));
        }
        this.shelfIdCB = new JComboBox<Short>(shortArray);
        this.shelfIdCB.addActionListener(this);
        this.shelfIdCB.setEnabled(false);
        this.lanCBModel = new DefaultComboBoxModel<String>(LAN_CFG);
        this.lanConfigCB = new JComboBox(this.lanCBModel);
        this.lanConfigCB.addActionListener(this);
        this.lanConfigCB.setEnabled(false);
        this.pubVlanIdCB = new VlanAttr();
        this.pubVlanIdCB.init();
        this.intlVlanIdCB = new VlanAttr();
        this.intlVlanIdCB.init();
        JPanel jPanel = new JPanel(new GridLayout(5, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder("Multishelf Configuration"));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel2.add(this.disableButton);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel3.add(new JLabel(" "));
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel4.add(new JLabel(" "));
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel5.add(this.scButton);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel6.add(new JLabel("Shelf ID:"));
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 1));
        Dimension dimension = this.shelfIdCB.getPreferredSize();
        Dimension dimension2 = new Dimension((int)dimension.getWidth() + 15, (int)dimension.getHeight());
        this.shelfIdCB.setPreferredSize(dimension2);
        jPanel7.add(this.shelfIdCB);
        jPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel8.add(this.ncButton);
        jPanel.add(jPanel8);
        JPanel jPanel9 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel9.add(new JLabel("LAN Config:"));
        jPanel.add(jPanel9);
        JPanel jPanel10 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel10.add(this.lanConfigCB);
        jPanel.add(jPanel10);
        jPanel.add(new JPanel(new FlowLayout(0, 5, 1)).add(new JLabel(" ")));
        JPanel jPanel11 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel11.add(new JLabel("Public VLAN ID:"));
        jPanel.add(jPanel11);
        JPanel jPanel12 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel12.add(this.pubVlanIdCB);
        jPanel.add(jPanel12);
        jPanel.add(new JPanel(new FlowLayout(0, 5, 1)).add(new JLabel(" ")));
        JPanel jPanel13 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel13.add(new JLabel("Internal VLAN ID:"));
        jPanel.add(jPanel13);
        JPanel jPanel14 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel14.add(this.intlVlanIdCB);
        jPanel.add(jPanel14);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (object == null) {
            db.severe("Null actionPerformed source!");
            return;
        }
        if (object == this.disableButton) {
            if (this.lanCBModel.getSize() < LAN_CFG.length) {
                this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            this.lanConfigCB.setEnabled(false);
            this.pubVlanIdCB.disableEdit();
            this.intlVlanIdCB.disableEdit();
            this.shelfIdCB.setEnabled(false);
        } else if (object == this.scButton) {
            ShelfInfo shelfInfo;
            if (this.lanCBModel.getSize() < LAN_CFG.length) {
                this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            this.lanConfigCB.setEnabled(false);
            this.pubVlanIdCB.disableEdit();
            this.intlVlanIdCB.disableEdit();
            this.shelfIdCB.setSelectedIndex(0);
            if (iChassisModel.getNodeModel().isMultishelf() && (shelfInfo = iChassisModel.getShelfInfo()).getShelfRole() == ShelfInfo.IShelfRole.SHELF_ROLE_SC) {
                this.shelfIdCB.setSelectedIndex(iChassisModel.getShelfId() - 2);
            }
            this.shelfIdCB.setEnabled(this.enableB);
        } else if (object == this.ncButton) {
            this.shelfIdCB.setSelectedIndex(0);
            this.shelfIdCB.setEnabled(false);
            if (this.lanCBModel.getSize() > LAN_CFG.length - 1) {
                this.lanCBModel.removeElementAt(0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            if (iChassisModel.getNodeModel().isMultishelf()) {
                ShelfInfo shelfInfo = iChassisModel.getShelfInfo();
                if (shelfInfo.getShelfRole() == ShelfInfo.IShelfRole.SHELF_ROLE_NC) {
                    this.lanConfigCB.setSelectedIndex(shelfInfo.getLanConfig().value() - 1);
                }
                if (shelfInfo.getLanConfig().value() == 1) {
                    if (iChassisModel.isUTSChassis()) {
                        this.pubVlanIdCB.setText("1");
                        this.pubVlanIdCB.setEnabled(false);
                        this.intlVlanIdCB.setText("2");
                        this.intlVlanIdCB.setEnabled(false);
                    } else {
                        this.pubVlanIdCB.enableEdit(shelfInfo.getPublicVLANId());
                        this.intlVlanIdCB.enableEdit(shelfInfo.getInternalVLANId());
                    }
                } else {
                    this.pubVlanIdCB.disableEdit();
                    this.intlVlanIdCB.disableEdit();
                }
            }
            this.lanConfigCB.setEnabled(this.enableB);
        } else if (object == this.lanConfigCB) {
            ShelfInfo shelfInfo;
            if (this.lanConfigCB.getSelectedIndex() + 1 == 1) {
                shelfInfo = iChassisModel.getShelfInfo();
                this.pubVlanIdCB.enableEdit(shelfInfo.getPublicVLANId());
                this.intlVlanIdCB.enableEdit(shelfInfo.getInternalVLANId());
            } else {
                this.pubVlanIdCB.disableEdit();
                this.intlVlanIdCB.disableEdit();
            }
            if (iChassisModel.isUTSChassis()) {
                shelfInfo = iChassisModel.getShelfInfo();
                this.pubVlanIdCB.setText("1");
                this.pubVlanIdCB.setEnabled(false);
                this.intlVlanIdCB.setText("2");
                this.intlVlanIdCB.setEnabled(false);
            }
        }
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        db.info("applyChangesToModel: start");
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (this.isProvPaneDirty()) {
            ShelfInfo.IShelfRole iShelfRole = iChassisModel.getShelfInfo().getShelfRole();
            ShelfInfo.IShelfRole iShelfRole2 = this.ncButton.isSelected() ? ShelfInfo.IShelfRole.SHELF_ROLE_NC : (this.scButton.isSelected() ? ShelfInfo.IShelfRole.SHELF_ROLE_SC : ShelfInfo.IShelfRole.SHELF_ROLE_SINGLE);
            try {
                StringBuffer stringBuffer = new StringBuffer("CAUTION: This will cause your node to reboot.");
                db.fine("curRole = " + iShelfRole + ", newRole = " + iShelfRole2);
                if (iShelfRole != iShelfRole2) {
                    db.fine("applyChangesToModel: setting MS mode to " + (this.disableButton.isSelected() ? "disabled" : (this.scButton.isSelected() ? "sc" : "nc")));
                    if (this.scButton.isSelected()) {
                        stringBuffer = new StringBuffer(ErrorMsg.getString((EID)EMC.WID_MS_CONFIG_WARNING, (Object)this.shelfIdCB.getSelectedItem()));
                    }
                    stringBuffer.append("\n\nIs it OK to continue?");
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Multishelf Provisioning")) {
                        if (iShelfRole2 == ShelfInfo.IShelfRole.SHELF_ROLE_SC) {
                            iChassisModel.enableMultishelfAsSc((Short)this.shelfIdCB.getSelectedItem());
                        } else if (iShelfRole2 == ShelfInfo.IShelfRole.SHELF_ROLE_NC) {
                            if (!iChassisModel.isUTSChassis()) {
                                iChassisModel.enableMultishelfAsNc(eMultishelfLanConfig.from_int(this.lanConfigCB.getSelectedIndex() + 1), this.pubVlanIdCB.getValue(), this.intlVlanIdCB.getValue());
                            } else {
                                iChassisModel.enableMultishelfAsNc(eMultishelfLanConfig.from_int(this.lanConfigCB.getSelectedIndex() + 1), (short)1, (short)2);
                            }
                        } else {
                            iChassisModel.disableMultishelf();
                        }
                        this.resetDirty();
                    }
                } else if (iShelfRole == ShelfInfo.IShelfRole.SHELF_ROLE_NC) {
                    if (!(this.lanConfigCB.getSelectedIndex() + 1 != 1 || this.pubVlanIdCB.validateUserInput(iChassisModel.getShelfInfo().getPublicVLANId()) && this.intlVlanIdCB.validateUserInput(iChassisModel.getShelfInfo().getInternalVLANId()))) {
                        if (db.on()) {
                            db.warning("Invalid VLAN ID user input");
                        }
                        this.refreshFromModel();
                    } else {
                        stringBuffer.append("\n\nIs it OK to continue?");
                        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Multishelf Provisioning")) {
                            iChassisModel.setEthConfig(eMultishelfLanConfig.from_int(this.lanConfigCB.getSelectedIndex() + 1), this.pubVlanIdCB.getValue(), this.intlVlanIdCB.getValue());
                            this.resetDirty();
                        }
                    }
                } else {
                    iChassisModel.setShelfId(((Short)this.shelfIdCB.getSelectedItem()).intValue());
                }
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MS_NOT_SUPPORTED_ON_CHASSIS);
                this.refreshFromModel();
            }
            catch (ProvisionError provisionError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)provisionError);
                }
                if (provisionError.getEID() != null) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_PROVISION_ERROR_PARAM_1, (Object)provisionError.getMessage());
                }
                this.refreshFromModel();
            }
            catch (ResourceInUse resourceInUse) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)resourceInUse);
                }
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MS_DISABLE_NOT_ALLOWED_PARAM_1, (Object)"Not allowed with SSC Provisioned.");
                this.refreshFromModel();
            }
        }
        db.info("applyChangesToModel: finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.radioButtons == null) {
                this.init();
            }
            IObservableManager iObservableManager = this.getObservableManager();
            iObservableManager.setPassing(true);
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.setPassing(false);
        super.leavingPage();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void refreshFromModel() throws Exception {
        db.info("refreshFromModel: start");
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel == null) {
            db.severe("Chassis is null in SppMultishelfConfigPane::refresh()");
            return;
        }
        if (iChassisModel.getNodeModel().isMultishelf()) {
            ShelfInfo shelfInfo = iChassisModel.getShelfInfo();
            this.disableButton.setEnabled(this.enableB);
            switch (shelfInfo.getShelfRole().value()) {
                case 0: 
                case 2: {
                    this.ncButton.setSelected(this.enableB);
                    this.ncButton.setEnabled(this.enableB);
                    this.scButton.setEnabled(false);
                    this.shelfIdCB.setSelectedIndex(0);
                    this.shelfIdCB.setEnabled(false);
                    if (this.lanCBModel.getSize() > LAN_CFG.length - 1) {
                        this.lanCBModel.removeElementAt(0);
                    }
                    this.lanConfigCB.setSelectedIndex(shelfInfo.getLanConfig().value() - 1);
                    this.lanConfigCB.setEnabled(this.enableB);
                    if (shelfInfo.getLanConfig().value() == 1) {
                        if (iChassisModel.isUTSChassis()) {
                            this.pubVlanIdCB.setText(Short.toString(shelfInfo.getPublicVLANId()));
                            this.pubVlanIdCB.setEnabled(false);
                            this.intlVlanIdCB.setText(Short.toString(shelfInfo.getInternalVLANId()));
                            this.intlVlanIdCB.setEnabled(false);
                            break;
                        }
                        this.pubVlanIdCB.enableEdit(shelfInfo.getPublicVLANId());
                        this.intlVlanIdCB.enableEdit(shelfInfo.getInternalVLANId());
                        if (this.enableB) break;
                        this.pubVlanIdCB.disableEdit();
                        this.intlVlanIdCB.disableEdit();
                        break;
                    }
                    this.pubVlanIdCB.disableEdit();
                    this.intlVlanIdCB.disableEdit();
                    break;
                }
                case 1: {
                    this.scButton.setSelected(this.enableB);
                    this.scButton.setEnabled(this.enableB);
                    this.ncButton.setEnabled(false);
                    if (this.lanCBModel.getSize() < LAN_CFG.length) {
                        this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
                    }
                    this.lanConfigCB.setSelectedIndex(0);
                    this.lanConfigCB.setEnabled(false);
                    this.pubVlanIdCB.disableEdit();
                    this.intlVlanIdCB.disableEdit();
                    this.shelfIdCB.setSelectedIndex(iChassisModel.getShelfId() - 2);
                    this.shelfIdCB.setEnabled(this.enableB);
                    break;
                }
                default: {
                    db.severe("Bad shelf role: " + shelfInfo.getShelfRole().value());
                    break;
                }
            }
        } else {
            this.disableButton.setSelected(this.enableB);
            if (this.lanCBModel.getSize() < LAN_CFG.length) {
                this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            this.lanConfigCB.setEnabled(false);
            this.pubVlanIdCB.disableEdit();
            this.intlVlanIdCB.disableEdit();
            this.shelfIdCB.setSelectedIndex(0);
            this.shelfIdCB.setEnabled(false);
            if (this.isMultiShelfSelectable()) {
                this.disableButton.setEnabled(this.enableB);
                this.scButton.setEnabled(this.enableB);
                this.ncButton.setEnabled(this.enableB);
            } else {
                this.disableButton.setEnabled(false);
                this.scButton.setEnabled(false);
                this.ncButton.setEnabled(false);
            }
        }
        db.info("refreshFromModel: finish");
    }

    @Override
    public boolean onValidate() {
        boolean bl = true;
        if (this.ncButton.isSelected() && this.lanCBModel.getSelectedItem().equals(LAN_CFG[0])) {
            bl = false;
        }
        return bl;
    }

    private boolean isMultiShelfSelectable() {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        List list = ((EntityTableModel)iChassisModel.getNodeModel().getEntityTable()).getModuleEntities();
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && bl) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!(entityModel instanceof ModuleModel)) continue;
            if (iChassisModel.isUTSChassis()) {
                if (this.isControllerSlot(iChassisModel, entityModel) || entityModel instanceof DwdmModuleModel || ((ModuleModel)entityModel).isOpticsCard() || this.isUTSModule(entityModel)) continue;
                bl = false;
                continue;
            }
            if (entityModel.getSlot() == 7 || entityModel.getSlot() == 11 || entityModel.getSlot() == 9 || entityModel.getSlot() > 17 || entityModel instanceof DwdmModuleModel || ((ModuleModel)entityModel).isOpticsCard() || entityModel.getEqType() == 238 || entityModel.getEqType() == 125) continue;
            bl = false;
        }
        return bl;
    }

    private boolean isControllerSlot(IChassisModel iChassisModel, EntityModel entityModel) {
        if (iChassisModel.isM6Chassis() && (entityModel.getSlot() == 1 || entityModel.getSlot() == 8)) {
            return true;
        }
        return iChassisModel.isM2Chassis() && (entityModel.getSlot() == 1 || entityModel.getSlot() == 1);
    }

    private boolean isUTSModule(EntityModel entityModel) {
        if (entityModel.getGenericClass() == 4) {
            return true;
        }
        return entityModel.getAncestorOfEqType(78) != null;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    private class VlanAttr
    extends NumberTextField {
        private boolean isEnabled;
        private short MIN;
        private short MAX;

        public VlanAttr() {
            super(4);
            this.isEnabled = false;
            this.MIN = 1;
            this.MAX = (short)4094;
        }

        public void init() {
            this.getDocument().addDocumentListener(SppMultishelfConfigPane.this);
            this.setEnabled(false);
        }

        public void enableEdit(short s) {
            if (!this.isEnabled) {
                this.setText(Short.toString(s));
                this.setEditable(true);
                this.setEnabled(true);
                this.isEnabled = true;
            }
        }

        public void disableEdit() {
            this.setText("");
            this.setEnabled(false);
            this.isEnabled = false;
        }

        public short getValue() {
            if (this.isEnabled) {
                return Short.parseShort(this.getText());
            }
            return 0;
        }

        public boolean validateUserInput(short s) {
            short s2 = this.getValue();
            if (s2 < this.MIN || s2 > this.MAX) {
                ErrorMsg.displayError(this, EMC.EID_MS_VLAN_RANGE_ERROR_PARAM_2, this.MIN, this.MAX);
                this.setText(Short.toString(s));
                return false;
            }
            return true;
        }
    }
}

