/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.nodesetup.NodeSetupController;
import cerent.cms.ui.nodesetup.NodeSetupShow;
import cerent.cms.ui.nodesetup.NodeSetupShowLogDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooserPanel;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SppNodeSetupPane
extends AbstractProvPane
implements ActionListener {
    private JPanel xmlPane;
    private PersistentFileChooserPanel setupFile;
    private PersistentFileChooserPanel logFile;
    private final ButtonGroup typeBG = new ButtonGroup();
    private JRadioButton fromNodeFRB;
    private JRadioButton fromNetFRB;
    private JRadioButton fromFileFRB;
    private JButton showXml;
    private JButton showLog;
    private String xmlOnNode = null;
    private final NodeModelDelegate nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    private static final SDebug db = new SDebug("SppNodeSetupPane");

    public SppNodeSetupPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.createXmlFilePanel());
        jPanel.add(this.createLogFilePanel());
        this.add(jPanel, "Center");
        if (db.on()) {
            db.println("init: finish");
        }
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane, "Center");
        this.setupFile.clearCombo();
        this.logFile.clearCombo();
        this.setDirty(true);
        if (SppNodeSetupPane.isUserAuthorized(this.nodeModel, SecurityLevel.PROVISIONING)) {
            this.enableButtons();
        } else {
            this.logFile.setEnabled(false);
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return new CSHelpID("NodeSetup");
    }

    private JPanel createXmlFilePanel() {
        this.xmlPane = new JPanel(new GridBagLayout());
        this.xmlPane.setBorder(BorderFactory.createTitledBorder("Xml"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.fromNodeFRB = this.addRB("Load latest installation file from node.", gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fromNetFRB = this.addRB("Load installation file from network repository.", gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fromFileFRB = this.addRB("Select xml file: ", gridBagConstraints);
        this.typeBG.setSelected(this.fromFileFRB.getModel(), true);
        this.setupFile = new PersistentFileChooserPanel(null, false, "", "", 10);
        gridBagConstraints.gridx = 1;
        this.xmlPane.add((Component)this.setupFile, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.xmlPane.add((Component)new JPanel(), gridBagConstraints);
        return this.xmlPane;
    }

    private JPanel createLogFilePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Log"));
        this.logFile = new PersistentFileChooserPanel("Select log file: ", false, "", "", 10);
        jPanel.add((Component)this.logFile);
        return jPanel;
    }

    private JRadioButton addRB(String string, GridBagConstraints gridBagConstraints) {
        JRadioButton jRadioButton = new JRadioButton(string);
        this.typeBG.add(jRadioButton);
        jRadioButton.addActionListener(this);
        this.xmlPane.add((Component)jRadioButton, gridBagConstraints);
        return jRadioButton;
    }

    @Override
    protected AbstractButton[] getExtraButtons() {
        this.showXml = new JButton("Show XML...");
        this.showXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SppNodeSetupPane.this.showXml();
            }
        });
        this.showLog = new JButton("Show Log...");
        this.showLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SppNodeSetupPane.this.showLog();
            }
        });
        return new JButton[]{this.showXml, this.showLog};
    }

    @Override
    public void enteringPage() {
        try {
            this.refreshFromModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    protected AbstractLeavePageException createLeavePageException(String string) {
        return null;
    }

    private String getFileName() {
        return this.setupFile.getSelectedFileName();
    }

    private String getLogFileName() {
        return this.logFile.getSelectedFileName();
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void refreshFromModel() throws Exception {
    }

    @Override
    public void customBehaviour() {
        this.setupFile.initCombo();
        this.logFile.initCombo();
        this.setDirty(true);
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.xmlOnNode = this.fromNodeFRB.isSelected() ? this.nodeModel.getNodeSetupModel().readInstXMLFile() : null;
        String string = this.checkCombosContent();
        if (string.equalsIgnoreCase("ok")) {
            String string2 = this.getLogFileName();
            File file = new File(string2);
            if (this.fromNodeFRB.isSelected()) {
                new NodeSetupController((AbstractPane)this, this.nodeModel, this.xmlOnNode, file, db);
            } else if (this.fromNetFRB.isSelected()) {
                new NodeSetupController(this, this.nodeModel, file, db);
            } else {
                String string3 = this.getFileName();
                File file2 = new File(string3);
                new NodeSetupController((AbstractPane)this, this.nodeModel, file2, file, db);
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_NODESETUP_MISSING_INFO, (Object)string);
        }
    }

    private String checkCombosContent() {
        boolean bl;
        boolean bl2 = bl = !this.fromFileFRB.isSelected();
        if (!bl && this.getFileName().equals("") && this.getLogFileName().equals("")) {
            return "Please specify a log and xml file.";
        }
        if (this.getLogFileName().equals("")) {
            return "Please specify a log file.";
        }
        if (!bl && this.getFileName().equals("")) {
            return "Please specify an xml file.";
        }
        if (this.fromNodeFRB.isSelected() && (this.xmlOnNode == null || this.xmlOnNode.length() == 0)) {
            return "No CTP Configuration files present on node.";
        }
        return "ok";
    }

    private void showXml() {
        if (this.fromNodeFRB.isSelected()) {
            String string = this.nodeModel.getNodeSetupModel().readInstXMLFile();
            if (string.length() > 0) {
                new NodeSetupShow((AbstractPane)this, this.nodeModel, string, db);
            } else {
                CerentDialog.warningDialog((Component)((Object)this), (String)"CTP XML installation file is not present on node");
            }
        } else if (this.fromFileFRB.isSelected()) {
            if (this.getFileName().equals("")) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_NODESETUP_MISSING_INFO, (Object)"Please specify an xml file.");
            } else {
                new NodeSetupShow((AbstractPane)this, this.nodeModel, new File(this.getFileName()), db);
            }
        } else {
            db.warning("Invalid selection");
        }
    }

    private void showLog() {
        String string = this.nodeModel.getNodeSetupModel().readInstLogFile();
        if (string.length() > 0) {
            NodeSetupShowLogDialog.instance(JOptionPane.getFrameForComponent((Component)((Object)this)), string);
        } else {
            CerentDialog.warningDialog((Component)((Object)this), (String)"Log message is not present on node");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setupFile.setEnabled(this.fromFileFRB.isSelected());
        this.enableButtons();
    }

    private void enableButtons() {
        this.showXml.setEnabled(!this.fromNetFRB.isSelected());
        this.showLog.setEnabled(this.fromNodeFRB.isSelected());
    }
}

