/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProtectionGroupModels;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.PgColumnRenderer;
import cerent.cms.ui.shelf.PgCreationDialog;
import cerent.cms.ui.shelf.PgEditDialog;
import cerent.cms.ui.shelf.PgRowObject;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import com.cisco.ctc454.model.PlatformNodeModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SppProtectionPane
extends AbstractShelfEditTablePane {
    private ProtectionGroupModels protectionGroupModels = null;
    private ElementModelsDelegate elementModelsDelegate = null;
    private JDialog currentDialog = null;
    protected static final SDebug db = new SDebug("SppProtectionPane");

    public SppProtectionPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private boolean isOPGSwitched(OnePlusOneModel onePlusOneModel) {
        try {
            PortModel portModel;
            InterfaceModel interfaceModel;
            EntityModel entityModel = (EntityModel)onePlusOneModel.getProtectEntityModel();
            if (entityModel instanceof PortModel && (interfaceModel = (InterfaceModel)(portModel = (PortModel)entityModel).getInterfaceModel()) instanceof TdmLineModel) {
                TdmLineModel tdmLineModel = (TdmLineModel)interfaceModel;
                return tdmLineModel.isCurrentlyActive();
            }
            return false;
        }
        catch (Exception exception) {
            db.println("Caught exception in isOPGSwitched");
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    private boolean isYPGSwitched(YCableModel yCableModel) {
        boolean bl = false;
        try {
            PortModel portModel;
            InterfaceModel interfaceModel;
            EntityModel entityModel = (EntityModel)yCableModel.getProtectEntityModel();
            if (entityModel instanceof PortModel && ((interfaceModel = (InterfaceModel)(portModel = (PortModel)entityModel).getInterfaceModel()) instanceof DwdmCliLineModel || interfaceModel instanceof DwdmOTULineModel)) {
                AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)interfaceModel;
                bl = abstractDwdmLineModel.isCurrentlyActive();
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in isOPGSwitched");
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    private boolean isProtectionGroupDeleteable(Model model) {
        boolean bl = true;
        IPlatform iPlatform = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform();
        if (iPlatform.is310ma() || iPlatform.is310maSDH()) {
            bl = !(model instanceof ProtectionGroupModel);
        } else if (iPlatform.is327()) {
            bl = !(model instanceof ProtectionGroupModel) || !((ProtectionGroupModel)model).getName().equals("XTCPROTGRP");
        } else if (iPlatform.is454() || iPlatform.is455()) {
            try {
                bl = !(model instanceof YCableModel) || this.isOtu2XPModel(((YCableModel)model).getMainEntityModel()) || ((YCableModel)model).getType() != 5;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                abstractCmsNoSuchEntityException.printStackTrace();
            }
        }
        return bl;
    }

    private boolean isOtu2XPModel(IEntityModel iEntityModel) {
        return iEntityModel.getModuleModel().getEqType() == 293;
    }

    @Override
    protected void initModels() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.protectionGroupModels = nodeModelDelegate.getProtectionGroupModels();
        this.elementModelsDelegate = nodeModelDelegate.getElementModelsDelegate();
        PgRowDataSource pgRowDataSource = new PgRowDataSource();
        this.model = new SortableRowTableModel((RowDataSource)pgRowDataSource, PgColumnRenderer.createColumnRenderers());
    }

    @Override
    protected void localInit() {
        super.localInit();
        IPlatform iPlatform = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform();
        if (!iPlatform.supportsOnePlusOneOpt()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            TableColumn tableColumn = null;
            tableColumn = this.table.getColumn(this.model.getColumnName(7));
            tableColumnModel.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.model.getColumnName(8));
            tableColumnModel.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.model.getColumnName(9));
            tableColumnModel.removeColumn(tableColumn);
        }
    }

    @Override
    protected void createTableEntry() {
        this.currentDialog = PgCreationDialog.instance(this);
        this.currentDialog.show();
        this.currentDialog = null;
    }

    @Override
    protected void editSelectedTableEntry(int n) {
        PgRowObject pgRowObject = (PgRowObject)this.model.getValueAt(n, 0);
        this.currentDialog = new PgEditDialog(this, (NodeModelDelegate)this.getUiModel().getNodeModel(), pgRowObject.model, db);
        this.currentDialog.show();
        this.currentDialog = null;
    }

    @Override
    protected void deleteSelectedTableEntry(int n) {
        block22: {
            PgRowObject pgRowObject = (PgRowObject)this.model.getValueAt(n, 0);
            ProtectionGroupModel protectionGroupModel = null;
            OnePlusOneModel onePlusOneModel = null;
            YCableModel yCableModel = null;
            String string = "";
            if (pgRowObject.model instanceof ProtectionGroupModel) {
                protectionGroupModel = (ProtectionGroupModel)pgRowObject.model;
                string = protectionGroupModel.getName();
            } else if (pgRowObject.model instanceof OnePlusOneModel) {
                onePlusOneModel = (OnePlusOneModel)pgRowObject.model;
                string = onePlusOneModel.getName();
            } else if (pgRowObject.model instanceof YCableModel) {
                yCableModel = (YCableModel)pgRowObject.model;
                string = yCableModel.getName();
            }
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)(EMC.WID_PROT_SWITCH_DELETE_WARNING + "Do you really want to delete the \n" + string + " Protection Group?"), (String)"Delete Protection Group")) {
                this.setEditDeleteEnabled(false);
                try {
                    if (protectionGroupModel != null) {
                        try {
                            protectionGroupModel.delete();
                            break block22;
                        }
                        catch (ResourceInUse resourceInUse) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PROTECT_IN_USE);
                            return;
                        }
                    }
                    if (onePlusOneModel != null) {
                        try {
                            onePlusOneModel.delete();
                        }
                        catch (CmsObjectNotExistException cmsObjectNotExistException) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ONE_PLUS_ONE_NOT_EXIST);
                        }
                    } else if (yCableModel != null) {
                        try {
                            yCableModel.delete();
                        }
                        catch (CmsObjectNotExistException cmsObjectNotExistException) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_Y_CABLE_NOT_EXIST);
                        }
                        catch (EMCProvisionError eMCProvisionError) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID());
                        }
                    }
                }
                catch (Busy busy) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_TOPO_ELE_IN_USE);
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID());
                }
                catch (Exception exception) {
                    db.println("Caught exception in deleteSelectedTableEntry!");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_DELETE_PROT_GROUP, exception.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        Object object;
        ArrayList<ProtectionGroupModel> arrayList = new ArrayList<ProtectionGroupModel>();
        if (this.getUiModel() instanceof PlatformNodeModel || this.getUiModel() instanceof com.cisco.ctc455.model.PlatformNodeModel || this.getUiModel() instanceof com.cisco.ctcutsX.model.PlatformNodeModel || this.getUiModel() instanceof com.cisco.ctcutsXsdh.model.PlatformNodeModel) {
            db.finest("Retrieving L2 1+1 protection groups");
            arrayList.addAll(this.elementModelsDelegate.getElementsOfType(eElementType.ONE_PLUS_ONE_L2.value()));
        } else {
            object = (IChassisModel)this.getUiModel();
            db.finest("Retrieving electrical protection groups");
            arrayList.addAll(Arrays.asList(this.protectionGroupModels.getProtectionGroupModelArray((IChassisModel)object)));
            db.finest("Retrieving 1+1 protection groups");
            arrayList.addAll(this.elementModelsDelegate.getElementsOfType((IChassisModel)object, eElementType.ONE_PLUS_ONE.value()));
            db.finest("Retrieving Y-Cable protection groups");
            arrayList.addAll(this.elementModelsDelegate.getElementsOfType((IChassisModel)object, eElementType.Y_CABLE.value()));
            db.finest("Retrieving Splitter protection groups");
            arrayList.addAll(this.elementModelsDelegate.getElementsOfType((IChassisModel)object, eElementType.SPLITTER.value()));
            db.finest("Retrieving L2 1+1 protection groups");
            arrayList.addAll(this.elementModelsDelegate.getElementsOfType(eElementType.ONE_PLUS_ONE_L2.value()));
        }
        db.finest("Preparing PgRowObject containers count=" + arrayList.size());
        object = this.tableData;
        synchronized (object) {
            this.tableData.clear();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.tableData.add(new PgRowObject((Model)arrayList.get(i), db));
            }
            Collections.sort(this.tableData);
        }
        db.finest("Registering...");
        this.registerWithModels();
        db.finest("Retrieval/update completed");
    }

    @Override
    protected void registerWithModels() {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.reset();
        iObservableManager.addObservable((Observable)((Object)this.elementModelsDelegate));
        iObservableManager.addObservable((Observable)((Object)this.protectionGroupModels));
        for (int i = 0; i < this.tableData.size(); ++i) {
            PgRowObject pgRowObject = (PgRowObject)this.tableData.get(i);
            iObservableManager.addObservable((Observable)((Object)pgRowObject.model));
        }
        iObservableManager.setActive(true);
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    @Override
    public void setEditDeleteEnabled(boolean bl) {
        int n;
        super.setEditDeleteEnabled(bl);
        if (this.deleteButton.isEnabled() && (n = this.table.getSelectedRow()) >= 0 && n < this.model.getRowCount()) {
            PgRowObject pgRowObject = (PgRowObject)this.model.getValueAt(n, 0);
            if (!this.isProtectionGroupDeleteable(pgRowObject.model)) {
                WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.currentDialog != null) {
            try {
                this.currentDialog.dispose();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        super.destroy();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SppProtectionPane;
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            SppProtectionPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SppProtectionPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class PgRowDataSource
    extends AbstractRowDataSource {
        PgRowDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = SppProtectionPane.this.tableData;
            synchronized (list) {
                var2_2 = SppProtectionPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = SppProtectionPane.this.tableData;
            synchronized (list) {
                n = SppProtectionPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = SppProtectionPane.this.tableData;
            synchronized (list) {
                return SppProtectionPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return PgRowObject.class;
        }
    }
}

