/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpConfig;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStaticRoute;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.StaticRoute;
import cerent.cms.ui.NetMaskHelper;
import cerent.cms.ui.NodeProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StaticRouteAttributesPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    static final String DEFAULT_IP_ADDRESS = "";
    static final String DEFAULT_NET_MASK = "255.255.255.0";
    static final String DEFAULT_COST = "2";
    protected INodeModel nodeModel;
    protected IStaticRoute myStaticRoute = new StaticRoute();
    protected JTextField destTF;
    protected JTextField maskTF;
    protected JTextField nextHopTF;
    protected JTextField costTF;
    JLabel destination;
    JLabel mask;
    JLabel hop;
    JLabel cost;
    private static final SDebug db = new SDebug("StaticRouteAttributesPane");

    public void setStaticRoute(IStaticRoute iStaticRoute) {
        this.myStaticRoute = iStaticRoute;
        this.refresh();
    }

    public IStaticRoute getStaticRoute() {
        return this.myStaticRoute;
    }

    protected StaticRouteAttributesPane(String string, INodeModel iNodeModel) {
        super(string, (IModel)iNodeModel, null);
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.add(this.createAttributesPanel(), "Center");
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    @Override
    public void destroy() {
        this.nodeModel = null;
        super.destroy();
    }

    protected void customInit() {
        this.destination = new JLabel("Destination: ");
        this.mask = new JLabel("Mask: ");
        this.hop = new JLabel("Next Hop: ");
        this.cost = new JLabel("Cost: ");
        this.destTF = new JTextField(DEFAULT_IP_ADDRESS);
        this.destTF.setPreferredSize(new Dimension(105, 21));
        this.maskTF = new JTextField(DEFAULT_NET_MASK);
        try {
            IIpConfig iIpConfig = this.nodeModel.getIpConfig();
            if (db.on()) {
                db.println("got ipConfig");
            }
            String string = InetUtil.makeDottedString(iIpConfig.getIpAddress());
            String string2 = string.substring(0, string.lastIndexOf(".")) + ".1";
            this.nextHopTF = new JTextField(string2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught Exception " + exception);
            }
            this.nextHopTF = new JTextField(DEFAULT_IP_ADDRESS);
        }
        this.costTF = new JTextField(DEFAULT_COST);
    }

    protected JPanel buildAttributesPanel() {
        this.customInit();
        this.destination.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.destination);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.destTF.setPreferredSize(new Dimension(105, 21));
        jPanel2.add(this.destTF);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel createAttributesPanel() {
        this.customInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.destination.setSize(90, 21);
        this.destination.setLocation(0, 0);
        this.destTF.setSize(105, 21);
        this.destTF.setLocation(100, 0);
        jPanel.add(this.destination);
        jPanel.add(this.destTF);
        this.mask.setSize(90, 21);
        this.maskTF.setSize(105, 21);
        this.mask.setLocation(0, 25);
        this.maskTF.setLocation(100, 25);
        jPanel.add(this.mask);
        jPanel.add(this.maskTF);
        this.hop.setSize(90, 21);
        this.nextHopTF.setSize(105, 21);
        this.hop.setLocation(0, 50);
        this.nextHopTF.setLocation(100, 50);
        jPanel.add(this.hop);
        jPanel.add(this.nextHopTF);
        this.cost.setSize(90, 21);
        this.costTF.setSize(105, 21);
        this.cost.setLocation(0, 75);
        this.costTF.setLocation(100, 75);
        jPanel.add(this.cost);
        jPanel.add(this.costTF);
        this.destTF.getDocument().addDocumentListener(this);
        this.maskTF.getDocument().addDocumentListener(this);
        this.nextHopTF.getDocument().addDocumentListener(this);
        this.costTF.getDocument().addDocumentListener(this);
        return jPanel;
    }

    protected String formatInternalSubnets() {
        String string;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nodeModel;
            IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
            if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(ipSubnetArray[0]);
                for (int i = 1; i < ipSubnetArray.length; ++i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(ipSubnetArray[i]);
                }
                stringBuffer.append(")");
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            string = DEFAULT_IP_ADDRESS;
        }
        return string;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
        boolean bl = this.isUserAuthorized((IModel)this.nodeModel);
    }

    @Override
    public boolean onValidate() {
        try {
            byte[] byArray = InetAddress.getByName(this.destTF.getText()).getAddress();
            if (byArray.length > 4) {
                throw new UnknownHostException();
            }
            this.myStaticRoute.setIpAddress(InetUtil.makeIpAddr(this.destTF.getText()));
        }
        catch (UnknownHostException unknownHostException) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_INVALID_ADDRESS_TYPE_PARAM_2, "destination", this.destTF.getText());
            return false;
        }
        try {
            this.myStaticRoute.setNextHop(InetUtil.makeIpAddr(this.nextHopTF.getText()));
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_INVALID_ADDRESS_TYPE_PARAM_2, "next hop", this.nextHopTF.getText());
            return false;
        }
        int n = 0;
        try {
            n = InetUtil.parseDottedString(this.maskTF.getText());
            this.myStaticRoute.setNetMaskPrefixLength(NetMaskHelper.calculateNetMaskLength(n));
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_MASK_PARAM_1, (Object)this.maskTF.getText());
            return false;
        }
        boolean bl = false;
        try {
            short s = Short.parseShort(this.costTF.getText());
            if (s >= 1 && s <= Short.MAX_VALUE) {
                bl = true;
            }
            if (bl) {
                this.myStaticRoute.setCost(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_STATIC_ROUTE_COST);
            return false;
        }
        return true;
    }

    @Override
    public void refreshFromModel() throws Exception {
        String string = InetUtil.makeDottedString(this.myStaticRoute.getIpAddress());
        String string2 = InetUtil.makeDottedString(this.myStaticRoute.getNextHop());
        short s = this.myStaticRoute.getCost();
        int n = InetUtil.makeNetMask(this.myStaticRoute.getNetMaskPrefixLength());
        String string3 = InetUtil.makeDottedString(n);
        this.nextHopTF.setText(string2);
        this.costTF.setText(Integer.toString(s));
        this.maskTF.setText(string3);
        this.destTF.setText(string);
        super.refreshFromModel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected void documentModified(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.destTF.getDocument()) {
            String string = this.destTF.getText();
            if (string.equals("0.0.0.0")) {
                this.maskTF.setText("0.0.0.0");
                this.maskTF.setEnabled(false);
                try {
                    IIpConfig iIpConfig = this.nodeModel.getIpConfig();
                    String string2 = InetUtil.makeDottedString(iIpConfig.getDefaultRouter());
                    if (!string2.equals("0.0.0.0") && !string2.equals(DEFAULT_IP_ADDRESS)) {
                        this.nextHopTF.setText(string2);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else {
                this.maskTF.setEnabled(true);
                this.nextHopTF.setEnabled(true);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public Dimension getPreferredSize() {
        return new Dimension(220, 110);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("StaticRouteAttributesPane Unit Test");
        jFrame.setSize(300, 200);
        jFrame.getContentPane().add((Component)((Object)new StaticRouteAttributesPane(DEFAULT_IP_ADDRESS, null)));
        jFrame.setVisible(true);
    }
}

