/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IStaticRoute;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.SppNetworkPane;
import cerent.cms.ui.shelf.StaticRouteCreateDialog;
import cerent.cms.ui.shelf.StaticRouteEditDialog;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JTable;

public class StaticRoutePane
extends AbstractShelfEditTablePane {
    public static final int STATIC_ROUTE_DESTINATION = 0;
    public static final int STATIC_ROUTE_MASK = 1;
    public static final int STATIC_ROUTE_NEXT_HOP = 2;
    public static final int STATIC_ROUTE_COST = 3;
    private static final SDebug db = new SDebug((KDebug)SppNetworkPane.db, "StaticRoutePane");

    public StaticRoutePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.ENTRY_TYPE = "Static Route";
    }

    @Override
    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new DestinationColumnRenderer(), new MaskColumnRenderer(), new NextHopColumnRenderer(), new CostColumnRenderer()};
        StaticRouteRowSource staticRouteRowSource = new StaticRouteRowSource();
        this.model = new SortableRowTableModel((RowDataSource)staticRouteRowSource, columnRendererArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            IStaticRoute[] iStaticRouteArray = this.nodeModel.getOspfStaticRoutes();
            int n = iStaticRouteArray.length;
            for (int i = 0; i < n; ++i) {
                this.tableData.add(iStaticRouteArray[i]);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private void dumpStaticRoute(IStaticRoute iStaticRoute) {
        String string = InetUtil.makeDottedString(iStaticRoute.getIpAddress());
        String string2 = InetUtil.makeDottedString(InetUtil.makeNetMask(iStaticRoute.getNetMaskPrefixLength()));
        String string3 = InetUtil.makeDottedString(iStaticRoute.getNextHop());
        Integer n = new Integer(iStaticRoute.getCost());
        String string4 = n.toString();
        db.println(" ");
        db.println("Destination :" + string);
        db.println("Mask :" + string2);
        db.println("NextHop :" + string3);
        db.println("Cost :" + string4);
    }

    @Override
    protected void createTableEntry() {
        StaticRouteCreateDialog staticRouteCreateDialog = StaticRouteCreateDialog.instance(this);
        staticRouteCreateDialog.show();
        staticRouteCreateDialog.dispose();
    }

    @Override
    protected void editSelectedTableEntry(int n) {
        IStaticRoute iStaticRoute = (IStaticRoute)this.model.getValueAt(n, 0);
        StaticRouteEditDialog staticRouteEditDialog = StaticRouteEditDialog.instance(this);
        if (iStaticRoute != null) {
            staticRouteEditDialog.setStaticRoute(iStaticRoute);
        }
        staticRouteEditDialog.show();
        staticRouteEditDialog.dispose();
    }

    @Override
    protected void deleteSelectedTableEntry(int n) {
        IStaticRoute iStaticRoute = (IStaticRoute)this.model.getValueAt(n, 0);
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure you want to delete  this static route?", (String)"Confirmation Dialog")) {
            this.setEditDeleteEnabled(false);
            this.nodeModel.deleteOspfStaticRoute(iStaticRoute.getIpAddress());
        }
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    @Override
    protected void registerWithModels() {
        this.registerWithModel();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.StaticRoutePane;
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 150;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(IStaticRoute iStaticRoute, int n) {
            String string = "???";
            if (iStaticRoute != null) {
                switch (n) {
                    case 0: {
                        string = InetUtil.makeDottedString(iStaticRoute.getIpAddress());
                        break;
                    }
                    case 1: {
                        string = InetUtil.makeDottedString(InetUtil.makeNetMask(iStaticRoute.getNetMaskPrefixLength()));
                        break;
                    }
                    case 2: {
                        string = InetUtil.makeDottedString(iStaticRoute.getNextHop());
                        break;
                    }
                    case 3: {
                        Integer n2 = new Integer(iStaticRoute.getCost());
                        string = n2.toString();
                    }
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            IStaticRoute iStaticRoute = (IStaticRoute)jTable.getValueAt(n, 0);
            String string = this.getStringValue(iStaticRoute, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            jLabel.setForeground(Color.black);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((IStaticRoute)object, n);
            String string2 = this.getStringValue((IStaticRoute)object2, n);
            return string.compareTo(string2);
        }
    }

    class CostColumnRenderer
    extends BaseColumnRenderer {
        CostColumnRenderer() {
        }

        @Override
        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "Cost";
        }
    }

    class DestinationColumnRenderer
    extends BaseColumnRenderer {
        DestinationColumnRenderer() {
        }

        public String getName() {
            return "Destination";
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            StaticRoutePane.this.resetObservableManager();
            StaticRoutePane.this.registerWithModels();
            StaticRoutePane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            StaticRoutePane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)StaticRoutePane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class MaskColumnRenderer
    extends BaseColumnRenderer {
        MaskColumnRenderer() {
        }

        public String getName() {
            return "Mask";
        }
    }

    class NextHopColumnRenderer
    extends BaseColumnRenderer {
        NextHopColumnRenderer() {
        }

        public String getName() {
            return "Next Hop";
        }
    }

    class StaticRouteRowSource
    extends AbstractRowDataSource {
        StaticRouteRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = StaticRoutePane.this.tableData;
            synchronized (list) {
                var2_2 = StaticRoutePane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = StaticRoutePane.this.tableData;
            synchronized (list) {
                n = StaticRoutePane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = StaticRoutePane.this.tableData;
            synchronized (list) {
                return StaticRoutePane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return IStaticRoute.class;
        }
    }
}

