/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.ui.ppm.PpmCard;
import cerent.cms.ui.ppm.PpmSlot;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.DwdmPortGraphic;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.Observable;
import javax.swing.SwingUtilities;

public class TNCCard
extends CardGraphic {
    private static final float RECT_W_TO_CARD_W_RATIO = 0.20833333f;
    private static final float RECT_H_TO_RECT_W_RATIO = 0.5f;
    private static final float RECT_Y_OFFSET_TO_CARD_H_RATIO = 0.8979592f;
    private static final float LAN_Y_OFFSET_TO_CARD_H_RATIO = 0.76363635f;
    private final int RECT_WIDTH;
    private final int RECT_HEIGHT;
    private final int RECT_X_OFFSET;
    private final int RECT_Y_OFFSET;
    private final int LAN_Y_OFFSET;
    private final Rectangle lanRectangle;
    private final int cardWidth;
    private final int cardHeight;
    private int numPorts;
    private DwdmPortGraphic[] portGraphics = null;
    private TNCModuleModel mm = null;
    private PortModel[] portModels = null;
    private ObservableManager _obsMgr;
    private PpmSlot[] ppmSlots = new PpmSlot[0];
    private List ports;

    public TNCCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout);
        this.cardHeight = this.cardPainter.getCardHeight();
        this.cardWidth = this.cardPainter.getCardWidth();
        this.RECT_WIDTH = Math.round((float)this.cardWidth * 0.20833333f);
        this.RECT_HEIGHT = Math.round((float)this.RECT_WIDTH * 0.5f);
        this.RECT_X_OFFSET = (this.cardWidth - this.RECT_WIDTH) / 2;
        this.RECT_Y_OFFSET = Math.round((float)this.cardHeight * 0.8979592f - 12.0f);
        this.LAN_Y_OFFSET = Math.round((float)this.cardHeight * 0.76363635f);
        this.lanRectangle = new Rectangle(this.RECT_X_OFFSET - 65, this.RECT_Y_OFFSET - 4, this.RECT_WIDTH / 4, this.RECT_HEIGHT / 4 + 1);
        this.portGraphics = new DwdmPortGraphic[2];
        this.mm = (TNCModuleModel)entityModel;
        this._obsMgr = new ObservableManager(this, false);
        this.addPorts();
        this.registerForLocalUpdates();
    }

    protected void registerForLocalUpdates() {
        this._obsMgr.reset();
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }

    protected void addPorts() {
        this.ports = this.mm.getPpmPortModels();
        this.numPorts = this.ports.size();
        this.portModels = this.ports.toArray(new PortModel[0]);
        this.addPpmPorts();
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof EntityModel && this.entityM != null && this.entityM.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            this.db.info("update(): DwdmCard, From=" + observable + ", arg=" + n);
            if (n.equals(ModelUpdateType.ADDED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (this.db.on()) {
                    this.db.println("Port ADDED to MR_SLOT");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (this.db.on()) {
                    this.db.println("Port DELETED");
                }
            }
        }
    }

    protected void addPpmPorts() {
        if (this.mm.getEqType() == 330) {
            PluggableSlotModel[] pluggableSlotModelArray = this.mm.getPpmSlots();
            this.ppmSlots = new PpmSlot[pluggableSlotModelArray.length];
            for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
                this.ppmSlots[i] = new DwdmPpmSlot(pluggableSlotModelArray[i], this.parent, this.db, this.getPpmBounds(i));
            }
        }
    }

    protected Rectangle getPpmBounds(int n) {
        int n2 = this.cardPainter.getMiniPortWidth();
        int n3 = this.cardPainter.getMiniPortHeight();
        return new Rectangle(this.cardPainter.getPortX(1, n) + 140, this.cardPainter.getPortY(1, n), n2, n3);
    }

    @Override
    protected String getStateString() {
        if (this.eqState == null) {
            return "";
        }
        return ElementDefaults.eqStateToOCNString(this.eqState);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.lanRectangle);
        Font font = graphics2D.getFont();
        graphics2D.setFont(font.deriveFont((float)(font.getSize() - 1)));
        graphics2D.setColor(Color.black);
        String string = "LAN";
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = (this.cardWidth - fontMetrics.stringWidth(string)) / 2;
        graphics2D.drawString(string, n3 - 75, this.LAN_Y_OFFSET - 2);
        graphics2D.setFont(font);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            this.ppmSlots[i].draw(graphics2D);
        }
        graphics2D.setColor(color);
    }

    @Override
    public String getEqLabel() {
        String string;
        block5: {
            string = this.entityM.getEqLabel();
            List list = this.entityM.getMfgEntities();
            MfgEntityModel mfgEntityModel = null;
            if (list.size() > 0) {
                mfgEntityModel = (MfgEntityModel)list.get(0);
            }
            if (mfgEntityModel != null) {
                try {
                    if (mfgEntityModel.getMfgData().name.equals("TCC2")) {
                        string = "TNC";
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    @Override
    public void dispose() {
        this.localDispose();
        super.dispose();
    }

    protected void localDispose() {
        int n;
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        for (n = 0; n < this.ppmSlots.length; ++n) {
            if (this.ppmSlots[n] == null) continue;
            this.ppmSlots[n].dispose();
        }
        this.ppmSlots = new PpmSlot[0];
        for (n = 0; n < this.portGraphics.length; ++n) {
            if (this.portGraphics[n] == null) continue;
            this.portGraphics[n].dispose();
        }
        this.portGraphics = new DwdmPortGraphic[0];
    }

    static /* synthetic */ DwdmPortGraphic[] access$302(TNCCard tNCCard, DwdmPortGraphic[] dwdmPortGraphicArray) {
        tNCCard.portGraphics = dwdmPortGraphicArray;
        return dwdmPortGraphicArray;
    }

    private static class DwdmPpmCard
    extends PpmCard {
        public DwdmPpmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
            super(entityModel, abstractShelfLayout, sDebug, rectangle);
        }

        @Override
        protected OpticalPortGraphic createPortGraphic(int n, int n2, PortModel portModel) {
            return new DwdmPortGraphic(this, n, n2, portModel);
        }

        @Override
        protected OpticalPortGraphic createPortGraphic(int n, int n2, int n3, int n4, PortModel portModel) {
            return new DwdmPortGraphic(this, n, n2, n3, n4, portModel);
        }
    }

    private static class DwdmPpmSlot
    extends PpmSlot {
        public DwdmPpmSlot(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
            super(entityModel, abstractShelfLayout, sDebug, rectangle);
        }

        @Override
        protected PpmCard createPpmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
            return new DwdmPpmCard(entityModel, abstractShelfLayout, sDebug, rectangle);
        }
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    TNCCard.this.localDispose();
                    if (TNCCard.this.mm != null) {
                        TNCCard.this.ports = TNCCard.this.mm.getPpmPortModels();
                        TNCCard.this.numPorts = TNCCard.this.ports.size();
                        TNCCard.access$302(TNCCard.this, new DwdmPortGraphic[TNCCard.this.numPorts]);
                        TNCCard.this.addPorts();
                        TNCCard.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!TNCCard.this.db.on()) break block4;
                    TNCCard.this.db.println("Error replacing port: " + exception);
                    SDebug cfr_ignored_0 = TNCCard.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            TNCCard.this.validate();
            TNCCard.this.repaint();
        }
    }
}

